<?php
// Debug mode - remove in production
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
header('Content-Type: application/json');
require_once 'includes/config.php';

// JSON input'u parse et
$input = json_decode(file_get_contents('php://input'), true);

$user_id = $_SESSION['user_id'] ?? null;
$site_id = isset($input['site_id']) ? intval($input['site_id']) : (isset($_POST['site_id']) ? intval($_POST['site_id']) : 0);
$action = isset($input['action']) ? $input['action'] : (isset($_POST['action']) ? $_POST['action'] : null);
$vote_type = isset($input['vote_type']) && in_array($input['vote_type'], ['upvote','downvote']) ? $input['vote_type'] : 
             (isset($_POST['vote_type']) && in_array($_POST['vote_type'], ['upvote','downvote']) ? $_POST['vote_type'] : null);
$ip = $_SERVER['REMOTE_ADDR'] ?? '';

// Eğer sadece vote sayılarını almak istiyorsa
if ($action === 'get_votes') {
    if (!$site_id) {
        echo json_encode(['error' => 'Site ID required']);
        exit;
    }
    
    $voteStmt = $pdo->prepare('SELECT 
      SUM(vote_type = "upvote") AS upvotes,
      SUM(vote_type = "downvote") AS downvotes
      FROM site_votes WHERE site_id = ?');
    $voteStmt->execute([$site_id]);
    $votes = $voteStmt->fetch(PDO::FETCH_ASSOC);
    
    echo json_encode([
        'upvotes' => intval($votes['upvotes'] ?? 0),
        'downvotes' => intval($votes['downvotes'] ?? 0)
    ]);
    exit;
}

// Oy verme işlemi için gerekli kontroller
if (!$user_id) {
    echo json_encode([
        'success' => false,
        'error' => 'Giriş yapmadan oy veremezsiniz.',
        'login_required' => true
    ]);
    exit;
}

if (!$site_id || !$vote_type) {
    $error = [
        'success' => false,
        'error' => 'Geçersiz istek',
        'details' => [
            'user_id' => $user_id ? 'OK' : 'Missing',
            'site_id' => $site_id ? 'OK' : 'Missing',
            'vote_type' => $vote_type ? 'OK' : 'Missing',
            'ip' => $ip ? 'OK' : 'Missing',
            'action' => $action
        ]
    ];
    echo json_encode($error);
    exit;
}

// Aynı user_id veya aynı IP'den bir kere oy verilebilir
$checkParams = [$ip, $site_id];
$checkSql = 'SELECT id FROM site_votes WHERE ip = ? AND site_id = ?';
if ($user_id) {
    $checkSql = 'SELECT id FROM site_votes WHERE (user_id = ? OR ip = ?) AND site_id = ?';
    $checkParams = [$user_id, $ip, $site_id];
}

$stmt = $pdo->prepare($checkSql);
$stmt->execute($checkParams);
if ($stmt->fetch()) {
    // Zaten oy vermiş
    $voteStmt = $pdo->prepare('SELECT 
      SUM(vote_type = "upvote") AS upvotes,
      SUM(vote_type = "downvote") AS downvotes
      FROM site_votes WHERE site_id = ?');
    $voteStmt->execute([$site_id]);
    $votes = $voteStmt->fetch(PDO::FETCH_ASSOC);
    echo json_encode([
        'success' => false,
        'upvotes' => intval($votes['upvotes'] ?? 0),
        'downvotes' => intval($votes['downvotes'] ?? 0),
        'total_votes' => intval($votes['upvotes'] ?? 0) + intval($votes['downvotes'] ?? 0),
        'message' => 'Zaten oy vermişsiniz.'
    ]);
    exit;
}

// Oy kaydet
$insert = $pdo->prepare('INSERT INTO site_votes (user_id, site_id, vote_type, ip) VALUES (?, ?, ?, ?)');
$insert->execute([$user_id, $site_id, $vote_type, $ip]);

// Toplam oyları çek
$voteStmt = $pdo->prepare('SELECT 
  SUM(vote_type = "upvote") AS upvotes,
  SUM(vote_type = "downvote") AS downvotes
  FROM site_votes WHERE site_id = ?');
$voteStmt->execute([$site_id]);
$votes = $voteStmt->fetch(PDO::FETCH_ASSOC);

echo json_encode([
    'success' => true,
    'upvotes' => intval($votes['upvotes'] ?? 0),
    'downvotes' => intval($votes['downvotes'] ?? 0),
    'total_votes' => intval($votes['upvotes'] ?? 0) + intval($votes['downvotes'] ?? 0),
    'message' => 'Oy başarıyla kaydedildi!'
]);
