<?php
require_once '../config.php';
requireAdmin();

$pageTitle = 'Reklam Düzenle';
$id = (int)($_GET['id'] ?? 0);
$isEdit = $id > 0;

$errors = [];
$success = '';

// Get advertisement data if editing
$ad = [
    'title' => '',
    'position' => $_GET['position'] ?? 'slider_top',
    'type' => 'image',
    'content' => '',
    'link' => '',
    'target' => '_blank',
    'is_active' => 1,
    'display_order' => 0,
    'start_date' => '',
    'end_date' => ''
];

if ($isEdit) {
    $stmt = $pdo->prepare('SELECT * FROM advertisements WHERE id = ?');
    $stmt->execute([$id]);
    $fetchedAd = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$fetchedAd) {
        header('Location: advertisements.php');
        exit;
    }
    
    $ad = $fetchedAd;
    $pageTitle = 'Reklam Düzenle: ' . $ad['title'];
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!verifyCSRFToken($_POST['csrf_token'] ?? '')) {
        $errors[] = 'Güvenlik doğrulaması başarısız!';
    } else {
        $title = trim($_POST['title'] ?? '');
        $position = $_POST['position'] ?? 'slider_top';
        $type = $_POST['type'] ?? 'image';
        $link = trim($_POST['link'] ?? '');
        $target = $_POST['target'] ?? '_blank';
        $is_active = isset($_POST['is_active']) ? 1 : 0;
        $display_order = (int)($_POST['display_order'] ?? 0);
        $start_date = !empty($_POST['start_date']) ? $_POST['start_date'] : null;
        $end_date = !empty($_POST['end_date']) ? $_POST['end_date'] : null;
        
        // Get content based on type
        $content = '';
        if ($type === 'image') {
            // Check if file upload
            if (isset($_FILES['image_upload']) && $_FILES['image_upload']['error'] === UPLOAD_ERR_OK) {
                $uploadDir = '../uploads/advertisements/';
                if (!is_dir($uploadDir)) {
                    mkdir($uploadDir, 0755, true);
                }
                
                $fileExtension = strtolower(pathinfo($_FILES['image_upload']['name'], PATHINFO_EXTENSION));
                $allowedExtensions = ['jpg', 'jpeg', 'png', 'gif', 'webp'];
                
                if (in_array($fileExtension, $allowedExtensions)) {
                    $fileName = uniqid() . '.' . $fileExtension;
                    $targetPath = $uploadDir . $fileName;
                    
                    if (move_uploaded_file($_FILES['image_upload']['tmp_name'], $targetPath)) {
                        $content = '/uploads/advertisements/' . $fileName;
                        
                        // Delete old image if exists and updating
                        if ($isEdit && !empty($ad['content']) && strpos($ad['content'], '/uploads/advertisements/') === 0) {
                            $oldFile = '..' . $ad['content'];
                            if (file_exists($oldFile)) {
                                unlink($oldFile);
                            }
                        }
                    } else {
                        $errors[] = 'Dosya yüklenirken bir hata oluştu.';
                    }
                } else {
                    $errors[] = 'Geçersiz dosya formatı. Sadece JPG, PNG, GIF ve WEBP destekleniyor.';
                }
            } else {
                $content = trim($_POST['image_url'] ?? '');
            }
        } else {
            $content = trim($_POST['content_' . $type] ?? '');
        }
        
        // Validation
        if (empty($title)) {
            $errors[] = 'Reklam başlığı gereklidir.';
        }
        if (empty($content)) {
            $errors[] = 'Reklam içeriği gereklidir.';
        }
        
        if (empty($errors)) {
            try {
                if ($isEdit) {
                    $stmt = $pdo->prepare('
                        UPDATE advertisements 
                        SET title = ?, position = ?, type = ?, content = ?, link = ?, target = ?, 
                            is_active = ?, display_order = ?, start_date = ?, end_date = ?
                        WHERE id = ?
                    ');
                    $stmt->execute([
                        $title, $position, $type, $content, $link, $target,
                        $is_active, $display_order, $start_date, $end_date, $id
                    ]);
                    $success = 'Reklam başarıyla güncellendi!';
                } else {
                    $stmt = $pdo->prepare('
                        INSERT INTO advertisements 
                        (title, position, type, content, link, target, is_active, display_order, start_date, end_date)
                        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
                    ');
                    $stmt->execute([
                        $title, $position, $type, $content, $link, $target,
                        $is_active, $display_order, $start_date, $end_date
                    ]);
                    $success = 'Reklam başarıyla eklendi!';
                    $id = $pdo->lastInsertId();
                    $isEdit = true;
                }
                
                // Refresh data
                $stmt = $pdo->prepare('SELECT * FROM advertisements WHERE id = ?');
                $stmt->execute([$id]);
                $ad = $stmt->fetch(PDO::FETCH_ASSOC);
                
            } catch (Throwable $e) {
                $errors[] = 'Bir hata oluştu: ' . $e->getMessage();
            }
        }
    }
}

$positions = [
    'slider_top' => 'Slider Üstü',
    'slider_bottom' => 'Slider Altı',
    'category_top' => 'Kategoriler Üstü',
    'category_bottom' => 'Kategoriler Altı',
    'footer_top' => 'Footer Üstü'
];

include 'includes/admin-header.php';
?>

<div class="dashboard-container">
    <div class="mb-4">
        <a href="advertisements.php" class="btn btn-outline-secondary btn-sm mb-3">
            <i class="fas fa-arrow-left me-2"></i>
            Reklamlara Dön
        </a>
        
        <h1 class="h3 mb-2">
            <i class="fas <?= $isEdit ? 'fa-edit' : 'fa-plus' ?> me-2"></i>
            <?= $isEdit ? 'Reklam Düzenle' : 'Yeni Reklam Ekle' ?>
        </h1>
        <p class="text-muted mb-0">Reklam bilgilerini girin ve kaydedin</p>
    </div>

    <?php if (!empty($success)): ?>
        <div class="alert alert-success alert-dismissible fade show">
            <i class="fas fa-check-circle me-2"></i>
            <?= htmlspecialchars($success) ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <?php if (!empty($errors)): ?>
        <div class="alert alert-danger alert-dismissible fade show">
            <i class="fas fa-exclamation-circle me-2"></i>
            <ul class="mb-0">
                <?php foreach ($errors as $error): ?>
                    <li><?= htmlspecialchars($error) ?></li>
                <?php endforeach; ?>
            </ul>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <form method="post" enctype="multipart/form-data">
        <input type="hidden" name="csrf_token" value="<?= generateCSRFToken() ?>">
        
        <div class="row">
            <div class="col-lg-8">
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="mb-0">Genel Bilgiler</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label fw-semibold">
                                Reklam Başlığı <span class="text-danger">*</span>
                            </label>
                            <input type="text" 
                                   name="title" 
                                   class="form-control" 
                                   value="<?= htmlspecialchars($ad['title']) ?>" 
                                   required>
                            <small class="text-muted">Yönetim panelinde görünecek başlık</small>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-semibold">
                                    Konum <span class="text-danger">*</span>
                                </label>
                                <select name="position" class="form-select" required>
                                    <?php foreach ($positions as $key => $label): ?>
                                        <option value="<?= $key ?>" <?= $ad['position'] === $key ? 'selected' : '' ?>>
                                            <?= $label ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>

                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-semibold">
                                    Reklam Türü <span class="text-danger">*</span>
                                </label>
                                <select name="type" id="adType" class="form-select" required>
                                    <option value="image" <?= $ad['type'] === 'image' ? 'selected' : '' ?>>
                                        Resim (Banner)
                                    </option>
                                    <option value="html" <?= $ad['type'] === 'html' ? 'selected' : '' ?>>
                                        HTML Kodu
                                    </option>
                                    <option value="script" <?= $ad['type'] === 'script' ? 'selected' : '' ?>>
                                        JavaScript Kodu (Adsense vb.)
                                    </option>
                                </select>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-semibold">
                                İçerik <span class="text-danger">*</span>
                            </label>
                            
                            <!-- Image Content -->
                            <div id="imageContent" class="content-type" style="display: <?= $ad['type'] === 'image' ? 'block' : 'none' ?>">
                                <ul class="nav nav-tabs mb-3" id="imageContentTabs" role="tablist">
                                    <li class="nav-item" role="presentation">
                                        <button class="nav-link active" id="url-tab" data-bs-toggle="tab" data-bs-target="#url-content" type="button" role="tab">
                                            <i class="fas fa-link me-1"></i> Link
                                        </button>
                                    </li>
                                    <li class="nav-item" role="presentation">
                                        <button class="nav-link" id="upload-tab" data-bs-toggle="tab" data-bs-target="#upload-content" type="button" role="tab">
                                            <i class="fas fa-upload me-1"></i> Yükle
                                        </button>
                                    </li>
                                </ul>
                                
                                <div class="tab-content" id="imageContentTabContent">
                                    <div class="tab-pane fade show active" id="url-content" role="tabpanel">
                                        <input type="text" 
                                               name="image_url" 
                                               id="image_url"
                                               class="form-control mb-2" 
                                               value="<?= htmlspecialchars($ad['content']) ?>" 
                                               placeholder="https://example.com/banner.jpg">
                                        <small class="text-muted">Banner resim URL'sini girin</small>
                                    </div>
                                    <div class="tab-pane fade" id="upload-content" role="tabpanel">
                                        <input type="file" 
                                               name="image_upload" 
                                               id="image_upload"
                                               class="form-control mb-2" 
                                               accept="image/jpeg,image/jpg,image/png,image/gif,image/webp">
                                        <small class="text-muted">PC'den resim yükleyin (JPG, PNG, GIF, WEBP)</small>
                                    </div>
                                </div>
                                
                                <?php if ($ad['type'] === 'image' && !empty($ad['content'])): ?>
                                    <div class="mt-3">
                                        <img src="<?= htmlspecialchars($ad['content']) ?>" 
                                             alt="Preview" 
                                             class="img-thumbnail" 
                                             style="max-width: 100%; max-height: 200px;">
                                    </div>
                                <?php endif; ?>
                            </div>
                            
                            <!-- HTML Content -->
                            <div id="htmlContent" class="content-type" style="display: <?= $ad['type'] === 'html' ? 'block' : 'none' ?>">
                                <textarea name="content_html" 
                                          class="form-control font-monospace" 
                                          rows="8" 
                                          placeholder="<div>HTML kodunuzu buraya yazın...</div>"><?= $ad['type'] === 'html' ? htmlspecialchars($ad['content']) : '' ?></textarea>
                                <small class="text-muted">HTML kodunu girin</small>
                            </div>
                            
                            <!-- Script Content -->
                            <div id="scriptContent" class="content-type" style="display: <?= $ad['type'] === 'script' ? 'block' : 'none' ?>">
                                <textarea name="content_script" 
                                          class="form-control font-monospace" 
                                          rows="8" 
                                          placeholder="<script>...</script>"><?= $ad['type'] === 'script' ? htmlspecialchars($ad['content']) : '' ?></textarea>
                                <small class="text-muted">JavaScript kodunu girin (Google Adsense vb.)</small>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-semibold">Link (İsteğe Bağlı)</label>
                            <input type="url" 
                                   name="link" 
                                   class="form-control" 
                                   value="<?= htmlspecialchars($ad['link']) ?>" 
                                   placeholder="https://example.com">
                            <small class="text-muted">Reklamın tıklanıldığında gideceği URL (sadece resim türü için)</small>
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-semibold">Link Hedefi</label>
                            <div>
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" 
                                           type="radio" 
                                           name="target" 
                                           id="target_blank" 
                                           value="_blank" 
                                           <?= $ad['target'] === '_blank' ? 'checked' : '' ?>>
                                    <label class="form-check-label" for="target_blank">
                                        Yeni sekmede aç
                                    </label>
                                </div>
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" 
                                           type="radio" 
                                           name="target" 
                                           id="target_self" 
                                           value="_self" 
                                           <?= $ad['target'] === '_self' ? 'checked' : '' ?>>
                                    <label class="form-check-label" for="target_self">
                                        Aynı sekmede aç
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="mb-0">Ayarlar</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label fw-semibold">Sıralama</label>
                            <input type="number" 
                                   name="display_order" 
                                   class="form-control" 
                                   value="<?= $ad['display_order'] ?>" 
                                   min="0">
                            <small class="text-muted">Küçük sayılar önce gösterilir</small>
                        </div>

                        <div class="mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" 
                                       type="checkbox" 
                                       name="is_active" 
                                       id="is_active" 
                                       <?= $ad['is_active'] ? 'checked' : '' ?>>
                                <label class="form-check-label fw-semibold" for="is_active">
                                    Aktif
                                </label>
                            </div>
                            <small class="text-muted">Reklamın sitede gösterilmesini sağlar</small>
                        </div>

                        <hr>

                        <div class="mb-3">
                            <label class="form-label fw-semibold">Başlangıç Tarihi</label>
                            <input type="datetime-local" 
                                   name="start_date" 
                                   class="form-control" 
                                   value="<?= $ad['start_date'] ? date('Y-m-d\TH:i', strtotime($ad['start_date'])) : '' ?>">
                            <small class="text-muted">Boş bırakılırsa hemen başlar</small>
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-semibold">Bitiş Tarihi</label>
                            <input type="datetime-local" 
                                   name="end_date" 
                                   class="form-control" 
                                   value="<?= $ad['end_date'] ? date('Y-m-d\TH:i', strtotime($ad['end_date'])) : '' ?>">
                            <small class="text-muted">Boş bırakılırsa süresiz gösterilir</small>
                        </div>

                        <?php if ($isEdit): ?>
                            <hr>
                            <div class="mb-2">
                                <small class="text-muted">
                                    <i class="fas fa-eye me-1"></i>
                                    Görüntülenme: <strong><?= number_format($ad['views_count']) ?></strong>
                                </small>
                            </div>
                            <div>
                                <small class="text-muted">
                                    <i class="fas fa-mouse-pointer me-1"></i>
                                    Tıklama: <strong><?= number_format($ad['clicks_count']) ?></strong>
                                </small>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="d-grid gap-2">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save me-2"></i>
                        Kaydet
                    </button>
                    <a href="advertisements.php" class="btn btn-outline-secondary">
                        <i class="fas fa-times me-2"></i>
                        İptal
                    </a>
                </div>
            </div>
        </div>
    </form>
</div>

<script>
document.getElementById('adType').addEventListener('change', function() {
    const type = this.value;
    
    document.querySelectorAll('.content-type').forEach(el => {
        el.style.display = 'none';
    });
    
    if (type === 'image') {
        document.getElementById('imageContent').style.display = 'block';
    } else if (type === 'html') {
        document.getElementById('htmlContent').style.display = 'block';
    } else if (type === 'script') {
        document.getElementById('scriptContent').style.display = 'block';
    }
});

// Image preview for uploaded files
document.getElementById('image_upload')?.addEventListener('change', function(e) {
    const file = e.target.files[0];
    if (file && file.type.startsWith('image/')) {
        const reader = new FileReader();
        reader.onload = function(e) {
            let preview = document.querySelector('#upload-content + div.mt-3 img');
            if (!preview) {
                const previewDiv = document.createElement('div');
                previewDiv.className = 'mt-3';
                previewDiv.innerHTML = '<img src="" alt="Preview" class="img-thumbnail" style="max-width: 100%; max-height: 200px;">';
                document.querySelector('#imageContentTabContent').after(previewDiv);
                preview = previewDiv.querySelector('img');
            }
            preview.src = e.target.result;
        };
        reader.readAsDataURL(file);
    }
});

// Clear file input when switching to URL tab
document.getElementById('url-tab')?.addEventListener('click', function() {
    const fileInput = document.getElementById('image_upload');
    if (fileInput) {
        fileInput.value = '';
    }
});

// Clear URL input when switching to upload tab
document.getElementById('upload-tab')?.addEventListener('click', function() {
    const urlInput = document.getElementById('image_url');
    if (urlInput) {
        urlInput.value = '';
    }
});
</script>

<?php include 'includes/admin-footer.php'; ?>

