<?php
require_once '../config.php';
requireAdmin();

$pageTitle = 'Reklam Yönetimi';

// Handle delete
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'delete') {
    if (!verifyCSRFToken($_POST['csrf_token'] ?? '')) {
        setFlashMessage('Güvenlik doğrulaması başarısız!', 'danger');
    } else {
        $id = (int)($_POST['id'] ?? 0);
        $stmt = $pdo->prepare('DELETE FROM advertisements WHERE id = ?');
        if ($stmt->execute([$id])) {
            setFlashMessage('Reklam başarıyla silindi.', 'success');
        } else {
            setFlashMessage('Reklam silinirken bir hata oluştu.', 'danger');
        }
    }
    header('Location: advertisements.php');
    exit;
}

// Handle toggle active
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'toggle') {
    if (!verifyCSRFToken($_POST['csrf_token'] ?? '')) {
        setFlashMessage('Güvenlik doğrulaması başarısız!', 'danger');
    } else {
        $id = (int)($_POST['id'] ?? 0);
        $stmt = $pdo->prepare('UPDATE advertisements SET is_active = NOT is_active WHERE id = ?');
        if ($stmt->execute([$id])) {
            setFlashMessage('Reklam durumu güncellendi.', 'success');
        } else {
            setFlashMessage('Durum güncellenirken hata oluştu.', 'danger');
        }
    }
    header('Location: advertisements.php');
    exit;
}

// Get all advertisements
$stmt = $pdo->query('SELECT * FROM advertisements ORDER BY position, display_order ASC');
$ads = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Group by position
$groupedAds = [];
foreach ($ads as $ad) {
    $groupedAds[$ad['position']][] = $ad;
}

$positions = [
    'slider_top' => 'Slider Üstü',
    'slider_bottom' => 'Slider Altı',
    'category_top' => 'Kategoriler Üstü',
    'category_bottom' => 'Kategoriler Altı',
    'footer_top' => 'Footer Üstü'
];

include 'includes/admin-header.php';
?>

<div class="dashboard-container">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-2">
                <i class="fas fa-ad me-2"></i>
                Reklam Yönetimi
            </h1>
            <p class="text-muted mb-0">Sitenizde görünecek reklamları yönetin</p>
        </div>
        <a href="advertisement-edit.php" class="btn btn-primary">
            <i class="fas fa-plus me-2"></i>
            Yeni Reklam Ekle
        </a>
    </div>

    <!-- Statistics -->
    <div class="row g-3 mb-4">
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-shrink-0">
                            <div class="avatar avatar-md bg-primary-subtle text-primary rounded-3">
                                <i class="fas fa-ad fs-4"></i>
                            </div>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <h6 class="text-muted mb-1">Toplam Reklam</h6>
                            <h3 class="mb-0"><?= count($ads) ?></h3>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-shrink-0">
                            <div class="avatar avatar-md bg-success-subtle text-success rounded-3">
                                <i class="fas fa-check-circle fs-4"></i>
                            </div>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <h6 class="text-muted mb-1">Aktif Reklam</h6>
                            <h3 class="mb-0"><?= count(array_filter($ads, fn($ad) => $ad['is_active'])) ?></h3>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-shrink-0">
                            <div class="avatar avatar-md bg-info-subtle text-info rounded-3">
                                <i class="fas fa-eye fs-4"></i>
                            </div>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <h6 class="text-muted mb-1">Toplam Görüntüleme</h6>
                            <h3 class="mb-0"><?= number_format(array_sum(array_column($ads, 'views_count'))) ?></h3>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-shrink-0">
                            <div class="avatar avatar-md bg-warning-subtle text-warning rounded-3">
                                <i class="fas fa-mouse-pointer fs-4"></i>
                            </div>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <h6 class="text-muted mb-1">Toplam Tıklama</h6>
                            <h3 class="mb-0"><?= number_format(array_sum(array_column($ads, 'clicks_count'))) ?></h3>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Advertisements by Position -->
    <?php foreach ($positions as $posKey => $posName): ?>
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-map-marker-alt me-2"></i>
                    <?= $posName ?>
                    <span class="badge bg-secondary ms-2">
                        <?= count($groupedAds[$posKey] ?? []) ?> reklam
                    </span>
                </h5>
            </div>
            <div class="card-body">
                <?php if (empty($groupedAds[$posKey])): ?>
                    <div class="text-center py-4">
                        <i class="fas fa-inbox fs-1 text-muted mb-3"></i>
                        <p class="text-muted">Bu konumda henüz reklam bulunmuyor.</p>
                        <a href="advertisement-edit.php?position=<?= $posKey ?>" class="btn btn-sm btn-outline-primary">
                            <i class="fas fa-plus me-1"></i>
                            Reklam Ekle
                        </a>
                    </div>
                <?php else: ?>
                    <div class="table-responsive">
                        <table class="table table-hover align-middle">
                            <thead>
                                <tr>
                                    <th style="width: 50px;">Sıra</th>
                                    <th>Başlık</th>
                                    <th style="width: 100px;">Tür</th>
                                    <th style="width: 120px;">Durum</th>
                                    <th style="width: 100px;">Görüntüleme</th>
                                    <th style="width: 100px;">Tıklama</th>
                                    <th style="width: 150px;" class="text-end">İşlemler</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($groupedAds[$posKey] as $ad): ?>
                                    <tr>
                                        <td>
                                            <span class="badge bg-light text-dark">
                                                <?= $ad['display_order'] ?>
                                            </span>
                                        </td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <?php if ($ad['type'] === 'image' && !empty($ad['content'])): ?>
                                                    <img src="<?= htmlspecialchars($ad['content']) ?>" 
                                                         alt="<?= htmlspecialchars($ad['title']) ?>" 
                                                         class="me-2 rounded" 
                                                         style="width: 60px; height: 40px; object-fit: cover;">
                                                <?php else: ?>
                                                    <div class="me-2 bg-light rounded d-flex align-items-center justify-content-center" 
                                                         style="width: 60px; height: 40px;">
                                                        <i class="fas fa-code text-muted"></i>
                                                    </div>
                                                <?php endif; ?>
                                                <div>
                                                    <div class="fw-semibold"><?= sanitize($ad['title']) ?></div>
                                                    <?php if ($ad['link']): ?>
                                                        <small class="text-muted">
                                                            <i class="fas fa-link me-1"></i>
                                                            <?= sanitize(substr($ad['link'], 0, 40)) ?>...
                                                        </small>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <?php
                                            $typeLabels = [
                                                'image' => '<span class="badge bg-primary"><i class="fas fa-image me-1"></i>Resim</span>',
                                                'html' => '<span class="badge bg-info"><i class="fas fa-code me-1"></i>HTML</span>',
                                                'script' => '<span class="badge bg-warning"><i class="fas fa-file-code me-1"></i>Script</span>'
                                            ];
                                            echo $typeLabels[$ad['type']] ?? $ad['type'];
                                            ?>
                                        </td>
                                        <td>
                                            <form method="post" class="d-inline">
                                                <input type="hidden" name="csrf_token" value="<?= generateCSRFToken() ?>">
                                                <input type="hidden" name="action" value="toggle">
                                                <input type="hidden" name="id" value="<?= $ad['id'] ?>">
                                                <button type="submit" class="btn btn-sm <?= $ad['is_active'] ? 'btn-success' : 'btn-secondary' ?>">
                                                    <i class="fas fa-<?= $ad['is_active'] ? 'check' : 'times' ?>"></i>
                                                    <?= $ad['is_active'] ? 'Aktif' : 'Pasif' ?>
                                                </button>
                                            </form>
                                        </td>
                                        <td>
                                            <span class="text-muted">
                                                <i class="fas fa-eye me-1"></i>
                                                <?= number_format($ad['views_count']) ?>
                                            </span>
                                        </td>
                                        <td>
                                            <span class="text-muted">
                                                <i class="fas fa-mouse-pointer me-1"></i>
                                                <?= number_format($ad['clicks_count']) ?>
                                            </span>
                                        </td>
                                        <td class="text-end">
                                            <div class="btn-group btn-group-sm">
                                                <a href="advertisement-edit.php?id=<?= $ad['id'] ?>" 
                                                   class="btn btn-outline-primary" 
                                                   title="Düzenle">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <form method="post" class="d-inline">
                                                    <input type="hidden" name="csrf_token" value="<?= generateCSRFToken() ?>">
                                                    <input type="hidden" name="action" value="delete">
                                                    <input type="hidden" name="id" value="<?= $ad['id'] ?>">
                                                    <button type="submit" 
                                                            class="btn btn-outline-danger confirm-delete" 
                                                            title="Sil">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    <?php endforeach; ?>
</div>

<style>
.avatar {
    width: 48px;
    height: 48px;
    display: flex;
    align-items: center;
    justify-content: center;
}

.avatar-md {
    width: 56px;
    height: 56px;
}

.bg-primary-subtle {
    background-color: rgba(99, 102, 241, 0.1);
}

.bg-success-subtle {
    background-color: rgba(16, 185, 129, 0.1);
}

.bg-info-subtle {
    background-color: rgba(59, 130, 246, 0.1);
}

.bg-warning-subtle {
    background-color: rgba(245, 158, 11, 0.1);
}
</style>

<?php include 'includes/admin-footer.php'; ?>

