<?php
require_once '../config.php';
requireAdmin();

// Kod ekleme
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_code'])) {
    if (!verifyCSRFToken($_POST['csrf_token'] ?? '')) {
        flashMessage('danger', 'Güvenlik hatası.');
    } else {
        $product_id = $_POST['product_id'];
        $code = trim($_POST['code']);
        
        try {
            $stmt = $pdo->prepare("INSERT INTO product_codes (product_id, code) VALUES (?, ?)");
            $stmt->execute([$product_id, $code]);
            
            flashMessage('success', 'Kod başarıyla eklendi.');
            redirect('codes.php');
        } catch (PDOException $e) {
            flashMessage('danger', 'Kod eklenemedi: ' . $e->getMessage());
        }
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_marketplace_code'])) {
    if (!verifyCSRFToken($_POST['csrf_token'] ?? '')) {
        flashMessage('danger', 'Güvenlik hatası.');
    } else {
        $serverId = (int)($_POST['server_id'] ?? 0);
        $code = trim($_POST['code'] ?? '');

        if ($serverId <= 0 || $code === '') {
            flashMessage('danger', 'Lütfen ürün ve kod bilgisini girin.');
        } else {
            try {
                $stmt = $pdo->prepare('INSERT INTO game_marketplace_codes (server_id, code) VALUES (?, ?)');
                $stmt->execute([$serverId, $code]);

                flashMessage('success', 'Marketplace kodu eklendi.');
                redirect('codes.php?tab=marketplace');
            } catch (PDOException $e) {
                flashMessage('danger', 'Kod eklenemedi: ' . $e->getMessage());
            }
        }
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['bulk_add_marketplace'])) {
    if (!verifyCSRFToken($_POST['csrf_token'] ?? '')) {
        flashMessage('danger', 'Güvenlik hatası.');
    } else {
        $serverId = (int)($_POST['server_id'] ?? 0);
        $codesRaw = $_POST['codes'] ?? '';
        $codes = array_filter(array_map('trim', explode("\n", $codesRaw)));

        if ($serverId <= 0 || empty($codes)) {
            flashMessage('danger', 'Lütfen ürün seçin ve en az bir kod girin.');
        } else {
            try {
                $pdo->beginTransaction();
                $stmt = $pdo->prepare('INSERT INTO game_marketplace_codes (server_id, code) VALUES (?, ?)');
                $count = 0;
                foreach ($codes as $code) {
                    if ($code === '') {
                        continue;
                    }
                    $stmt->execute([$serverId, $code]);
                    $count++;
                }

                $pdo->commit();
                flashMessage('success', $count . ' marketplace kodu eklendi.');
                redirect('codes.php?tab=marketplace');
            } catch (Throwable $th) {
                $pdo->rollBack();
                flashMessage('danger', 'Kodlar eklenemedi: ' . $th->getMessage());
            }
        }
    }
}

// Toplu kod ekleme
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['bulk_add'])) {
    if (!verifyCSRFToken($_POST['csrf_token'] ?? '')) {
        flashMessage('danger', 'Güvenlik hatası.');
    } else {
        $product_id = $_POST['product_id'];
        $codes = explode("\n", $_POST['codes']);
        $added = 0;
        
        try {
            $pdo->beginTransaction();
            $stmt = $pdo->prepare("INSERT INTO product_codes (product_id, code) VALUES (?, ?)");
            
            foreach ($codes as $code) {
                $code = trim($code);
                if (!empty($code)) {
                    $stmt->execute([$product_id, $code]);
                    $added++;
                }
            }
            
            $pdo->commit();
            flashMessage('success', "$added kod başarıyla eklendi.");
            redirect('codes.php');
        } catch (Exception $e) {
            $pdo->rollBack();
            flashMessage('danger', 'Kodlar eklenemedi: ' . $e->getMessage());
        }
    }
}

if (isset($_GET['delete_marketplace_code'])) {
    $codeId = (int)$_GET['delete_marketplace_code'];
    if ($codeId > 0) {
        try {
            $stmt = $pdo->prepare('SELECT server_id, is_sold FROM game_marketplace_codes WHERE id = ?');
            $stmt->execute([$codeId]);
            $codeData = $stmt->fetch();

            if ($codeData && !$codeData['is_sold']) {
                $pdo->prepare('DELETE FROM game_marketplace_codes WHERE id = ?')->execute([$codeId]);
                $pdo->prepare('UPDATE game_marketplace_servers SET sell_stock = GREATEST(sell_stock - 1, 0) WHERE id = ?')->execute([$codeData['server_id']]);
                flashMessage('success', 'Kod silindi ve stok güncellendi.');
            } else {
                flashMessage('danger', 'Teslim edilmiş kod silinemez.');
            }
        } catch (PDOException $e) {
            flashMessage('danger', 'Silme başarısız: ' . $e->getMessage());
        }
    }
    redirect('codes.php?tab=marketplace');
}

// Kod silme
if (isset($_GET['delete'])) {
    try {
        $stmt = $pdo->prepare("SELECT product_id, is_sold FROM product_codes WHERE id = ?");
        $stmt->execute([$_GET['delete']]);
        $codeData = $stmt->fetch();
        
        if ($codeData && !$codeData['is_sold']) {
            $pdo->prepare("DELETE FROM product_codes WHERE id = ?")->execute([$_GET['delete']]);
            $pdo->prepare("UPDATE products SET stock = stock - 1 WHERE id = ?")->execute([$codeData['product_id']]);
            flashMessage('success', 'Kod silindi ve stok güncellendi.');
        } else {
            flashMessage('danger', 'Satılmış kod silinemez.');
        }
    } catch (PDOException $e) {
        flashMessage('danger', 'Silme başarısız: ' . $e->getMessage());
    }
    redirect('codes.php');
}

// Filtreler
$product_filter = $_GET['product'] ?? '';
$status_filter = $_GET['status'] ?? '';

$sql = "SELECT pc.*, p.name as product_name, u.username 
        FROM product_codes pc 
        JOIN products p ON pc.product_id = p.id 
        LEFT JOIN users u ON pc.sold_to_user_id = u.id 
        WHERE 1=1";

$params = [];

if ($product_filter) {
    $sql .= " AND pc.product_id = ?";
    $params[] = $product_filter;
}

if ($status_filter === 'sold') {
    $sql .= " AND pc.is_sold = 1";
} elseif ($status_filter === 'available') {
    $sql .= " AND pc.is_sold = 0";
}

$sql .= " ORDER BY pc.created_at DESC LIMIT 100";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$codes = $stmt->fetchAll();

// Ürünler listesi
$products = $pdo->query("SELECT id, name, stock FROM products WHERE is_active = 1 ORDER BY name ASC")->fetchAll();

$marketplaceServers = $pdo->query('
    SELECT s.id, s.name, s.sell_stock, c.name AS category_name, m.name AS marketplace_name
    FROM game_marketplace_servers s
    JOIN game_marketplace_categories c ON c.id = s.category_id
    JOIN game_marketplaces m ON m.id = c.marketplace_id
    WHERE s.is_active = 1
    ORDER BY m.name ASC, c.name ASC, s.name ASC
')->fetchAll();

$server_filter = $_GET['server'] ?? '';
$marketplace_status_filter = $_GET['mstatus'] ?? '';

$marketplaceCodesSql = '
    SELECT mc.*, s.name AS server_name, c.name AS category_name, m.name AS marketplace_name, u.username
    FROM game_marketplace_codes mc
    JOIN game_marketplace_servers s ON s.id = mc.server_id
    JOIN game_marketplace_categories c ON c.id = s.category_id
    JOIN game_marketplaces m ON m.id = c.marketplace_id
    LEFT JOIN users u ON u.id = mc.sold_to_user_id
    WHERE 1=1';

$marketplaceParams = [];

if ($server_filter) {
    $marketplaceCodesSql .= ' AND mc.server_id = ?';
    $marketplaceParams[] = $server_filter;
}

if ($marketplace_status_filter === 'sold') {
    $marketplaceCodesSql .= ' AND mc.is_sold = 1';
} elseif ($marketplace_status_filter === 'available') {
    $marketplaceCodesSql .= ' AND mc.is_sold = 0';
}

$marketplaceCodesSql .= ' ORDER BY mc.created_at DESC LIMIT 200';
$marketplaceStmt = $pdo->prepare($marketplaceCodesSql);
$marketplaceStmt->execute($marketplaceParams);
$marketplaceCodes = $marketplaceStmt->fetchAll();

$tab = $_GET['tab'] ?? 'product';

$pageTitle = 'Ürün Kodları';
include 'includes/admin-header.php';
?>

<div class="dashboard-container">
    <div class="mb-4">
        <ul class="nav nav-pills">
            <li class="nav-item">
                <a class="nav-link <?= $tab === 'product' ? 'active' : '' ?>" href="codes.php?tab=product">Mağaza Ürün Kodları</a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?= $tab === 'marketplace' ? 'active' : '' ?>" href="codes.php?tab=marketplace">Marketplace Ürün Kodları</a>
            </li>
        </ul>
    </div>

    <?php if ($tab === 'product'): ?>
    <div class="row g-4">
        <div class="col-lg-4">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">
                        <i class="fas fa-plus me-2"></i>Tek Kod Ekle
                    </h5>
                </div>
                <div class="card-body">
                    <form method="POST" action="?tab=product">
                        <input type="hidden" name="csrf_token" value="<?= generateCSRFToken() ?>">
                        <input type="hidden" name="add_code" value="1">
                        
                        <div class="mb-3">
                            <label class="form-label">Ürün</label>
                            <select class="form-select" name="product_id" required>
                                <option value="">Ürün Seçin...</option>
                                <?php foreach ($products as $p): ?>
                                <option value="<?= $p['id'] ?>"><?= sanitize($p['name']) ?> (Stok: <?= $p['stock'] ?>)</option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Kod</label>
                            <input type="text" class="form-control" name="code" required placeholder="XXXXX-XXXXX-XXXXX">
                        </div>
                        
                        <button type="submit" class="btn btn-primary w-100">
                            <i class="fas fa-plus-circle me-2"></i>Kod Ekle
                        </button>
                    </form>
                </div>
            </div>
        </div>
        
        <div class="col-lg-4">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">
                        <i class="fas fa-layer-group me-2"></i>Toplu Kod Ekle
                    </h5>
                </div>
                <div class="card-body">
                    <form method="POST" action="?tab=product">
                        <input type="hidden" name="csrf_token" value="<?= generateCSRFToken() ?>">
                        <input type="hidden" name="bulk_add" value="1">
                        
                        <div class="mb-3">
                            <label class="form-label">Ürün</label>
                            <select class="form-select" name="product_id" required>
                                <option value="">Ürün Seçin...</option>
                                <?php foreach ($products as $p): ?>
                                <option value="<?= $p['id'] ?>"><?= sanitize($p['name']) ?> (Stok: <?= $p['stock'] ?>)</option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Kodlar (Her satıra bir kod)</label>
                            <textarea class="form-control" name="codes" rows="5" required placeholder="XXXXX-XXXXX-XXXXX&#10;YYYYY-YYYYY-YYYYY&#10;ZZZZZ-ZZZZZ-ZZZZZ"></textarea>
                        </div>
                        
                        <button type="submit" class="btn btn-primary w-100">
                            <i class="fas fa-upload me-2"></i>Toplu Ekle
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">
                <i class="fas fa-key me-2"></i>Ürün Kodları
            </h5>
            <div class="d-flex gap-2">
                <select class="form-select form-select-sm" style="width: 200px;" onchange="location.href='?product='+this.value+'&status=<?= $status_filter ?>'">
                    <option value="">Tüm Ürünler</option>
                    <?php foreach ($products as $p): ?>
                    <option value="<?= $p['id'] ?>" <?= $product_filter == $p['id'] ? 'selected' : '' ?>>
                        <?= sanitize($p['name']) ?>
                    </option>
                    <?php endforeach; ?>
                </select>
                
                <select class="form-select form-select-sm" style="width: 150px;" onchange="location.href='?product=<?= $product_filter ?>&status='+this.value">
                    <option value="">Tüm Durumlar</option>
                    <option value="available" <?= $status_filter === 'available' ? 'selected' : '' ?>>Mevcut</option>
                    <option value="sold" <?= $status_filter === 'sold' ? 'selected' : '' ?>>Satıldı</option>
                </select>
            </div>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Ürün</th>
                            <th>Kod</th>
                            <th>Durum</th>
                            <th>Satıldı</th>
                            <th>Tarih</th>
                            <th>İşlem</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($codes as $code): ?>
                        <tr>
                            <td><strong>#<?= $code['id'] ?></strong></td>
                            <td><?= sanitize($code['product_name']) ?></td>
                            <td><code><?= sanitize($code['code']) ?></code></td>
                            <td>
                                <?php if ($code['is_sold']): ?>
                                <span class="badge bg-danger">Satıldı</span>
                                <?php else: ?>
                                <span class="badge bg-success">Mevcut</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if ($code['is_sold']): ?>
                                    <?= sanitize($code['username']) ?><br>
                                    <small class="text-muted"><?= date('d.m.Y H:i', strtotime($code['sold_at'])) ?></small>
                                <?php else: ?>
                                <span class="text-muted">-</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <small><?= date('d.m.Y H:i', strtotime($code['created_at'])) ?></small>
                            </td>
                            <td>
                                <?php if (!$code['is_sold']): ?>
                                <a href="?delete=<?= $code['id'] ?>" class="btn btn-sm btn-outline-danger confirm-delete">
                                    <i class="fas fa-trash"></i>
                                </a>
                                <?php else: ?>
                                <span class="text-muted">-</span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <?php else: ?>
    <div class="row g-4">
        <div class="col-lg-4">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0"><i class="fas fa-plus me-2"></i>Marketplace Tek Kod Ekle</h5>
                </div>
                <div class="card-body">
                    <form method="POST" action="?tab=marketplace">
                        <input type="hidden" name="csrf_token" value="<?= generateCSRFToken() ?>">
                        <input type="hidden" name="add_marketplace_code" value="1">

                        <div class="mb-3">
                            <label class="form-label">Marketplace Ürünü</label>
                            <select class="form-select" name="server_id" required>
                                <option value="">Ürün Seçin...</option>
                                <?php foreach ($marketplaceServers as $server): ?>
                                    <option value="<?= $server['id'] ?>">
                                        <?= sanitize($server['marketplace_name'] . ' / ' . $server['category_name'] . ' / ' . $server['name']) ?> (Stok: <?= (int)$server['sell_stock'] ?>)
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Kod</label>
                            <input type="text" class="form-control" name="code" required placeholder="XXXXX-XXXXX-XXXXX">
                        </div>

                        <button type="submit" class="btn btn-primary w-100">
                            <i class="fas fa-plus-circle me-2"></i>Kod Ekle
                        </button>
                    </form>
                </div>
            </div>
        </div>
        <div class="col-lg-4">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0"><i class="fas fa-layer-group me-2"></i>Marketplace Toplu Kod Ekle</h5>
                </div>
                <div class="card-body">
                    <form method="POST" action="?tab=marketplace">
                        <input type="hidden" name="csrf_token" value="<?= generateCSRFToken() ?>">
                        <input type="hidden" name="bulk_add_marketplace" value="1">

                        <div class="mb-3">
                            <label class="form-label">Marketplace Ürünü</label>
                            <select class="form-select" name="server_id" required>
                                <option value="">Ürün Seçin...</option>
                                <?php foreach ($marketplaceServers as $server): ?>
                                    <option value="<?= $server['id'] ?>">
                                        <?= sanitize($server['marketplace_name'] . ' / ' . $server['category_name'] . ' / ' . $server['name']) ?> (Stok: <?= (int)$server['sell_stock'] ?>)
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Kodlar (Her satıra bir kod)</label>
                            <textarea class="form-control" name="codes" rows="5" required placeholder="XXXXX-XXXXX-XXXXX&#10;YYYYY-YYYYY-YYYYY"></textarea>
                        </div>

                        <button type="submit" class="btn btn-primary w-100">
                            <i class="fas fa-upload me-2"></i>Toplu Ekle
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0"><i class="fas fa-key me-2"></i>Marketplace Kodları</h5>
            <div class="d-flex gap-2">
                <select class="form-select form-select-sm" style="width: 260px;" onchange="location.href='?tab=marketplace&server='+this.value+'&mstatus=<?= $marketplace_status_filter ?>'">
                    <option value="">Tüm Ürünler</option>
                    <?php foreach ($marketplaceServers as $server): ?>
                        <option value="<?= $server['id'] ?>" <?= $server_filter == $server['id'] ? 'selected' : '' ?>>
                            <?= sanitize($server['marketplace_name'] . ' / ' . $server['category_name'] . ' / ' . $server['name']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>

                <select class="form-select form-select-sm" style="width: 150px;" onchange="location.href='?tab=marketplace&server=<?= $server_filter ?>&mstatus='+this.value">
                    <option value="">Tüm Durumlar</option>
                    <option value="available" <?= $marketplace_status_filter === 'available' ? 'selected' : '' ?>>Mevcut</option>
                    <option value="sold" <?= $marketplace_status_filter === 'sold' ? 'selected' : '' ?>>Teslim Edildi</option>
                </select>
            </div>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Pazar</th>
                            <th>Kategori</th>
                            <th>Ürün</th>
                            <th>Kod</th>
                            <th>Durum</th>
                            <th>Teslim</th>
                            <th>Oluşturma</th>
                            <th>İşlem</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($marketplaceCodes as $code): ?>
                        <tr>
                            <td><strong>#<?= $code['id'] ?></strong></td>
                            <td><?= sanitize($code['marketplace_name']) ?></td>
                            <td><?= sanitize($code['category_name']) ?></td>
                            <td><?= sanitize($code['server_name']) ?></td>
                            <td><code><?= sanitize($code['code']) ?></code></td>
                            <td>
                                <?php if ($code['is_sold']): ?>
                                    <span class="badge bg-danger">Teslim Edildi</span>
                                <?php else: ?>
                                    <span class="badge bg-success">Mevcut</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if ($code['is_sold']): ?>
                                    <?= sanitize($code['username'] ?? '-') ?><br>
                                    <small class="text-muted">Order #<?= (int)($code['order_id'] ?? 0) ?></small>
                                <?php else: ?>
                                    <span class="text-muted">-</span>
                                <?php endif; ?>
                            </td>
                            <td><small><?= date('d.m.Y H:i', strtotime($code['created_at'])) ?></small></td>
                            <td>
                                <?php if (!$code['is_sold']): ?>
                                    <a href="?tab=marketplace&delete_marketplace_code=<?= $code['id'] ?>" class="btn btn-sm btn-outline-danger confirm-delete">
                                        <i class="fas fa-trash"></i>
                                    </a>
                                <?php else: ?>
                                    <span class="text-muted">-</span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>

<?php include 'includes/admin-footer.php'; ?>
