<?php
require_once '../config.php';
requireAdmin();

$success = '';
$errors = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!verifyCSRFToken($_POST['csrf_token'] ?? '')) {
        $errors[] = 'Güvenlik hatası.';
    } else {
        $action = $_POST['action'] ?? '';
        
        if ($action === 'save_homepage_sections') {
            // Popüler Kategoriler
            $popular_categories = $_POST['popular_categories'] ?? [];
            $popular_categories_json = json_encode(array_map('intval', $popular_categories));
            saveSetting('homepage_popular_categories', $popular_categories_json);
            
            // Öne Çıkan Kategoriler
            $featured_categories = $_POST['featured_categories'] ?? [];
            $featured_categories_json = json_encode(array_map('intval', $featured_categories));
            saveSetting('homepage_featured_categories', $featured_categories_json);
            
            // Yeni Ürünler - Kategori
            $new_products_category = (int)($_POST['new_products_category'] ?? 0);
            saveSetting('homepage_new_products_category', $new_products_category);
            
            // Başlık İkonları
            saveSetting('homepage_icon_popular_categories', trim($_POST['icon_popular_categories'] ?? 'fa-solid fa-layer-group'));
            saveSetting('homepage_icon_featured_categories', trim($_POST['icon_featured_categories'] ?? 'fa-solid fa-fire'));
            saveSetting('homepage_icon_featured_products', trim($_POST['icon_featured_products'] ?? 'fa-solid fa-star'));
            saveSetting('homepage_icon_new_products', trim($_POST['icon_new_products'] ?? 'fa-solid fa-sparkles'));
            saveSetting('homepage_icon_best_sellers', trim($_POST['icon_best_sellers'] ?? 'fa-solid fa-trophy'));
            
            // Başlık İsimleri
            saveSetting('homepage_title_popular_categories', trim($_POST['title_popular_categories'] ?? 'Popüler kategoriler'));
            saveSetting('homepage_title_featured_categories', trim($_POST['title_featured_categories'] ?? 'Öne Çıkan Kategoriler'));
            saveSetting('homepage_title_featured_products', trim($_POST['title_featured_products'] ?? 'Öne çıkan ürünler'));
            saveSetting('homepage_title_new_products', trim($_POST['title_new_products'] ?? 'Yeni eklenenler'));
            saveSetting('homepage_title_best_sellers', trim($_POST['title_best_sellers'] ?? 'En çok satanlar'));
            
            // Anasayfa ayarları
            saveSetting('homepage_show_slider', isset($_POST['show_slider']) ? '1' : '0');
            saveSetting('homepage_show_categories', isset($_POST['show_categories']) ? '1' : '0');
            saveSetting('homepage_show_popular', isset($_POST['show_popular']) ? '1' : '0');
            saveSetting('homepage_show_featured', isset($_POST['show_featured']) ? '1' : '0');
            saveSetting('homepage_show_new', isset($_POST['show_new']) ? '1' : '0');
            
            // Ürün bölümleri
            saveSetting('homepage_show_featured_products', isset($_POST['show_featured_products']) ? '1' : '0');
            saveSetting('homepage_featured_products_count', max(1, min(50, (int)($_POST['featured_products_count'] ?? 6))));
            
            saveSetting('homepage_show_best_sellers', isset($_POST['show_best_sellers']) ? '1' : '0');
            saveSetting('homepage_best_sellers_count', max(1, min(50, (int)($_POST['best_sellers_count'] ?? 4))));
            
            saveSetting('homepage_new_products_count', max(1, min(50, (int)($_POST['new_products_count'] ?? 8))));
            
            // Neden Biz? Bölümü
            saveSetting('homepage_show_why_us', isset($_POST['show_why_us']) ? '1' : '0');
            saveSetting('homepage_why_us_title', trim($_POST['why_us_title'] ?? ''));
            saveSetting('homepage_why_us_subtitle', trim($_POST['why_us_subtitle'] ?? ''));
            
            // Özellikler
            $features = [];
            for ($i = 1; $i <= 4; $i++) {
                $features[] = [
                    'icon' => trim($_POST["feature_{$i}_icon"] ?? ''),
                    'title' => trim($_POST["feature_{$i}_title"] ?? ''),
                    'description' => trim($_POST["feature_{$i}_description"] ?? '')
                ];
            }
            saveSetting('homepage_why_us_features', json_encode($features, JSON_UNESCAPED_UNICODE));
            
            // Sosyal Medya Linkleri
            saveSetting('social_instagram', trim($_POST['social_instagram'] ?? ''));
            saveSetting('social_twitter', trim($_POST['social_twitter'] ?? ''));
            saveSetting('social_discord', trim($_POST['social_discord'] ?? ''));
            saveSetting('social_facebook', trim($_POST['social_facebook'] ?? ''));
            saveSetting('social_youtube', trim($_POST['social_youtube'] ?? ''));
            saveSetting('social_tiktok', trim($_POST['social_tiktok'] ?? ''));
            
            $success = 'Anasayfa ayarları başarıyla kaydedildi.';
        }
    }
}

// Mevcut ayarları al
$popularCategoriesJson = getSetting('homepage_popular_categories', '[]');
$popularCategories = json_decode($popularCategoriesJson, true) ?: [];

$featuredCategoriesJson = getSetting('homepage_featured_categories', '[]');
$featuredCategories = json_decode($featuredCategoriesJson, true) ?: [];

$newProductsCategory = (int)getSetting('homepage_new_products_category', 0);

$showSlider = getSetting('homepage_show_slider', '1') === '1';
$showCategories = getSetting('homepage_show_categories', '1') === '1';
$showPopular = getSetting('homepage_show_popular', '1') === '1';
$showFeatured = getSetting('homepage_show_featured', '1') === '1';
$showNew = getSetting('homepage_show_new', '1') === '1';

// Ürün bölümleri ayarları
$showFeaturedProducts = getSetting('homepage_show_featured_products', '1') === '1';
$featuredProductsCount = max(1, min(50, (int)getSetting('homepage_featured_products_count', 6)));

$showBestSellers = getSetting('homepage_show_best_sellers', '1') === '1';
$bestSellersCount = max(1, min(50, (int)getSetting('homepage_best_sellers_count', 4)));

$newProductsCount = max(1, min(50, (int)getSetting('homepage_new_products_count', 8)));

// Başlık İkonları
$iconPopularCategories = getSetting('homepage_icon_popular_categories', 'fa-solid fa-layer-group');
$iconFeaturedCategories = getSetting('homepage_icon_featured_categories', 'fa-solid fa-fire');
$iconFeaturedProducts = getSetting('homepage_icon_featured_products', 'fa-solid fa-star');
$iconNewProducts = getSetting('homepage_icon_new_products', 'fa-solid fa-sparkles');
$iconBestSellers = getSetting('homepage_icon_best_sellers', 'fa-solid fa-trophy');

// Başlık İsimleri
$titlePopularCategories = getSetting('homepage_title_popular_categories', 'Popüler kategoriler');
$titleFeaturedCategories = getSetting('homepage_title_featured_categories', 'Öne Çıkan Kategoriler');
$titleFeaturedProducts = getSetting('homepage_title_featured_products', 'Öne çıkan ürünler');
$titleNewProducts = getSetting('homepage_title_new_products', 'Yeni eklenenler');
$titleBestSellers = getSetting('homepage_title_best_sellers', 'En çok satanlar');

// Neden Biz? Bölümü ayarları
$showWhyUs = getSetting('homepage_show_why_us', '1') === '1';
$whyUsTitle = getSetting('homepage_why_us_title', 'Neden ' . siteName() . '?');
$whyUsSubtitle = getSetting('homepage_why_us_subtitle', 'Sizin için en iyi deneyimi sunmak için her detayı düşündük.');
$whyUsFeaturesJson = getSetting('homepage_why_us_features', '[]');
$whyUsFeatures = json_decode($whyUsFeaturesJson, true) ?: [];

// Varsayılan özellikler
if (empty($whyUsFeatures)) {
    $whyUsFeatures = [
        ['icon' => 'fa-solid fa-bolt', 'title' => '15 Dakikada Teslim', 'description' => 'Ödeme tamamlandığında kodlarınız panelinize otomatik tanımlanır.'],
        ['icon' => 'fa-solid fa-shield', 'title' => 'Güvenli Ödeme Altyapısı', 'description' => 'PayTR ve Shopier güvencesiyle kart bilgileriniz saklanmadan işlem yapın.'],
        ['icon' => 'fa-solid fa-headset', 'title' => '7/24 Destek', 'description' => 'Canlı destek ekibimiz, tüm sorularınızda bir mesaj uzağınızda.'],
        ['icon' => 'fa-solid fa-gift', 'title' => 'Bonus ve Kampanyalar', 'description' => 'Düzenli kampanyalar ve bonus bakiyelerle kazancınızı artırın.']
    ];
}

// Sosyal medya linkleri
$socialInstagram = getSetting('social_instagram', '');
$socialTwitter = getSetting('social_twitter', '');
$socialDiscord = getSetting('social_discord', '');
$socialFacebook = getSetting('social_facebook', '');
$socialYoutube = getSetting('social_youtube', '');
$socialTiktok = getSetting('social_tiktok', '');

// Tüm kategorileri çek
$categoriesStmt = $pdo->query('SELECT id, name FROM categories WHERE is_active = 1 ORDER BY display_order ASC, name ASC');
$allCategories = $categoriesStmt->fetchAll();

// Marketplace oyunlarını çek
$marketplaceGamesStmt = $pdo->query('SELECT id, name FROM game_marketplaces WHERE is_active = 1 ORDER BY name ASC');
$allMarketplaceGames = $marketplaceGamesStmt->fetchAll();

$pageTitle = 'Anasayfa Ayarları';
include 'includes/admin-header.php';
?>

<div class="admin-content">
    <div class="admin-header">
        <h1><i class="fa-solid fa-house-circle-check me-2"></i><?= sanitize($pageTitle) ?></h1>
        <p>Anasayfa'da gösterilecek bölümleri ve içerikleri yönetin</p>
    </div>

    <?php if ($success): ?>
    <div class="alert alert-success">
        <i class="fa-solid fa-circle-check me-2"></i><?= sanitize($success) ?>
    </div>
    <?php endif; ?>

    <?php if (!empty($errors)): ?>
    <div class="alert alert-danger">
        <i class="fa-solid fa-circle-exclamation me-2"></i>
        <?php foreach ($errors as $error): ?>
            <div><?= sanitize($error) ?></div>
        <?php endforeach; ?>
    </div>
    <?php endif; ?>

    <form method="post" class="admin-form">
        <input type="hidden" name="csrf_token" value="<?= generateCSRFToken() ?>">
        <input type="hidden" name="action" value="save_homepage_sections">

        <div class="card mb-4">
            <div class="card-header">
                <h3><i class="fa-solid fa-toggle-on me-2"></i>Bölüm Görünürlüğü</h3>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="show_slider" name="show_slider" <?= $showSlider ? 'checked' : '' ?>>
                            <label class="form-check-label" for="show_slider">
                                <strong>Ana Slider'ı Göster</strong>
                                <small class="d-block text-muted">Anasayfa üst kısmındaki büyük slider</small>
                            </label>
                        </div>
                    </div>
                    <div class="col-md-6 mb-3">
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="show_categories" name="show_categories" <?= $showCategories ? 'checked' : '' ?>>
                            <label class="form-check-label" for="show_categories">
                                <strong>Kategori Karouselini Göster</strong>
                                <small class="d-block text-muted">Tüm kategorilerin gösterildiği kaydırmalı bölüm</small>
                            </label>
                        </div>
                    </div>
                    <div class="col-md-6 mb-3">
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="show_popular" name="show_popular" <?= $showPopular ? 'checked' : '' ?>>
                            <label class="form-check-label" for="show_popular">
                                <strong>Popüler Kategoriler Bölümünü Göster</strong>
                                <small class="d-block text-muted">Seçtiğiniz popüler kategoriler</small>
                            </label>
                        </div>
                    </div>
                    <div class="col-md-6 mb-3">
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="show_featured" name="show_featured" <?= $showFeatured ? 'checked' : '' ?>>
                            <label class="form-check-label" for="show_featured">
                                <strong>Öne Çıkan Kategoriler Bölümünü Göster</strong>
                                <small class="d-block text-muted">Seçtiğiniz öne çıkan kategoriler</small>
                            </label>
                        </div>
                    </div>
                    <div class="col-md-6 mb-3">
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="show_new" name="show_new" <?= $showNew ? 'checked' : '' ?>>
                            <label class="form-check-label" for="show_new">
                                <strong>Yeni Eklenenler Bölümünü Göster</strong>
                                <small class="d-block text-muted">Seçilen kategorideki en yeni ürünler</small>
                            </label>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card mb-4">
            <div class="card-header">
                <h3><i class="fa-solid fa-heading me-2"></i>Başlık İsimleri ve İkonları</h3>
                <p class="mb-0 text-muted">Anasayfa başlıklarının adını ve ikonlarını özelleştirin</p>
            </div>
            <div class="card-body">
                <div class="alert alert-info">
                    <i class="fa-solid fa-info-circle me-2"></i>
                    İkonlar için <a href="https://fontawesome.com/icons" target="_blank" class="fw-bold">Font Awesome</a> sitesinden seçim yapabilirsiniz.
                    Örnek: <code>fa-solid fa-fire</code>
                </div>
                
                <div class="row mb-4">
                    <div class="col-12 mb-3">
                        <h5><i class="fa-solid fa-layer-group me-2"></i>Popüler Kategoriler</h5>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Başlık Adı</label>
                        <input type="text" class="form-control" name="title_popular_categories" value="<?= sanitize($titlePopularCategories) ?>" placeholder="Popüler kategoriler">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">İkon</label>
                        <input type="text" class="form-control" name="icon_popular_categories" value="<?= sanitize($iconPopularCategories) ?>" placeholder="fa-solid fa-layer-group">
                    </div>
                </div>

                <hr class="my-4">

                <div class="row mb-4">
                    <div class="col-12 mb-3">
                        <h5><i class="fa-solid fa-fire me-2"></i>Öne Çıkan Kategoriler</h5>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Başlık Adı</label>
                        <input type="text" class="form-control" name="title_featured_categories" value="<?= sanitize($titleFeaturedCategories) ?>" placeholder="Öne Çıkan Kategoriler">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">İkon</label>
                        <input type="text" class="form-control" name="icon_featured_categories" value="<?= sanitize($iconFeaturedCategories) ?>" placeholder="fa-solid fa-fire">
                    </div>
                </div>

                <hr class="my-4">

                <div class="row mb-4">
                    <div class="col-12 mb-3">
                        <h5><i class="fa-solid fa-star me-2"></i>Öne Çıkan Ürünler</h5>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Başlık Adı</label>
                        <input type="text" class="form-control" name="title_featured_products" value="<?= sanitize($titleFeaturedProducts) ?>" placeholder="Öne çıkan ürünler">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">İkon</label>
                        <input type="text" class="form-control" name="icon_featured_products" value="<?= sanitize($iconFeaturedProducts) ?>" placeholder="fa-solid fa-star">
                    </div>
                </div>

                <hr class="my-4">

                <div class="row mb-4">
                    <div class="col-12 mb-3">
                        <h5><i class="fa-solid fa-sparkles me-2"></i>Yeni Eklenenler</h5>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Başlık Adı</label>
                        <input type="text" class="form-control" name="title_new_products" value="<?= sanitize($titleNewProducts) ?>" placeholder="Yeni eklenenler">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">İkon</label>
                        <input type="text" class="form-control" name="icon_new_products" value="<?= sanitize($iconNewProducts) ?>" placeholder="fa-solid fa-sparkles">
                    </div>
                </div>

                <hr class="my-4">

                <div class="row">
                    <div class="col-12 mb-3">
                        <h5><i class="fa-solid fa-trophy me-2"></i>En Çok Satanlar</h5>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Başlık Adı</label>
                        <input type="text" class="form-control" name="title_best_sellers" value="<?= sanitize($titleBestSellers) ?>" placeholder="En çok satanlar">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">İkon</label>
                        <input type="text" class="form-control" name="icon_best_sellers" value="<?= sanitize($iconBestSellers) ?>" placeholder="fa-solid fa-trophy">
                    </div>
                </div>
            </div>
        </div>

        <div class="card mb-4">
            <div class="card-header">
                <h3><i class="fa-solid fa-fire me-2"></i>Popüler Kategoriler</h3>
                <p class="mb-0 text-muted">Anasayfada "Popüler Kategoriler" bölümünde gösterilecek kategoriler (Çoklu seçim yapabilirsiniz)</p>
            </div>
            <div class="card-body">
                <div class="row">
                    <?php foreach ($allCategories as $category): ?>
                    <div class="col-md-3 col-sm-6 mb-2">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="popular_categories[]" value="<?= (int)$category['id'] ?>" id="pop_cat_<?= (int)$category['id'] ?>" <?= in_array((int)$category['id'], $popularCategories) ? 'checked' : '' ?>>
                            <label class="form-check-label" for="pop_cat_<?= (int)$category['id'] ?>">
                                <?= sanitize($category['name']) ?>
                            </label>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>

        <div class="card mb-4">
            <div class="card-header">
                <h3><i class="fa-solid fa-gamepad me-2"></i>Öne Çıkan Marketplace Oyunları</h3>
                <p class="mb-0 text-muted">Anasayfada "Öne Çıkan Kategoriler" bölümünde gösterilecek marketplace oyunları (Çoklu seçim yapabilirsiniz)</p>
            </div>
            <div class="card-body">
                <?php if (empty($allMarketplaceGames)): ?>
                    <div class="alert alert-warning">
                        <i class="fa-solid fa-exclamation-triangle me-2"></i>Henüz aktif marketplace oyunu bulunmuyor. 
                        <a href="marketplace-games.php">Marketplace Oyunları</a> sayfasından ekleyebilirsiniz.
                    </div>
                <?php else: ?>
                    <div class="row">
                        <?php foreach ($allMarketplaceGames as $game): ?>
                        <div class="col-md-3 col-sm-6 mb-2">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="featured_categories[]" value="<?= (int)$game['id'] ?>" id="feat_game_<?= (int)$game['id'] ?>" <?= in_array((int)$game['id'], $featuredCategories) ? 'checked' : '' ?>>
                                <label class="form-check-label" for="feat_game_<?= (int)$game['id'] ?>">
                                    <?= sanitize($game['name']) ?>
                                </label>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <div class="card mb-4">
            <div class="card-header">
                <h3><i class="fa-solid fa-sparkles me-2"></i>Yeni Eklenenler</h3>
                <p class="mb-0 text-muted">Hangi kategoriden yeni eklenen ürünler gösterilsin? (Tek seçim)</p>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-8 mb-3">
                        <label class="form-label">Kategori Seçimi</label>
                        <select class="form-select" name="new_products_category">
                            <option value="0">Tüm Kategoriler (En yeni ürünler)</option>
                            <?php foreach ($allCategories as $category): ?>
                            <option value="<?= (int)$category['id'] ?>" <?= $newProductsCategory === (int)$category['id'] ? 'selected' : '' ?>>
                                <?= sanitize($category['name']) ?>
                            </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-md-4 mb-3">
                        <label class="form-label">Ürün Sayısı</label>
                        <input type="number" class="form-control" name="new_products_count" value="<?= $newProductsCount ?>" min="1" max="50">
                        <small class="text-muted">En fazla 50</small>
                    </div>
                </div>
            </div>
        </div>

        <div class="card mb-4">
            <div class="card-header">
                <h3><i class="fa-solid fa-box-open me-2"></i>Ürün Bölümleri</h3>
                <p class="mb-0 text-muted">Anasayfada gösterilecek ürün bölümlerini ve kaç adet ürün gösterileceğini ayarlayın</p>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6 mb-4">
                        <div class="form-check form-switch mb-3">
                            <input class="form-check-input" type="checkbox" id="show_featured_products" name="show_featured_products" <?= $showFeaturedProducts ? 'checked' : '' ?>>
                            <label class="form-check-label" for="show_featured_products">
                                <strong><i class="fa-solid fa-star me-2"></i>Öne Çıkan Ürünler Göster</strong>
                                <small class="d-block text-muted">Yönetici tarafından öne çıkarılmış ürünler</small>
                            </label>
                        </div>
                        <div class="ms-4">
                            <label class="form-label">Gösterilecek Ürün Sayısı</label>
                            <input type="number" class="form-control" name="featured_products_count" value="<?= $featuredProductsCount ?>" min="1" max="50">
                            <small class="text-muted">Varsayılan: 6 ürün</small>
                        </div>
                    </div>

                    <div class="col-md-6 mb-4">
                        <div class="form-check form-switch mb-3">
                            <input class="form-check-input" type="checkbox" id="show_best_sellers" name="show_best_sellers" <?= $showBestSellers ? 'checked' : '' ?>>
                            <label class="form-check-label" for="show_best_sellers">
                                <strong><i class="fa-solid fa-trophy me-2"></i>En Çok Satanlar Göster</strong>
                                <small class="d-block text-muted">Satış sayısına göre en popüler ürünler</small>
                            </label>
                        </div>
                        <div class="ms-4">
                            <label class="form-label">Gösterilecek Ürün Sayısı</label>
                            <input type="number" class="form-control" name="best_sellers_count" value="<?= $bestSellersCount ?>" min="1" max="50">
                            <small class="text-muted">Varsayılan: 4 ürün</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card mb-4">
            <div class="card-header">
                <h3><i class="fa-solid fa-lightbulb me-2"></i>Neden Biz? Bölümü</h3>
                <p class="mb-0 text-muted">Anasayfa alt kısımda gösterilecek özellikler bölümü</p>
            </div>
            <div class="card-body">
                <div class="form-check form-switch mb-4">
                    <input class="form-check-input" type="checkbox" id="show_why_us" name="show_why_us" <?= $showWhyUs ? 'checked' : '' ?>>
                    <label class="form-check-label" for="show_why_us">
                        <strong>Neden Biz? Bölümünü Göster</strong>
                        <small class="d-block text-muted">Sitenizin avantajlarını ve özelliklerini sergileyin</small>
                    </label>
                </div>

                <div class="row mb-4">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Başlık</label>
                        <input type="text" class="form-control" name="why_us_title" value="<?= sanitize($whyUsTitle) ?>" placeholder="Neden Frisc?">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Alt Başlık</label>
                        <input type="text" class="form-control" name="why_us_subtitle" value="<?= sanitize($whyUsSubtitle) ?>" placeholder="Sizin için en iyi deneyimi sunmak...">
                    </div>
                </div>

                <h5 class="mb-3"><i class="fa-solid fa-star me-2"></i>Özellikler (4 Adet)</h5>
                
                <?php foreach ($whyUsFeatures as $index => $feature): ?>
                    <?php $num = $index + 1; ?>
                    <div class="card mb-3" style="background: var(--color-surface-secondary);">
                        <div class="card-body">
                            <h6 class="mb-3">
                                <i class="<?= sanitize($feature['icon'] ?? 'fa-solid fa-star') ?> me-2"></i>
                                Özellik <?= $num ?>
                            </h6>
                            <div class="row">
                                <div class="col-md-4 mb-3">
                                    <label class="form-label">İkon (Font Awesome)</label>
                                    <input type="text" class="form-control" name="feature_<?= $num ?>_icon" value="<?= sanitize($feature['icon'] ?? '') ?>" placeholder="fa-solid fa-bolt">
                                    <small class="text-muted"><a href="https://fontawesome.com/icons" target="_blank">Font Awesome İkonlar</a></small>
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label class="form-label">Başlık</label>
                                    <input type="text" class="form-control" name="feature_<?= $num ?>_title" value="<?= sanitize($feature['title'] ?? '') ?>" placeholder="15 Dakikada Teslim">
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label class="form-label">Açıklama</label>
                                    <textarea class="form-control" name="feature_<?= $num ?>_description" rows="2" placeholder="Detaylı açıklama..."><?= sanitize($feature['description'] ?? '') ?></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>

        <div class="card mb-4">
            <div class="card-header">
                <h3><i class="fa-solid fa-share-nodes me-2"></i>Sosyal Medya Linkleri</h3>
                <p class="mb-0 text-muted">Üst bar'da gösterilecek sosyal medya hesaplarınız (Boş bırakılan linkler gösterilmez)</p>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">
                            <i class="fa-brands fa-instagram me-2"></i>Instagram
                        </label>
                        <input type="url" class="form-control" name="social_instagram" value="<?= sanitize($socialInstagram) ?>" placeholder="https://instagram.com/kullaniciadi">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">
                            <i class="fa-brands fa-x-twitter me-2"></i>Twitter / X
                        </label>
                        <input type="url" class="form-control" name="social_twitter" value="<?= sanitize($socialTwitter) ?>" placeholder="https://twitter.com/kullaniciadi">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">
                            <i class="fa-brands fa-discord me-2"></i>Discord
                        </label>
                        <input type="url" class="form-control" name="social_discord" value="<?= sanitize($socialDiscord) ?>" placeholder="https://discord.gg/sunucuadi">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">
                            <i class="fa-brands fa-facebook me-2"></i>Facebook
                        </label>
                        <input type="url" class="form-control" name="social_facebook" value="<?= sanitize($socialFacebook) ?>" placeholder="https://facebook.com/sayfaadi">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">
                            <i class="fa-brands fa-youtube me-2"></i>YouTube
                        </label>
                        <input type="url" class="form-control" name="social_youtube" value="<?= sanitize($socialYoutube) ?>" placeholder="https://youtube.com/@kanaladi">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">
                            <i class="fa-brands fa-tiktok me-2"></i>TikTok
                        </label>
                        <input type="url" class="form-control" name="social_tiktok" value="<?= sanitize($socialTiktok) ?>" placeholder="https://tiktok.com/@kullaniciadi">
                    </div>
                </div>
            </div>
        </div>

        <div class="form-actions">
            <button type="submit" class="btn btn-primary btn-lg">
                <i class="fa-solid fa-floppy-disk me-2"></i>Ayarları Kaydet
            </button>
        </div>
    </form>
</div>

<?php include 'includes/admin-footer.php'; ?>

