<?php
$adminCssVersion = file_exists(__DIR__ . '/../assets/admin.css') ? filemtime(__DIR__ . '/../assets/admin.css') : time();
$adminJsVersion = file_exists(__DIR__ . '/../assets/admin.js') ? filemtime(__DIR__ . '/../assets/admin.js') : time();

$currentScriptPath = parse_url($_SERVER['REQUEST_URI'] ?? '', PHP_URL_PATH) ?? '';
$currentFile = basename($currentScriptPath);

$menuStructure = [
    [
        'type' => 'link',
        'label' => 'Gösterge Paneli',
        'icon' => 'fa-gauge-high',
        'url' => 'index.php',
        'match' => ['index.php'],
    ],
    [
        'type' => 'link',
        'label' => 'Raporlar',
        'icon' => 'fa-chart-line',
        'url' => 'reports.php',
        'match' => ['reports.php'],
    ],
    [
        'type' => 'group',
        'label' => 'Satış Yönetimi',
        'icon' => 'fa-cart-shopping',
        'match' => ['orders.php', 'marketplace-orders.php', 'deposits.php', 'withdrawals.php', 'users.php', 'discount-codes.php', 'gift-codes.php'],
        'children' => [
            ['label' => 'Siparişler', 'url' => 'orders.php'],
            ['label' => 'Marketplace Siparişleri', 'url' => 'marketplace-orders.php'],
            ['label' => 'Para Yatırmaları', 'url' => 'deposits.php'],
            ['label' => 'Bakiye Çekimleri', 'url' => 'withdrawals.php'],
            ['label' => 'İndirim Kodları', 'url' => 'discount-codes.php'],
            ['label' => 'Hediye Kodları', 'url' => 'gift-codes.php'],
            ['label' => 'Kullanıcılar', 'url' => 'users.php'],
        ],
    ],
    [
        'type' => 'group',
        'label' => 'İçerik Yönetimi',
        'icon' => 'fa-folder-tree',
        'match' => ['products.php', 'categories.php', 'codes.php', 'blog.php', 'pages.php', 'navigation.php', 'slider.php', 'advertisements.php', 'advertisement-edit.php'],
        'children' => [
            ['label' => 'Ürünler', 'url' => 'products.php'],
            ['label' => 'Kategoriler', 'url' => 'categories.php'],
            ['label' => 'Ürün Kodları', 'url' => 'codes.php'],
            ['label' => 'Blog Yazıları', 'url' => 'blog.php'],
            ['label' => 'Sayfalar', 'url' => 'pages.php'],
            ['label' => 'Navigasyon', 'url' => 'navigation.php'],
            ['label' => 'Slider & Bannerlar', 'url' => 'slider.php'],
            ['label' => 'Reklam Yönetimi', 'url' => 'advertisements.php'],
        ],
    ],
    [
        'type' => 'group',
        'label' => 'Marketplace',
        'icon' => 'fa-store',
        'match' => ['marketplace-games.php', 'marketplace-categories.php', 'marketplace-servers.php'],
        'children' => [
            ['label' => 'Oyunlar', 'url' => 'marketplace-games.php'],
            ['label' => 'Kategoriler', 'url' => 'marketplace-categories.php'],
            ['label' => 'Ürünler', 'url' => 'marketplace-servers.php'],
        ],
    ],
    [
        'type' => 'group',
        'label' => 'Destek & Güvenlik',
        'icon' => 'fa-shield-halved',
        'match' => ['tickets.php', 'ticket-detail.php', 'security.php', 'activity-logs.php'],
        'children' => [
            ['label' => 'Destek Talepleri', 'url' => 'tickets.php', 'match' => ['tickets.php', 'ticket-detail.php']],
            ['label' => 'Güvenlik Ayarları', 'url' => 'security.php'],
            ['label' => 'Log Kayıtları', 'url' => 'activity-logs.php'],
        ],
    ],
    [
        'type' => 'group',
        'label' => 'Ayarlar',
        'icon' => 'fa-sliders',
        'match' => ['homepage-settings.php', 'settings-site.php', 'settings-payments.php', 'settings-seo.php', 'settings-footer.php', 'settings.php'],
        'children' => [
            ['label' => 'Anasayfa Ayarları', 'url' => 'homepage-settings.php', 'match' => ['homepage-settings.php']],
            ['label' => 'Site Ayarları', 'url' => 'settings-site.php', 'match' => ['settings-site.php']],
            ['label' => 'Ödeme Ayarları', 'url' => 'settings-payments.php', 'match' => ['settings-payments.php']],
            ['label' => 'SEO & Indexleme', 'url' => 'settings-seo.php', 'match' => ['settings-seo.php']],
            ['label' => 'Footer Ayarları', 'url' => 'settings-footer.php', 'match' => ['settings-footer.php']],
        ],
    ],
    [
        'type' => 'link',
        'label' => 'Admin Yönetimi',
        'icon' => 'fa-user-shield',
        'url' => 'admins.php',
        'match' => ['admins.php'],
    ],
    [
        'type' => 'link',
        'label' => 'Siteye Dön',
        'icon' => 'fa-globe',
        'url' => routeUrl('home'),
        'external' => true,
    ],
    [
        'type' => 'link',
        'label' => 'Çıkış Yap',
        'icon' => 'fa-right-from-bracket',
        'url' => routeUrl('logout'),
    ],
];

$menuIdCounter = 0;
$generateMenuId = static function (string $label) use (&$menuIdCounter): string {
    $menuIdCounter++;
    $slug = strtolower(safe_trim(preg_replace('/[^a-z0-9]+/i', '-', $label), '-'));
    return ($slug !== '' ? $slug : 'menu') . '-' . $menuIdCounter;
};

$extractMatches = static function (array $item): array {
    if (!empty($item['match']) && is_array($item['match'])) {
        return $item['match'];
    }
    $url = $item['url'] ?? '';
    if (!is_string($url) || $url === '') {
        return [];
    }
    $path = parse_url($url, PHP_URL_PATH);
    if (!$path) {
        return [];
    }
    $file = basename($path);
    return $file !== '' ? [$file] : [];
};
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $pageTitle ?? 'Admin Panel' ?> - <?= siteName() ?></title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="<?= htmlspecialchars(publicUrl('admin/assets/admin-new.css'), ENT_QUOTES, 'UTF-8') ?>?v=<?= time() ?>">
    <?php if (!empty($adminExtraStyles) && is_array($adminExtraStyles)): ?>
        <?php foreach ($adminExtraStyles as $styleHref): ?>
            <?php if (is_string($styleHref) && $styleHref !== ''): ?>
                <link rel="stylesheet" href="<?= htmlspecialchars($styleHref, ENT_QUOTES, 'UTF-8') ?>">
            <?php endif; ?>
        <?php endforeach; ?>
    <?php endif; ?>
    <?php if (!empty($adminExtraHeadScripts) && is_array($adminExtraHeadScripts)): ?>
        <?php foreach ($adminExtraHeadScripts as $scriptSrc): ?>
            <?php if (is_string($scriptSrc) && $scriptSrc !== ''): ?>
                <script src="<?= htmlspecialchars($scriptSrc, ENT_QUOTES, 'UTF-8') ?>"></script>
            <?php endif; ?>
        <?php endforeach; ?>
    <?php endif; ?>
</head>
<body class="admin-body" data-admin-theme="dark">
    <div class="admin-shell">
        <aside class="admin-sidebar" data-sidebar>
            <div class="sidebar-inner">
                <div class="sidebar-header">
                    <button class="sidebar-close" type="button" data-sidebar-close aria-label="Menüyü Kapat">
                        <i class="fa-solid fa-xmark"></i>
                    </button>
                    <div class="sidebar-brand">
                        <span class="sidebar-brand__icon"><i class="fas fa-crown"></i></span>
                        <div class="sidebar-brand__text">
                            <strong><?= siteName() ?> Admin</strong>
                            <span>Kontrol Merkezi</span>
                        </div>
                    </div>
                </div>
                <div class="sidebar-scroll">
                    <nav class="sidebar-nav">
                        <ul class="sidebar-menu">
                            <?php foreach ($menuStructure as $item): ?>
                                <?php if (($item['type'] ?? 'link') === 'link'): ?>
                                    <?php
                                        $matches = $extractMatches($item);
                                        $isActive = !empty($matches) && in_array($currentFile, $matches, true);
                                        $linkUrl = $item['url'] ?? '#';
                                        $icon = $item['icon'] ?? 'fa-circle';
                                        $isExternal = !empty($item['external']);
                                    ?>
                                    <li class="sidebar-item<?= $isActive ? ' is-active' : '' ?>">
                                        <a href="<?= htmlspecialchars($linkUrl, ENT_QUOTES, 'UTF-8') ?>" class="sidebar-link<?= $isExternal ? ' sidebar-link--external' : '' ?>"<?= $isExternal ? ' target="_blank" rel="noopener"' : '' ?>>
                                            <span class="sidebar-link__icon"><i class="fa-solid <?= htmlspecialchars($icon, ENT_QUOTES, 'UTF-8') ?>"></i></span>
                                            <span class="sidebar-link__label"><?= sanitize($item['label']) ?></span>
                                            <?php if ($isExternal): ?>
                                                <i class="fas fa-arrow-up-right-from-square sidebar-link__external"></i>
                                            <?php endif; ?>
                                        </a>
                                    </li>
                                <?php else: ?>
                                    <?php
                                        $groupId = $generateMenuId($item['label']);
                                        $children = $item['children'] ?? [];
                                        $groupActive = false;
                                        foreach ($children as $child) {
                                            $childMatches = $extractMatches($child);
                                            if (!empty($childMatches) && in_array($currentFile, $childMatches, true)) {
                                                $groupActive = true;
                                                break;
                                            }
                                        }
                                        if (!$groupActive && !empty($item['match']) && in_array($currentFile, $item['match'], true)) {
                                            $groupActive = true;
                                        }
                                        $groupIcon = $item['icon'] ?? 'fa-circle-nodes';
                                    ?>
                                    <li class="sidebar-group<?= $groupActive ? ' is-open' : '' ?>">
                                        <button class="sidebar-group__toggle" type="button" data-sub-toggle="<?= htmlspecialchars($groupId, ENT_QUOTES, 'UTF-8') ?>">
                                            <span class="sidebar-link__icon"><i class="fa-solid <?= htmlspecialchars($groupIcon, ENT_QUOTES, 'UTF-8') ?>"></i></span>
                                            <span class="sidebar-link__label"><?= sanitize($item['label']) ?></span>
                                            <i class="fas fa-chevron-down caret"></i>
                                        </button>
                                        <ul class="sidebar-sub" data-submenu="<?= htmlspecialchars($groupId, ENT_QUOTES, 'UTF-8') ?>">
                                            <?php foreach ($children as $child): ?>
                                                <?php
                                                    $childMatches = $extractMatches($child);
                                                    $childActive = !empty($childMatches) && in_array($currentFile, $childMatches, true);
                                                    $childUrl = $child['url'] ?? '#';
                                                    $settingsAttr = '';
                                                    if (is_string($childUrl) && strpos($childUrl, 'settings.php#') === 0) {
                                                        $hashFragment = substr($childUrl, strpos($childUrl, '#'));
                                                        if ($hashFragment !== false) {
                                                            $settingsAttr = ' data-settings-link="' . htmlspecialchars($hashFragment, ENT_QUOTES, 'UTF-8') . '"';
                                                        }
                                                    }
                                                ?>
                                                <li>
                                                    <a href="<?= htmlspecialchars($childUrl, ENT_QUOTES, 'UTF-8') ?>" class="sidebar-sub__link<?= $childActive ? ' is-active' : '' ?>"<?= $settingsAttr ?>><?= sanitize($child['label']) ?></a>
                                                </li>
                                            <?php endforeach; ?>
                                        </ul>
                                    </li>
                                <?php endif; ?>
                            <?php endforeach; ?>
                        </ul>
                    </nav>
                </div>
                <div class="sidebar-footer">
                    <a class="sidebar-footer__link" href="profile.php">
                        <i class="fas fa-user-circle"></i>
                        <span>Profilim</span>
                    </a>
                    <a class="sidebar-footer__link" href="<?= htmlspecialchars(routeUrl('home'), ENT_QUOTES, 'UTF-8') ?>" target="_blank" rel="noopener">
                        <i class="fas fa-arrow-up-right-from-square"></i>
                        <span>Siteyi Görüntüle</span>
                    </a>
                    <a class="sidebar-footer__link" href="<?= htmlspecialchars(routeUrl('logout'), ENT_QUOTES, 'UTF-8') ?>">
                        <i class="fas fa-right-from-bracket"></i>
                        <span>Çıkış Yap</span>
                    </a>
                </div>
            </div>
        </aside>
        <div class="sidebar-overlay" data-sidebar-overlay></div>
        <div class="admin-main">
            <header class="admin-navbar">
                <div class="navbar-left">
                    <button class="icon-btn" type="button" data-sidebar-toggle aria-label="Menüyü Aç">
                        <i class="fas fa-bars"></i>
                    </button>
                    <h5 class="navbar-title mb-0"><?= $pageTitle ?? 'Admin Panel' ?></h5>
                </div>
                <div class="navbar-right">
                    <button class="icon-btn" type="button" data-admin-theme-toggle aria-label="Tema Modu">
                        <i class="fa-solid fa-moon"></i>
                    </button>
                    <div class="navbar-user">
                        <div class="navbar-user__avatar"><i class="fas fa-user"></i></div>
                        <div class="navbar-user__meta">
                            <span class="navbar-user__name"><?= sanitize($_SESSION['username'] ?? 'Yönetici') ?></span>
                            <span class="navbar-user__role">Admin</span>
                        </div>
                    </div>
                </div>
            </header>
            <?php $flashMessage = getFlashMessage(); ?>
            <?php if ($flashMessage): ?>
                <div class="admin-alerts">
                    <div class="alert alert-<?= $flashMessage['type'] ?> alert-dismissible fade show" role="alert">
                        <i class="fas fa-<?= $flashMessage['type'] === 'success' ? 'check-circle' : 'exclamation-triangle' ?> me-2"></i>
                        <?= $flashMessage['message'] ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                </div>
            <?php endif; ?>
