<?php
require_once '../config.php';
requireAdmin();

$menuLocations = [
    'header' => 'Header Menüsü',
    'footer' => 'Footer Menüsü',
    'footer_bottom' => 'Footer Alt Linkleri',
];

$menuTypes = [
    'link' => 'Bağlantı',
];

$currentLocation = isset($_GET['location']) ? strtolower(trim((string)$_GET['location'])) : 'header';
if (!array_key_exists($currentLocation, $menuLocations)) {
    $currentLocation = 'header';
}

$editId = isset($_GET['edit']) ? (int)$_GET['edit'] : 0;
$editItem = null;

if ($editId > 0) {
    $stmt = $pdo->prepare('SELECT * FROM navigation_links WHERE id = ?');
    $stmt->execute([$editId]);
    $editItem = $stmt->fetch() ?: null;
    if (!$editItem) {
        flashMessage('danger', 'Menü öğesi bulunamadı.');
        redirect('navigation.php?location=' . urlencode($currentLocation));
    }
    $currentLocation = $editItem['location'] ?? $currentLocation;
    if (!array_key_exists($currentLocation, $menuLocations)) {
        $currentLocation = 'header';
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!verifyCSRFToken($_POST['csrf_token'] ?? '')) {
        flashMessage('danger', 'Güvenlik doğrulaması başarısız.');
        redirect('navigation.php' . ($editId ? '?edit=' . $editId : ''));
    }

    $action = $_POST['action'] ?? '';

    if ($action === 'save') {
        $title = trim($_POST['title'] ?? '');
        $url = trim($_POST['url'] ?? '');
        $menuType = $_POST['menu_type'] ?? 'link';
        $sortOrder = isset($_POST['sort_order']) ? (int)$_POST['sort_order'] : 0;
        $isActive = isset($_POST['is_active']) ? 1 : 0;
        $openNewTab = isset($_POST['open_new_tab']) ? 1 : 0;
        $location = $_POST['location'] ?? $currentLocation;
        $location = array_key_exists($location, $menuLocations) ? $location : 'header';
        $currentLocation = $location;

        if (!array_key_exists($menuType, $menuTypes)) {
            $menuType = 'link';
        }

        if ($title === '') {
            flashMessage('danger', 'Başlık alanı zorunludur.');
            redirect('navigation.php' . ($editId ? '?edit=' . $editId : ''));
        }

        if ($menuType === 'link' && $url === '') {
            flashMessage('danger', 'Bağlantı tipi için URL zorunludur.');
            redirect('navigation.php' . ($editId ? '?edit=' . $editId : ''));
        }

        if ($menuType !== 'link') {
            $url = $url !== '' ? $url : null;
        }

        try {
            if ($editId > 0 && $editItem) {
                $stmt = $pdo->prepare('UPDATE navigation_links SET title = :title, url = :url, menu_type = :menu_type, sort_order = :sort_order, is_active = :is_active, open_new_tab = :open_new_tab, updated_at = NOW() WHERE id = :id');
                $stmt->execute([
                    ':title' => $title,
                    ':url' => $url ?: null,
                    ':menu_type' => $menuType,
                    ':sort_order' => $sortOrder,
                    ':is_active' => $isActive,
                    ':open_new_tab' => $openNewTab,
                    ':id' => $editId,
                ]);
                flashMessage('success', 'Menü öğesi güncellendi.');
            } else {
                $stmt = $pdo->prepare('INSERT INTO navigation_links (title, url, menu_type, location, sort_order, is_active, open_new_tab) VALUES (:title, :url, :menu_type, :location, :sort_order, :is_active, :open_new_tab)');
                $stmt->execute([
                    ':title' => $title,
                    ':url' => $url ?: null,
                    ':menu_type' => $menuType,
                    ':location' => $location,
                    ':sort_order' => $sortOrder,
                    ':is_active' => $isActive,
                    ':open_new_tab' => $openNewTab,
                ]);
                flashMessage('success', 'Yeni menü öğesi oluşturuldu.');
            }
        } catch (Throwable $th) {
            flashMessage('danger', 'Kaydetme sırasında hata oluştu: ' . $th->getMessage());
            $redirectUrl = 'navigation.php?location=' . urlencode($currentLocation);
            if ($editId) {
                $redirectUrl .= '&edit=' . $editId;
            }
            redirect($redirectUrl);
        }

        redirect('navigation.php?location=' . urlencode($currentLocation));
    }

    if ($action === 'delete') {
        $deleteId = isset($_POST['id']) ? (int)$_POST['id'] : 0;
        if ($deleteId > 0) {
            try {
                $pdo->prepare('DELETE FROM navigation_links WHERE id = ?')->execute([$deleteId]);
                flashMessage('success', 'Menü öğesi silindi.');
            } catch (Throwable $th) {
                flashMessage('danger', 'Silme işlemi başarısız: ' . $th->getMessage());
            }
        }
        redirect('navigation.php?location=' . urlencode($currentLocation));
    }

    if ($action === 'toggle') {
        $toggleId = isset($_POST['id']) ? (int)$_POST['id'] : 0;
        if ($toggleId > 0) {
            try {
                $pdo->prepare('UPDATE navigation_links SET is_active = 1 - is_active, updated_at = NOW() WHERE id = ?')->execute([$toggleId]);
            } catch (Throwable $th) {
                flashMessage('danger', 'Durum güncellenemedi: ' . $th->getMessage());
            }
        }
        redirect('navigation.php?location=' . urlencode($currentLocation));
    }

}

try {
    $stmtMenu = $pdo->prepare('SELECT * FROM navigation_links WHERE location = :location ORDER BY sort_order ASC, id ASC');
    $stmtMenu->execute([':location' => $currentLocation]);
    $menuItems = $stmtMenu->fetchAll() ?: [];
} catch (Throwable $th) {
    $menuItems = [];
}

$pageTitle = $menuLocations[$currentLocation] ?? 'Menü Yönetimi';
include 'includes/admin-header.php';
?>

<div class="dashboard-container">
    <ul class="nav nav-pills mb-3">
        <?php foreach ($menuLocations as $locationKey => $locationLabel): ?>
            <li class="nav-item">
                <a class="nav-link<?= $currentLocation === $locationKey ? ' active' : '' ?>" href="navigation.php?location=<?= urlencode($locationKey) ?>"><?= sanitize($locationLabel) ?></a>
            </li>
        <?php endforeach; ?>
    </ul>
    <div class="row g-4">
        <div class="col-lg-5">
            <div class="card h-100">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0"><i class="fas fa-bars-staggered me-2"></i><?= $editItem ? 'Menü Öğesini Düzenle' : 'Yeni Menü Öğesi' ?></h5>
                    <?php if ($editItem): ?>
                        <a class="btn btn-sm btn-outline-secondary" href="navigation.php?location=<?= urlencode($currentLocation) ?>"><i class="fas fa-plus me-1"></i>Yeni Ekle</a>
                    <?php endif; ?>
                </div>
                <div class="card-body">
                    <?php
                        $currentType = $editItem['menu_type'] ?? 'link';
                        if (!array_key_exists($currentType, $menuTypes)) {
                            $currentType = 'link';
                        }
                        $currentUrl = $editItem['url'] ?? '';
                        $currentSort = $editItem['sort_order'] ?? 0;
                        $currentActive = $editItem ? (int)$editItem['is_active'] === 1 : true;
                        $currentOpenNewTab = $editItem ? (int)$editItem['open_new_tab'] === 1 : false;
                    ?>
                    <form method="post" class="row g-3">
                        <input type="hidden" name="csrf_token" value="<?= generateCSRFToken() ?>">
                        <input type="hidden" name="action" value="save">
                        <input type="hidden" name="location" value="<?= sanitize($currentLocation) ?>">
                        <div class="col-12">
                            <label class="form-label">Başlık *</label>
                            <input type="text" name="title" class="form-control" value="<?= sanitize($editItem['title'] ?? ($_POST['title'] ?? '')) ?>" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Tip *</label>
                            <select name="menu_type" class="form-select">
                                <?php foreach ($menuTypes as $value => $label): ?>
                                    <option value="<?= $value ?>"<?= $currentType === $value ? ' selected' : '' ?>><?= sanitize($label) ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Sıra</label>
                            <input type="number" name="sort_order" class="form-control" value="<?= sanitize((string)$currentSort) ?>">
                        </div>
                        <div class="col-12">
                            <label class="form-label">URL</label>
                            <input type="text" name="url" class="form-control" value="<?= sanitize($currentUrl) ?>" placeholder="Örn: products.php">
                            <small class="text-muted">Bağlantı tipi için zorunludur.</small>
                        </div>
                        <div class="col-12">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" name="is_active" id="is_active" <?= $currentActive ? 'checked' : '' ?>>
                                <label class="form-check-label" for="is_active">Menüde göster</label>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" name="open_new_tab" id="open_new_tab" <?= $currentOpenNewTab ? 'checked' : '' ?>>
                                <label class="form-check-label" for="open_new_tab">Yeni sekmede aç</label>
                            </div>
                        </div>
                        <div class="col-12 text-end">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save me-2"></i><?= $editItem ? 'Menüyü Güncelle' : 'Menüye Ekle' ?>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="col-lg-7">
            <div class="card h-100">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0"><i class="fas fa-list-ul me-2"></i><?= sanitize($menuLocations[$currentLocation]) ?></h5>
                    <span class="badge bg-secondary">Toplam <?= count($menuItems) ?> kayıt</span>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Başlık</th>
                                    <th>Tip</th>
                                    <th>URL</th>
                                    <th>Yeni Sekme</th>
                                    <th>Durum</th>
                                    <th class="text-end">İşlemler</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (empty($menuItems)): ?>
                                <tr>
                                    <td colspan="7" class="text-center text-muted py-4">Menü öğesi bulunmuyor.</td>
                                </tr>
                                <?php else: ?>
                                    <?php foreach ($menuItems as $menu): ?>
                                    <tr>
                                        <td><?= (int)$menu['sort_order'] ?></td>
                                        <td><strong><?= sanitize($menu['title']) ?></strong></td>
                                        <td><span class="badge bg-info text-dark"><?= sanitize($menuTypes[$menu['menu_type']] ?? strtoupper($menu['menu_type'])) ?></span></td>
                                        <td><?= $menu['url'] ? '<code>' . sanitize($menu['url']) . '</code>' : '<span class="text-muted">---</span>' ?></td>
                                        <td><?= $menu['open_new_tab'] ? '<span class="badge bg-primary">Evet</span>' : '<span class="text-muted">Hayır</span>' ?></td>
                                        <td>
                                            <?php if ((int)$menu['is_active'] === 1): ?>
                                                <span class="badge bg-success">Aktif</span>
                                            <?php else: ?>
                                                <span class="badge bg-secondary">Pasif</span>
                                            <?php endif; ?>
                                        </td>
                                        <td class="text-end">
                                            <a class="btn btn-sm btn-outline-primary" href="navigation.php?location=<?= urlencode($currentLocation) ?>&edit=<?= (int)$menu['id'] ?>"><i class="fas fa-pen"></i></a>
                                            <form method="post" class="d-inline">
                                                <input type="hidden" name="csrf_token" value="<?= generateCSRFToken() ?>">
                                                <input type="hidden" name="action" value="toggle">
                                                <input type="hidden" name="id" value="<?= (int)$menu['id'] ?>">
                                                <input type="hidden" name="location" value="<?= sanitize($currentLocation) ?>">
                                                <button type="submit" class="btn btn-sm btn-outline-secondary" title="Durumu değiştir"><i class="fas fa-power-off"></i></button>
                                            </form>
                                            <form method="post" class="d-inline" onsubmit="return confirm('Bu menü öğesini silmek istediğinize emin misiniz?');">
                                                <input type="hidden" name="csrf_token" value="<?= generateCSRFToken() ?>">
                                                <input type="hidden" name="action" value="delete">
                                                <input type="hidden" name="id" value="<?= (int)$menu['id'] ?>">
                                                <input type="hidden" name="location" value="<?= sanitize($currentLocation) ?>">
                                                <button type="submit" class="btn btn-sm btn-outline-danger"><i class="fas fa-trash"></i></button>
                                            </form>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'includes/admin-footer.php'; ?>

