<?php
require_once '../config.php';
requireAdmin();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['bulk_action'])) {
        $selectedIds = array_map('intval', $_POST['selected_ids'] ?? []);
        $selectedIds = array_values(array_filter($selectedIds));

        if (empty($selectedIds)) {
            flashMessage('warning', 'Toplu işlem için ürün seçmediniz.');
            redirect('products.php');
        }

        $placeholders = implode(',', array_fill(0, count($selectedIds), '?'));

        try {
            if ($_POST['bulk_action'] === 'activate') {
                $stmt = $pdo->prepare("UPDATE products SET is_active = 1 WHERE id IN ($placeholders)");
                $stmt->execute($selectedIds);
                flashMessage('success', 'Seçili ürünler aktifleştirildi.');
            } elseif ($_POST['bulk_action'] === 'delete') {
                $pdo->beginTransaction();
                $imageStmt = $pdo->prepare("SELECT image FROM products WHERE id IN ($placeholders)");
                $imageStmt->execute($selectedIds);
                $images = $imageStmt->fetchAll();

                $deleteStmt = $pdo->prepare("DELETE FROM products WHERE id IN ($placeholders)");
                $deleteStmt->execute($selectedIds);

                $pdo->commit();

                foreach ($images as $imageRow) {
                    if (!empty($imageRow['image'])) {
                        deleteUploadedFile($imageRow['image']);
                    }
                }

                flashMessage('success', 'Seçili ürünler silindi.');
            }
        } catch (Throwable $th) {
            if ($pdo->inTransaction()) {
                $pdo->rollBack();
            }
            flashMessage('danger', 'Toplu ürün işlemi sırasında hata oluştu: ' . $th->getMessage());
        }

        redirect('products.php');
    }
}

// Ürün silme
if (isset($_GET['delete']) && $_GET['delete']) {
    $stmt = $pdo->prepare("SELECT image FROM products WHERE id = ?");
    $stmt->execute([$_GET['delete']]);
    $productImageData = $stmt->fetch();

    $stmt = $pdo->prepare("DELETE FROM products WHERE id = ?");
    $stmt->execute([$_GET['delete']]);

    if ($productImageData && !empty($productImageData['image'])) {
        deleteUploadedFile($productImageData['image']);
    }

    flashMessage('success', 'Ürün başarıyla silindi.');
    redirect('products.php');
}

// Pagination
$totalProductsStmt = $pdo->query("SELECT COUNT(*) FROM products");
$totalProducts = (int)$totalProductsStmt->fetchColumn();
$pagination = getPaginationData($totalProducts, 10);

// Ürünleri getir
$products = $pdo->query("
    SELECT p.*, c.name as category_name 
    FROM products p 
    LEFT JOIN categories c ON p.category_id = c.id 
    ORDER BY p.created_at DESC
    LIMIT {$pagination['limit']} OFFSET {$pagination['offset']}
")->fetchAll();

$pageTitle = 'Ürün Yönetimi';
include 'includes/admin-header.php';
?>

<div class="dashboard-container">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3>
            <i class="fas fa-box me-2"></i>Ürün Yönetimi
        </h3>
        <a href="product-form.php" class="btn btn-primary">
            <i class="fas fa-plus me-2"></i>Yeni Ürün Ekle
        </a>
    </div>
    
    <div class="card">
        <div class="card-header d-flex flex-wrap justify-content-between align-items-center gap-3">
            <h5 class="mb-0"><i class="fas fa-layer-group me-2"></i>Ürün Listesi</h5>
            <form method="post" id="productBulkForm" class="bulk-action-toolbar" data-bulk-form="productBulkForm">
                <div class="d-flex align-items-center gap-2">
                    <span class="text-muted small">Seçili ürünler için:</span>
                    <button type="submit" name="bulk_action" value="activate" class="btn btn-sm btn-success" disabled data-bulk-action>
                        <i class="fas fa-check me-1"></i>Toplu Onayla
                    </button>
                    <button type="submit" name="bulk_action" value="delete" class="btn btn-sm btn-outline-danger" disabled data-bulk-action data-confirm="Seçili ürünleri silmek istediğinize emin misiniz?">
                        <i class="fas fa-trash-alt me-1"></i>Toplu Sil
                    </button>
                </div>
            </form>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover table-bulk mb-0">
                    <thead>
                        <tr>
                            <th class="text-center" style="width:48px;">
                                <input type="checkbox" class="form-check-input" data-bulk-master="productBulkForm">
                            </th>
                            <th>ID</th>
                            <th>Görsel</th>
                            <th>Ürün Adı</th>
                            <th>Kategori</th>
                            <th>Fiyat</th>
                            <th>Stok</th>
                            <th>Satış</th>
                            <th>Durum</th>
                            <th>Öne Çıkan</th>
                            <th>İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($products as $product): ?>
                        <tr>
                            <td class="text-center">
                                <input type="checkbox" class="form-check-input" name="selected_ids[]" value="<?= $product['id'] ?>" form="productBulkForm" data-bulk-target="productBulkForm">
                            </td>
                            <td><strong>#<?= $product['id'] ?></strong></td>
                            <td>
                                <?php if (!empty($product['image'])): ?>
                                    <img src="../<?= sanitize($product['image']) ?>" alt="<?= sanitize($product['name']) ?>" style="height: 48px; width: 48px; object-fit: cover; border-radius: 8px;">
                                <?php else: ?>
                                    <span class="text-muted">-</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <strong><?= sanitize($product['name']) ?></strong>
                                <br>
                                <small class="text-muted"><?= sanitize($product['slug']) ?></small>
                            </td>
                            <td><?= sanitize($product['category_name']) ?></td>
                            <td><strong><?= formatPrice($product['price']) ?></strong></td>
                            <td>
                                <span class="badge <?= $product['stock'] > 10 ? 'bg-success' : ($product['stock'] > 0 ? 'bg-warning' : 'bg-danger') ?>">
                                    <?= $product['stock'] ?>
                                </span>
                            </td>
                            <td><?= $product['sales_count'] ?></td>
                            <td>
                                <?php if ($product['is_active']): ?>
                                <span class="badge bg-success">Aktif</span>
                                <?php else: ?>
                                <span class="badge bg-secondary">Pasif</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if ($product['featured']): ?>
                                <i class="fas fa-star text-warning"></i>
                                <?php else: ?>
                                <i class="far fa-star text-muted"></i>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="btn-group">
                                    <a href="product-form.php?id=<?= $product['id'] ?>" class="btn btn-sm btn-outline-primary">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <a href="?delete=<?= $product['id'] ?>" class="btn btn-sm btn-outline-danger confirm-delete">
                                        <i class="fas fa-trash"></i>
                                    </a>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            <?php if ($totalProducts > 10): ?>
            <div class="card-body border-top">
                <?= renderPagination($pagination) ?>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php include 'includes/admin-footer.php'; ?>
