<?php
require_once '../config.php';
requireAdmin();

$pageTitle = 'Footer Ayarları';

$footerSettings = [
    'brand_title' => getSetting('footer_brand_title', ''),
    'brand_tagline' => getSetting('footer_brand_tagline', ''),
    'brand_description' => getSetting('footer_brand_description', 'Dijital oyun kodları, marketplace ilanları ve oyun parasında güvenilir çözüm ortağınız.'),
    'brand_highlight' => getSetting('footer_brand_highlight', 'Hızlı teslimat, güvenli ödeme ve deneyimli destek ekibimizle alışveriş deneyiminizi bir üst seviyeye taşıyoruz.'),
    'social_instagram' => getSetting('footer_social_instagram', ''),
    'social_twitter' => getSetting('footer_social_twitter', ''),
    'social_whatsapp' => getSetting('footer_social_whatsapp', ''),
    'social_youtube' => getSetting('footer_social_youtube', ''),
    'contact_phone' => getSetting('footer_contact_phone', '+90 (555) 123 45 67'),
    'contact_email' => getSetting('footer_contact_email', 'destek@enbmedya.com'),
    'contact_address' => getSetting('footer_contact_address', 'İstanbul / Türkiye'),
    'menu_heading' => getSetting('footer_menu_heading', 'Menü'),
    'category_heading' => getSetting('footer_category_heading', 'Popüler kategoriler'),
    'contact_heading' => getSetting('footer_contact_heading', 'İletişim'),
    'payment_badges' => getSetting('footer_payment_badges', 'PayTR|Shopier|3D Secure|SSL'),
    'bottom_text' => getSetting('footer_bottom_text', ''),
    'category_ids' => getSetting('footer_category_ids', ''),
];

$footerSelectedCategoryIds = [];
if (!empty($footerSettings['category_ids'])) {
    $decoded = json_decode((string)$footerSettings['category_ids'], true);
    if (is_array($decoded)) {
        foreach ($decoded as $catId) {
            $catId = (int)$catId;
            if ($catId > 0) {
                $footerSelectedCategoryIds[] = $catId;
            }
        }
    } else {
        foreach (preg_split('/[\s,;]+/', (string)$footerSettings['category_ids']) as $catId) {
            $catId = (int)$catId;
            if ($catId > 0) {
                $footerSelectedCategoryIds[] = $catId;
            }
        }
    }
    $footerSelectedCategoryIds = array_values(array_unique($footerSelectedCategoryIds));
}

try {
    $allFooterCategories = getCategories($pdo, false);
} catch (Throwable $th) {
    $allFooterCategories = [];
}

$errors = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!verifyCSRFToken($_POST['csrf_token'] ?? '')) {
        $errors[] = 'Güvenlik doğrulaması başarısız. Lütfen formu yeniden gönderin.';
    } else {
        // Hangi form submit edildi?
        $formAction = $_POST['form_action'] ?? 'all';
        
        // Marka içeriği formu
        if ($formAction === 'brand' || $formAction === 'all') {
            $footerSettings['brand_title'] = trim($_POST['footer_brand_title'] ?? $footerSettings['brand_title']);
            $footerSettings['brand_tagline'] = trim($_POST['footer_brand_tagline'] ?? $footerSettings['brand_tagline']);
            $footerSettings['brand_description'] = trim($_POST['footer_brand_description'] ?? $footerSettings['brand_description']);
            $footerSettings['brand_highlight'] = trim($_POST['footer_brand_highlight'] ?? $footerSettings['brand_highlight']);
        }
        
        // Sosyal medya & iletişim formu
        if ($formAction === 'social' || $formAction === 'all') {
            $footerSettings['social_instagram'] = trim($_POST['footer_social_instagram'] ?? $footerSettings['social_instagram']);
            $footerSettings['social_twitter'] = trim($_POST['footer_social_twitter'] ?? $footerSettings['social_twitter']);
            $footerSettings['social_whatsapp'] = trim($_POST['footer_social_whatsapp'] ?? $footerSettings['social_whatsapp']);
            $footerSettings['social_youtube'] = trim($_POST['footer_social_youtube'] ?? $footerSettings['social_youtube']);
            $footerSettings['contact_phone'] = trim($_POST['footer_contact_phone'] ?? $footerSettings['contact_phone']);
            $footerSettings['contact_email'] = trim($_POST['footer_contact_email'] ?? $footerSettings['contact_email']);
            $footerSettings['contact_address'] = trim($_POST['footer_contact_address'] ?? $footerSettings['contact_address']);
        }
        
        // Başlıklar formu
        if ($formAction === 'headings' || $formAction === 'all') {
            $footerSettings['menu_heading'] = trim($_POST['footer_menu_heading'] ?? $footerSettings['menu_heading']);
            $footerSettings['category_heading'] = trim($_POST['footer_category_heading'] ?? $footerSettings['category_heading']);
            $footerSettings['contact_heading'] = trim($_POST['footer_contact_heading'] ?? $footerSettings['contact_heading']);
            $footerSettings['payment_badges'] = trim($_POST['footer_payment_badges'] ?? $footerSettings['payment_badges']);
            $footerSettings['bottom_text'] = trim($_POST['footer_bottom_text'] ?? $footerSettings['bottom_text']);
        }
        
        // Kategoriler formu
        if ($formAction === 'categories' || $formAction === 'all') {
            $selectedCategories = isset($_POST['footer_categories']) && is_array($_POST['footer_categories']) ? $_POST['footer_categories'] : [];
            $footerSelectedCategoryIds = [];
            foreach ($selectedCategories as $catId) {
                $catId = (int)$catId;
                if ($catId > 0) {
                    $footerSelectedCategoryIds[] = $catId;
                }
            }
            $footerSelectedCategoryIds = array_values(array_unique($footerSelectedCategoryIds));
        }

        if ($footerSettings['contact_email'] !== '' && !filter_var($footerSettings['contact_email'], FILTER_VALIDATE_EMAIL)) {
            $errors[] = 'Footer iletişim e-postası için geçerli bir adres girin.';
        }

        $socialFields = [
            'Instagram' => 'social_instagram',
            'Twitter' => 'social_twitter',
            'WhatsApp' => 'social_whatsapp',
            'YouTube' => 'social_youtube',
        ];
        foreach ($socialFields as $label => $key) {
            $url = $footerSettings[$key];
            if ($url !== '' && !filter_var($url, FILTER_VALIDATE_URL)) {
                $errors[] = $label . ' bağlantısı için geçerli bir URL girin.';
            }
        }

        if (empty($errors)) {
            try {
                $pdo->beginTransaction();
                
                // Marka içeriği formu
                if ($formAction === 'brand' || $formAction === 'all') {
                    saveSetting('footer_brand_title', $footerSettings['brand_title'], false);
                    saveSetting('footer_brand_tagline', $footerSettings['brand_tagline'], false);
                    saveSetting('footer_brand_description', $footerSettings['brand_description'], false);
                    saveSetting('footer_brand_highlight', $footerSettings['brand_highlight'], false);
                }
                
                // Sosyal medya & iletişim formu
                if ($formAction === 'social' || $formAction === 'all') {
                    saveSetting('footer_social_instagram', $footerSettings['social_instagram'], false);
                    saveSetting('footer_social_twitter', $footerSettings['social_twitter'], false);
                    saveSetting('footer_social_whatsapp', $footerSettings['social_whatsapp'], false);
                    saveSetting('footer_social_youtube', $footerSettings['social_youtube'], false);
                    saveSetting('footer_contact_phone', $footerSettings['contact_phone'], false);
                    saveSetting('footer_contact_email', $footerSettings['contact_email'], false);
                    saveSetting('footer_contact_address', $footerSettings['contact_address'], false);
                }
                
                // Başlıklar formu
                if ($formAction === 'headings' || $formAction === 'all') {
                    saveSetting('footer_menu_heading', $footerSettings['menu_heading'], false);
                    saveSetting('footer_category_heading', $footerSettings['category_heading'], false);
                    saveSetting('footer_contact_heading', $footerSettings['contact_heading'], false);
                    saveSetting('footer_payment_badges', $footerSettings['payment_badges'], false);
                    saveSetting('footer_bottom_text', $footerSettings['bottom_text'], false);
                }
                
                // Kategoriler formu
                if ($formAction === 'categories' || $formAction === 'all') {
                    saveSetting('footer_category_ids', !empty($footerSelectedCategoryIds) ? json_encode($footerSelectedCategoryIds) : '', false);
                }
                
                $pdo->commit();
            } catch (Throwable $th) {
                if ($pdo->inTransaction()) {
                    $pdo->rollBack();
                }
                $errors[] = 'Footer ayarları kaydedilemedi: ' . $th->getMessage();
            }
        }

        if (empty($errors)) {
            loadSettings(true);
            flashMessage('success', 'Footer ayarları başarıyla güncellendi.');
            redirect('settings-footer.php');
        }
    }
}

include 'includes/admin-header.php';
?>

<div class="admin-page settings-page">
    <?php if (!empty($errors)): ?>
        <div class="admin-alerts">
            <?php foreach ($errors as $error): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <i class="fas fa-exclamation-triangle me-2"></i><?= sanitize($error) ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <form method="post" class="glass-surface">
        <input type="hidden" name="csrf_token" value="<?= generateCSRFToken() ?>">
        <input type="hidden" name="form_action" value="brand">
        <div class="panel-head">
            <div>
                <h5>Marka İçeriği</h5>
                <p class="panel-subtitle">Footer'da gösterilecek tanıtım metinleri</p>
            </div>
            <button type="submit" class="btn btn-primary"><i class="fas fa-save me-2"></i>Ayarları Kaydet</button>
        </div>
        <div class="row g-4">
            <div class="col-md-6">
                <label class="form-label">Marka Başlığı</label>
                <input type="text" name="footer_brand_title" class="form-control" value="<?= sanitize($footerSettings['brand_title']) ?>">
            </div>
            <div class="col-md-6">
                <label class="form-label">Marka Alt Başlığı</label>
                <input type="text" name="footer_brand_tagline" class="form-control" value="<?= sanitize($footerSettings['brand_tagline']) ?>">
            </div>
            <div class="col-md-6">
                <label class="form-label">Öne Çıkan Mesaj</label>
                <textarea name="footer_brand_highlight" class="form-control" rows="3"><?= sanitize($footerSettings['brand_highlight']) ?></textarea>
            </div>
            <div class="col-md-6">
                <label class="form-label">Kısa Açıklama</label>
                <textarea name="footer_brand_description" class="form-control" rows="3"><?= sanitize($footerSettings['brand_description']) ?></textarea>
            </div>
        </div>
    </form>

    <form method="post" class="glass-surface">
        <input type="hidden" name="csrf_token" value="<?= generateCSRFToken() ?>">
        <input type="hidden" name="form_action" value="social">
        <div class="panel-head">
            <div>
                <h5>Sosyal Medya & İletişim</h5>
                <p class="panel-subtitle">Footer iletişim ve sosyal medya bağlantıları</p>
            </div>
            <button type="submit" class="btn btn-primary"><i class="fas fa-save me-2"></i>Ayarları Kaydet</button>
        </div>
        <div class="row g-4">
            <div class="col-md-6">
                <label class="form-label">Instagram URL</label>
                <input type="url" name="footer_social_instagram" class="form-control" value="<?= sanitize($footerSettings['social_instagram']) ?>">
            </div>
            <div class="col-md-6">
                <label class="form-label">Twitter URL</label>
                <input type="url" name="footer_social_twitter" class="form-control" value="<?= sanitize($footerSettings['social_twitter']) ?>">
            </div>
            <div class="col-md-6">
                <label class="form-label">WhatsApp URL</label>
                <input type="url" name="footer_social_whatsapp" class="form-control" value="<?= sanitize($footerSettings['social_whatsapp']) ?>">
            </div>
            <div class="col-md-6">
                <label class="form-label">YouTube URL</label>
                <input type="url" name="footer_social_youtube" class="form-control" value="<?= sanitize($footerSettings['social_youtube']) ?>">
            </div>
            <div class="col-md-4">
                <label class="form-label">İletişim Telefonu</label>
                <input type="text" name="footer_contact_phone" class="form-control" value="<?= sanitize($footerSettings['contact_phone']) ?>">
            </div>
            <div class="col-md-4">
                <label class="form-label">İletişim E-postası</label>
                <input type="email" name="footer_contact_email" class="form-control" value="<?= sanitize($footerSettings['contact_email']) ?>">
            </div>
            <div class="col-md-4">
                <label class="form-label">Adres</label>
                <input type="text" name="footer_contact_address" class="form-control" value="<?= sanitize($footerSettings['contact_address']) ?>">
            </div>
        </div>
    </form>

    <form method="post" class="glass-surface">
        <input type="hidden" name="csrf_token" value="<?= generateCSRFToken() ?>">
        <input type="hidden" name="form_action" value="headings">
        <div class="panel-head">
            <div>
                <h5>Başlıklar ve Etiketler</h5>
                <p class="panel-subtitle">Footer sütun başlıkları ve alt metinler</p>
            </div>
            <button type="submit" class="btn btn-primary"><i class="fas fa-save me-2"></i>Başlıkları Kaydet</button>
        </div>
        <div class="row g-4">
            <div class="col-md-4">
                <label class="form-label">Menü Başlığı</label>
                <input type="text" name="footer_menu_heading" class="form-control" value="<?= sanitize($footerSettings['menu_heading']) ?>">
            </div>
            <div class="col-md-4">
                <label class="form-label">Kategori Başlığı</label>
                <input type="text" name="footer_category_heading" class="form-control" value="<?= sanitize($footerSettings['category_heading']) ?>">
            </div>
            <div class="col-md-4">
                <label class="form-label">İletişim Başlığı</label>
                <input type="text" name="footer_contact_heading" class="form-control" value="<?= sanitize($footerSettings['contact_heading']) ?>">
            </div>
            <div class="col-md-6">
                <label class="form-label">Ödeme Yöntemleri (etiketleri | ile ayırın)</label>
                <input type="text" name="footer_payment_badges" class="form-control" value="<?= sanitize($footerSettings['payment_badges']) ?>">
            </div>
            <div class="col-md-6">
                <label class="form-label">Alt Kısım Metni</label>
                <textarea name="footer_bottom_text" class="form-control" rows="3"><?= sanitize($footerSettings['bottom_text']) ?></textarea>
            </div>
        </div>
    </form>

    <form method="post" class="glass-surface">
        <input type="hidden" name="csrf_token" value="<?= generateCSRFToken() ?>">
        <input type="hidden" name="form_action" value="categories">
        <div class="panel-head">
            <div>
                <h5>Popüler Kategoriler</h5>
                <p class="panel-subtitle">Footer'da "Popüler kategoriler" bölümünde gösterilecek kategorileri seçin</p>
            </div>
            <button type="submit" class="btn btn-primary"><i class="fas fa-save me-2"></i>Kategorileri Kaydet</button>
        </div>
        <div class="row g-3">
            <div class="col-12">
                <select name="footer_categories[]" class="form-select" multiple size="8">
                    <?php foreach ($allFooterCategories as $category): ?>
                        <option value="<?= (int)$category['id'] ?>" <?= in_array((int)$category['id'], $footerSelectedCategoryIds, true) ? 'selected' : '' ?>><?= sanitize($category['name']) ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-12 text-muted small">
                <i class="fas fa-circle-info me-1"></i>Ctrl/Cmd tuşuna basılı tutarak birden fazla kategori seçebilirsiniz.
            </div>
        </div>
    </form>
</div>

<?php include 'includes/admin-footer.php'; ?>
