<?php
require_once '../config.php';

// Admin authentication check
requireAdmin();

$pageTitle = 'Slider Yönetimi';

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!verifyCSRFToken($_POST['csrf_token'] ?? '')) {
        setFlashMessage('error', 'Geçersiz form verisi!');
        redirect('slider.php');
    }

    $action = $_POST['action'] ?? '';

    try {
        // Slider Settings Update
        if ($action === 'update_slider_settings') {
            $stmt = $pdo->prepare("INSERT INTO settings (setting_key, setting_value) VALUES (?, ?) ON DUPLICATE KEY UPDATE setting_value = VALUES(setting_value)");
            
            $stmt->execute(['slider_autoplay_enabled', isset($_POST['autoplay_enabled']) ? '1' : '0']);
            $stmt->execute(['slider_autoplay_delay', (int)($_POST['autoplay_delay'] ?? 5000)]);
            
            // Clear cache
            getAppSettings(true);
            
            setFlashMessage('success', 'Slider ayarları güncellendi!');
            redirect('slider.php');
        }
        
        // Main Slider Actions
        elseif ($action === 'add_slide') {
            $image = $_POST['image'] ?? 'assets/images/hero-showcase.svg';
            if (!empty($_FILES['image_file']['name'])) {
                $image = uploadImageFile($_FILES['image_file'], 'slider');
            }

            $stmt = $pdo->prepare("INSERT INTO homepage_slider_items (display_order, is_active, eyebrow, title, highlight, description, primary_label, primary_icon, primary_url, secondary_label, secondary_icon, secondary_url, image, badge_primary_icon, badge_primary_text, badge_secondary_icon, badge_secondary_text) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            $stmt->execute([
                $_POST['display_order'] ?? 0,
                isset($_POST['is_active']) ? 1 : 0,
                $_POST['eyebrow'] ?? '',
                $_POST['title'] ?? '',
                $_POST['highlight'] ?? '',
                $_POST['description'] ?? '',
                $_POST['primary_label'] ?? '',
                $_POST['primary_icon'] ?? '',
                $_POST['primary_url'] ?? '',
                $_POST['secondary_label'] ?? '',
                $_POST['secondary_icon'] ?? '',
                $_POST['secondary_url'] ?? '',
                $image,
                $_POST['badge_primary_icon'] ?? '',
                $_POST['badge_primary_text'] ?? '',
                $_POST['badge_secondary_icon'] ?? '',
                $_POST['badge_secondary_text'] ?? '',
            ]);

            setFlashMessage('success', 'Slider başarıyla eklendi!');
        } elseif ($action === 'edit_slide') {
            $id = (int)$_POST['id'];
            $image = $_POST['current_image'] ?? 'assets/images/hero-showcase.svg';
            
            if (!empty($_FILES['image_file']['name'])) {
                if ($image && $image !== 'assets/images/hero-showcase.svg') {
                    deleteUploadedFile($image);
                }
                $image = uploadImageFile($_FILES['image_file'], 'slider');
            }

            $stmt = $pdo->prepare("UPDATE homepage_slider_items SET display_order=?, is_active=?, eyebrow=?, title=?, highlight=?, description=?, primary_label=?, primary_icon=?, primary_url=?, secondary_label=?, secondary_icon=?, secondary_url=?, image=?, badge_primary_icon=?, badge_primary_text=?, badge_secondary_icon=?, badge_secondary_text=? WHERE id=?");
            $stmt->execute([
                $_POST['display_order'] ?? 0,
                isset($_POST['is_active']) ? 1 : 0,
                $_POST['eyebrow'] ?? '',
                $_POST['title'] ?? '',
                $_POST['highlight'] ?? '',
                $_POST['description'] ?? '',
                $_POST['primary_label'] ?? '',
                $_POST['primary_icon'] ?? '',
                $_POST['primary_url'] ?? '',
                $_POST['secondary_label'] ?? '',
                $_POST['secondary_icon'] ?? '',
                $_POST['secondary_url'] ?? '',
                $image,
                $_POST['badge_primary_icon'] ?? '',
                $_POST['badge_primary_text'] ?? '',
                $_POST['badge_secondary_icon'] ?? '',
                $_POST['badge_secondary_text'] ?? '',
                $id
            ]);

            setFlashMessage('success', 'Slider güncellendi!');
        } elseif ($action === 'delete_slide') {
            $id = (int)$_POST['id'];
            $stmt = $pdo->prepare("SELECT image FROM homepage_slider_items WHERE id=?");
            $stmt->execute([$id]);
            $slide = $stmt->fetch();
            
            if ($slide && $slide['image'] && $slide['image'] !== 'assets/images/hero-showcase.svg') {
                deleteUploadedFile($slide['image']);
            }
            
            $pdo->prepare("DELETE FROM homepage_slider_items WHERE id=?")->execute([$id]);
            setFlashMessage('success', 'Slider silindi!');
        }
        
        // Side Banner Actions
        elseif ($action === 'edit_side_banner') {
            $id = (int)($_POST['id'] ?? 0);
            if ($id <= 0) {
                throw new Exception('Geçersiz banner ID');
            }
            
            $image = $_POST['current_image'] ?? '';
            
            if (!empty($_FILES['image_file']['name'])) {
                if ($image && $image !== 'assets/images/hero-showcase.svg') {
                    deleteUploadedFile($image);
                }
                $image = uploadImageFile($_FILES['image_file'], 'banners');
            }

            $stmt = $pdo->prepare("UPDATE homepage_side_banners SET is_active=?, title=?, link_url=?, image=? WHERE id=?");
            $result = $stmt->execute([
                isset($_POST['is_active']) ? 1 : 0,
                $_POST['title'] ?? '',
                $_POST['link_url'] ?? '',
                $image,
                $id
            ]);
            
            if (!$result) {
                throw new Exception('Veritabanı güncelleme hatası');
            }

            setFlashMessage('success', 'Yan banner güncellendi!');
        }
        
        // Bottom Banner Actions
        elseif ($action === 'edit_bottom_banner') {
            $id = (int)($_POST['id'] ?? 0);
            if ($id <= 0) {
                throw new Exception('Geçersiz banner ID');
            }
            
            $image = $_POST['current_image'] ?? '';
            
            if (!empty($_FILES['image_file']['name'])) {
                if ($image && $image !== 'assets/images/hero-showcase.svg') {
                    deleteUploadedFile($image);
                }
                $image = uploadImageFile($_FILES['image_file'], 'banners');
            }

            $stmt = $pdo->prepare("UPDATE homepage_bottom_banners SET display_order=?, is_active=?, title=?, link_url=?, image=? WHERE id=?");
            $result = $stmt->execute([
                $_POST['display_order'] ?? 0,
                isset($_POST['is_active']) ? 1 : 0,
                $_POST['title'] ?? '',
                $_POST['link_url'] ?? '',
                $image,
                $id
            ]);
            
            if (!$result) {
                throw new Exception('Veritabanı güncelleme hatası');
            }

            setFlashMessage('success', 'Alt banner güncellendi!');
        }

        redirect('slider.php');
    } catch (Exception $e) {
        setFlashMessage('error', 'Hata: ' . $e->getMessage());
        redirect('slider.php');
    }
}

// Fetch all data
$slides = $pdo->query("SELECT * FROM homepage_slider_items ORDER BY display_order ASC, id ASC")->fetchAll();
$sideBanners = $pdo->query("SELECT * FROM homepage_side_banners ORDER BY position ASC")->fetchAll();
$bottomBanners = $pdo->query("SELECT * FROM homepage_bottom_banners ORDER BY display_order ASC, id ASC")->fetchAll();

include 'includes/admin-header.php';
?>

<div class="admin-page-header">
    <h1><i class="fa-solid fa-images me-2"></i><?= $pageTitle ?></h1>
    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addSlideModal">
        <i class="fa-solid fa-plus me-1"></i> Yeni Slide Ekle
    </button>
</div>

<?php displayFlashMessage(); ?>

<!-- Slider Settings Section -->
<div class="card mb-4">
    <div class="card-header">
        <div>
            <h5 class="mb-0"><i class="fas fa-cog me-2 text-primary"></i>Slider Ayarları</h5>
            <p class="text-muted mb-0" style="font-size: 13px;">Ana sayfa slider otomatik geçiş ayarları</p>
        </div>
    </div>
    <div class="card-body">
        <form method="POST" id="slider-settings-form">
            <input type="hidden" name="csrf_token" value="<?= generateCSRFToken() ?>">
            <input type="hidden" name="action" value="update_slider_settings">
            
            <div class="row g-4">
                <div class="col-md-6">
                    <label class="form-label">Otomatik Geçiş Süresi (milisaniye)</label>
                    <input type="number" name="autoplay_delay" class="form-control" value="<?= getSetting('slider_autoplay_delay') ?: 5000 ?>" min="1000" step="500">
                    <small class="text-muted">1000 = 1 saniye. Örnek: 5000 = 5 saniye</small>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Otomatik Geçiş</label>
                    <div class="form-check form-switch mt-2">
                        <input type="checkbox" name="autoplay_enabled" class="form-check-input" id="autoplay_enabled" <?= getSetting('slider_autoplay_enabled') == '1' ? 'checked' : '' ?>>
                        <label class="form-check-label" for="autoplay_enabled">Otomatik geçişi aktif et</label>
                    </div>
                    <small class="text-muted d-block mt-2">Slider otomatik olarak geçiş yapacak</small>
                </div>
            </div>
        </form>
    </div>
    <div class="card-footer d-flex justify-content-end gap-2 bg-transparent border-top">
        <button type="submit" form="slider-settings-form" class="btn btn-primary">
            <i class="fas fa-save me-2"></i>Ayarları Kaydet
        </button>
    </div>
</div>

<!-- Main Slider Section -->
<div class="card mb-4">
    <div class="card-header">
        <div>
            <h5 class="mb-0"><i class="fas fa-sliders me-2 text-success"></i>Ana Slider</h5>
            <p class="text-muted mb-0" style="font-size: 13px;">Ana sayfada görünen slider slaytları</p>
        </div>
        <span class="badge bg-info"><i class="fas fa-images me-1"></i><?= count($slides) ?> Slide</span>
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover mb-0 align-middle">
                <thead>
                    <tr>
                        <th width="80">Görsel</th>
                        <th>Başlık</th>
                        <th width="100">Sıra</th>
                        <th width="80">Durum</th>
                        <th width="150" class="text-end">İşlemler</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($slides)): ?>
                        <?php foreach ($slides as $slide): ?>
                        <tr>
                            <td>
                                <img src="<?= publicUrl($slide['image']) ?>" alt="" class="img-thumbnail" style="width: 60px; height: 40px; object-fit: cover;">
                            </td>
                            <td>
                                <strong><?= htmlspecialchars($slide['title']) ?></strong>
                                <?php if ($slide['eyebrow']): ?>
                                    <br><small class="text-muted"><?= htmlspecialchars($slide['eyebrow']) ?></small>
                                <?php endif; ?>
                            </td>
                            <td><span class="badge bg-light text-dark"><?= $slide['display_order'] ?></span></td>
                            <td>
                                <?php if ($slide['is_active']): ?>
                                    <span class="badge bg-success"><i class="fas fa-check me-1"></i>Aktif</span>
                                <?php else: ?>
                                    <span class="badge bg-secondary"><i class="fas fa-times me-1"></i>Pasif</span>
                                <?php endif; ?>
                            </td>
                            <td class="text-end">
                                <div class="btn-group" role="group">
                                    <button type="button" class="btn btn-sm btn-primary" onclick="editSlide(<?= htmlspecialchars(json_encode($slide), ENT_QUOTES, 'UTF-8') ?>)">
                                        <i class="fas fa-edit"></i>
                                    </button>
                                    <button type="button" class="btn btn-sm btn-danger" onclick="deleteSlide(<?= $slide['id'] ?>)">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="5" class="text-center text-muted py-4">Henüz slider eklenmemiş.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Side Banners Section -->
<div class="card mb-4">
    <div class="card-header">
        <div>
            <h5 class="mb-0"><i class="fas fa-rectangle-ad me-2 text-info"></i>Yan Bannerlar (2'li Grid)</h5>
            <p class="text-muted mb-0" style="font-size: 13px;">Ana slider yanında yer alan 2'li banner alanı</p>
        </div>
        <span class="badge bg-info"><i class="fas fa-images me-1"></i>2 Banner</span>
    </div>
    <div class="card-body">
        <div class="row g-3">
            <?php foreach ($sideBanners as $banner): ?>
            <div class="col-md-6">
                <div class="card shadow-sm">
                    <img src="<?= publicUrl($banner['image']) ?>" class="card-img-top" alt="" style="height: 200px; object-fit: cover;">
                    <div class="card-body">
                        <h5 class="mb-3"><?= htmlspecialchars($banner['title'] ?: 'Banner ' . $banner['position']) ?></h5>
                        <div class="mb-3">
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <span class="text-muted small">Pozisyon:</span>
                                <span class="badge bg-light text-dark"><?= $banner['position'] == 1 ? 'Üst' : 'Alt' ?></span>
                            </div>
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <span class="text-muted small">Durum:</span>
                                <?php if ($banner['is_active']): ?>
                                    <span class="badge bg-success"><i class="fas fa-check me-1"></i>Aktif</span>
                                <?php else: ?>
                                    <span class="badge bg-secondary"><i class="fas fa-times me-1"></i>Pasif</span>
                                <?php endif; ?>
                            </div>
                            <div class="d-flex flex-column">
                                <span class="text-muted small mb-1">Link:</span>
                                <small class="text-truncate" style="max-width: 100%;"><?= htmlspecialchars($banner['link_url']) ?></small>
                            </div>
                        </div>
                        <button type="button" class="btn btn-sm btn-primary w-100" onclick="editSideBanner(<?= htmlspecialchars(json_encode($banner), ENT_QUOTES, 'UTF-8') ?>)">
                            <i class="fas fa-edit me-1"></i>Düzenle
                        </button>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>

<!-- Bottom Banners Section -->
<div class="card mb-4">
    <div class="card-header">
        <div>
            <h5 class="mb-0"><i class="fas fa-images me-2 text-danger"></i>Alt Bannerlar (3'lü Grid)</h5>
            <p class="text-muted mb-0" style="font-size: 13px;">Ana sayfa altında yer alan 3'lü banner alanı</p>
        </div>
        <span class="badge bg-info"><i class="fas fa-images me-1"></i>3 Banner</span>
    </div>
    <div class="card-body">
        <div class="row g-3">
            <?php foreach ($bottomBanners as $banner): ?>
            <div class="col-md-4">
                <div class="card shadow-sm">
                    <img src="<?= publicUrl($banner['image']) ?>" class="card-img-top" alt="" style="height: 150px; object-fit: cover;">
                    <div class="card-body">
                        <h5 class="card-title"><?= htmlspecialchars($banner['title'] ?: 'Banner ' . $banner['display_order']) ?></h5>
                        <div class="mb-3">
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <span class="text-muted small">Sıra:</span>
                                <span class="badge bg-light text-dark"><?= $banner['display_order'] ?></span>
                            </div>
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <span class="text-muted small">Durum:</span>
                                <?php if ($banner['is_active']): ?>
                                    <span class="badge bg-success"><i class="fas fa-check me-1"></i>Aktif</span>
                                <?php else: ?>
                                    <span class="badge bg-secondary"><i class="fas fa-times me-1"></i>Pasif</span>
                                <?php endif; ?>
                            </div>
                            <div class="d-flex flex-column">
                                <span class="text-muted small mb-1">Link:</span>
                                <small class="text-truncate" style="max-width: 100%;"><?= htmlspecialchars($banner['link_url']) ?></small>
                            </div>
                        </div>
                        <button type="button" class="btn btn-sm btn-primary w-100" onclick="editBottomBanner(<?= htmlspecialchars(json_encode($banner), ENT_QUOTES, 'UTF-8') ?>)">
                            <i class="fas fa-edit me-1"></i>Düzenle
                        </button>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>

<!-- Add Slide Modal -->
<div class="modal fade" id="addSlideModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <form method="POST" enctype="multipart/form-data">
                <input type="hidden" name="csrf_token" value="<?= generateCSRFToken() ?>">
                <input type="hidden" name="action" value="add_slide">
                
                <div class="modal-header">
                    <h5 class="modal-title">Yeni Slide Ekle</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                
                <div class="modal-body">
                    <div class="row g-3">
                        <div class="col-md-8">
                            <label class="form-label">Başlık *</label>
                            <input type="text" name="title" class="form-control" required>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Sıra</label>
                            <input type="number" name="display_order" class="form-control" value="0">
                        </div>
                        <div class="col-md-12">
                            <label class="form-label">Üst Başlık (Eyebrow)</label>
                            <input type="text" name="eyebrow" class="form-control">
                        </div>
                        <div class="col-md-12">
                            <label class="form-label">Vurgulanan Kelime (Highlight)</label>
                            <input type="text" name="highlight" class="form-control">
                        </div>
                        <div class="col-md-12">
                            <label class="form-label">Açıklama</label>
                            <textarea name="description" class="form-control" rows="3"></textarea>
                        </div>
                        <div class="col-md-12">
                            <label class="form-label">Görsel Yükle</label>
                            <input type="file" name="image_file" class="form-control" accept="image/*">
                        </div>
                        <div class="col-md-12">
                            <div class="form-check">
                                <input type="checkbox" name="is_active" class="form-check-input" id="add_is_active" checked>
                                <label class="form-check-label" for="add_is_active">Aktif</label>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                    <button type="submit" class="btn btn-primary">Ekle</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Slide Modal -->
<div class="modal fade" id="editSlideModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <form method="POST" enctype="multipart/form-data" id="editSlideForm">
                <input type="hidden" name="csrf_token" value="<?= generateCSRFToken() ?>">
                <input type="hidden" name="action" value="edit_slide">
                <input type="hidden" name="id" id="edit_slide_id">
                <input type="hidden" name="current_image" id="edit_slide_current_image">
                
                <div class="modal-header">
                    <h5 class="modal-title">Slide Düzenle</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                
                <div class="modal-body">
                    <div class="row g-3">
                        <div class="col-md-8">
                            <label class="form-label">Başlık *</label>
                            <input type="text" name="title" id="edit_slide_title" class="form-control" required>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Sıra</label>
                            <input type="number" name="display_order" id="edit_slide_order" class="form-control">
                        </div>
                        <div class="col-md-12">
                            <label class="form-label">Üst Başlık (Eyebrow)</label>
                            <input type="text" name="eyebrow" id="edit_slide_eyebrow" class="form-control">
                        </div>
                        <div class="col-md-12">
                            <label class="form-label">Açıklama</label>
                            <textarea name="description" id="edit_slide_description" class="form-control" rows="3"></textarea>
                        </div>
                        <div class="col-md-12">
                            <label class="form-label">Mevcut Görsel</label>
                            <img id="edit_slide_preview" src="" alt="" style="max-width: 200px; display: block; margin-bottom: 10px; border-radius: 4px;">
                        </div>
                        <div class="col-md-12">
                            <label class="form-label">Yeni Görsel Yükle</label>
                            <input type="file" name="image_file" class="form-control" accept="image/*">
                        </div>
                        <div class="col-md-12">
                            <div class="form-check">
                                <input type="checkbox" name="is_active" class="form-check-input" id="edit_slide_active">
                                <label class="form-check-label" for="edit_slide_active">Aktif</label>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                    <button type="submit" class="btn btn-primary">Güncelle</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Side Banner Modal -->
<div class="modal fade" id="editSideBannerModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="POST" enctype="multipart/form-data">
                <input type="hidden" name="csrf_token" value="<?= generateCSRFToken() ?>">
                <input type="hidden" name="action" value="edit_side_banner">
                <input type="hidden" name="id" id="edit_side_id">
                <input type="hidden" name="current_image" id="edit_side_current_image">
                
                <div class="modal-header">
                    <h5 class="modal-title">Yan Banner Düzenle</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Başlık</label>
                        <input type="text" name="title" id="edit_side_title" class="form-control">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Link URL</label>
                        <input type="text" name="link_url" id="edit_side_link" class="form-control">
                        <small class="text-muted">Örnek: products, marketplace</small>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Mevcut Görsel</label>
                        <img id="edit_side_preview" src="" alt="" style="max-width: 100%; display: block; margin-bottom: 10px; border-radius: 4px;">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Yeni Görsel Yükle</label>
                        <input type="file" name="image_file" class="form-control" accept="image/*">
                    </div>
                    <div class="form-check">
                        <input type="checkbox" name="is_active" class="form-check-input" id="edit_side_active">
                        <label class="form-check-label" for="edit_side_active">Aktif</label>
                    </div>
                </div>
                
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                    <button type="submit" class="btn btn-primary">Güncelle</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Bottom Banner Modal -->
<div class="modal fade" id="editBottomBannerModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="POST" enctype="multipart/form-data">
                <input type="hidden" name="csrf_token" value="<?= generateCSRFToken() ?>">
                <input type="hidden" name="action" value="edit_bottom_banner">
                <input type="hidden" name="id" id="edit_bottom_id">
                <input type="hidden" name="current_image" id="edit_bottom_current_image">
                
                <div class="modal-header">
                    <h5 class="modal-title">Alt Banner Düzenle</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Başlık</label>
                        <input type="text" name="title" id="edit_bottom_title" class="form-control">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Link URL</label>
                        <input type="text" name="link_url" id="edit_bottom_link" class="form-control">
                        <small class="text-muted">Örnek: products, marketplace</small>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Sıra</label>
                        <input type="number" name="display_order" id="edit_bottom_order" class="form-control">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Mevcut Görsel</label>
                        <img id="edit_bottom_preview" src="" alt="" style="max-width: 100%; display: block; margin-bottom: 10px; border-radius: 4px;">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Yeni Görsel Yükle</label>
                        <input type="file" name="image_file" class="form-control" accept="image/*">
                    </div>
                    <div class="form-check">
                        <input type="checkbox" name="is_active" class="form-check-input" id="edit_bottom_active">
                        <label class="form-check-label" for="edit_bottom_active">Aktif</label>
                    </div>
                </div>
                
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                    <button type="submit" class="btn btn-primary">Güncelle</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function editSlide(slide) {
    console.log('editSlide called', slide);
    
    try {
        document.getElementById('edit_slide_id').value = slide.id;
        document.getElementById('edit_slide_title').value = slide.title;
        document.getElementById('edit_slide_order').value = slide.display_order;
        document.getElementById('edit_slide_eyebrow').value = slide.eyebrow || '';
        document.getElementById('edit_slide_description').value = slide.description || '';
        document.getElementById('edit_slide_current_image').value = slide.image;
        
        const baseUrl = window.location.origin + window.location.pathname.replace('/admin/slider.php', '');
        document.getElementById('edit_slide_preview').src = baseUrl + '/' + slide.image;
        document.getElementById('edit_slide_active').checked = slide.is_active == 1;
        
        const modalElement = document.getElementById('editSlideModal');
        if (!modalElement) {
            console.error('Modal element not found');
            return;
        }
        
        if (typeof bootstrap === 'undefined') {
            console.error('Bootstrap not loaded');
            alert('Bootstrap kütüphanesi yüklenmedi!');
            return;
        }
        
        const modal = new bootstrap.Modal(modalElement);
        modal.show();
        console.log('Modal shown');
    } catch (error) {
        console.error('Error in editSlide:', error);
        alert('Modal açılırken hata oluştu: ' + error.message);
    }
}

function deleteSlide(id) {
    if (confirm('Bu slide\'ı silmek istediğinizden emin misiniz?')) {
        const form = document.createElement('form');
        form.method = 'POST';
        form.innerHTML = `
            <input type="hidden" name="csrf_token" value="<?= generateCSRFToken() ?>">
            <input type="hidden" name="action" value="delete_slide">
            <input type="hidden" name="id" value="${id}">
        `;
        document.body.appendChild(form);
        form.submit();
    }
}

function editSideBanner(banner) {
    console.log('editSideBanner called', banner);
    
    try {
        document.getElementById('edit_side_id').value = banner.id;
        document.getElementById('edit_side_title').value = banner.title || '';
        document.getElementById('edit_side_link').value = banner.link_url || '';
        document.getElementById('edit_side_current_image').value = banner.image;
        
        const baseUrl = window.location.origin + window.location.pathname.replace('/admin/slider.php', '');
        document.getElementById('edit_side_preview').src = baseUrl + '/' + banner.image;
        document.getElementById('edit_side_active').checked = banner.is_active == 1;
        
        const modalElement = document.getElementById('editSideBannerModal');
        if (!modalElement) {
            console.error('Modal element not found');
            return;
        }
        
        if (typeof bootstrap === 'undefined') {
            console.error('Bootstrap not loaded');
            alert('Bootstrap kütüphanesi yüklenmedi!');
            return;
        }
        
        const modal = new bootstrap.Modal(modalElement);
        modal.show();
        console.log('Modal shown');
    } catch (error) {
        console.error('Error in editSideBanner:', error);
        alert('Modal açılırken hata oluştu: ' + error.message);
    }
}

function editBottomBanner(banner) {
    console.log('editBottomBanner called', banner);
    
    try {
        document.getElementById('edit_bottom_id').value = banner.id;
        document.getElementById('edit_bottom_title').value = banner.title || '';
        document.getElementById('edit_bottom_link').value = banner.link_url || '';
        document.getElementById('edit_bottom_order').value = banner.display_order;
        document.getElementById('edit_bottom_current_image').value = banner.image;
        
        const baseUrl = window.location.origin + window.location.pathname.replace('/admin/slider.php', '');
        document.getElementById('edit_bottom_preview').src = baseUrl + '/' + banner.image;
        document.getElementById('edit_bottom_active').checked = banner.is_active == 1;
        
        const modalElement = document.getElementById('editBottomBannerModal');
        if (!modalElement) {
            console.error('Modal element not found');
            return;
        }
        
        if (typeof bootstrap === 'undefined') {
            console.error('Bootstrap not loaded');
            alert('Bootstrap kütüphanesi yüklenmedi!');
            return;
        }
        
        const modal = new bootstrap.Modal(modalElement);
        modal.show();
        console.log('Modal shown');
    } catch (error) {
        console.error('Error in editBottomBanner:', error);
        alert('Modal açılırken hata oluştu: ' + error.message);
    }
}
</script>

<?php include 'includes/admin-footer.php'; ?>

