<?php
require_once '../config.php';
requireAdmin();

$statusMap = getSupportTicketStatusMap();
$statusBadgeMap = [
    'open' => 'badge bg-warning text-dark',
    'answered' => 'badge bg-primary',
    'customer_reply' => 'badge bg-info text-dark',
    'resolved' => 'badge bg-success',
];

$statusFilter = isset($_GET['status']) ? strtolower(trim((string)$_GET['status'])) : '';
if ($statusFilter !== '' && !array_key_exists($statusFilter, $statusMap)) {
    $statusFilter = '';
}

$searchQuery = trim($_GET['q'] ?? '');

$where = [];
$params = [];
if ($statusFilter !== '') {
    $where[] = 't.status = :status';
    $params[':status'] = $statusFilter;
}
if ($searchQuery !== '') {
    $where[] = '(t.subject LIKE :search OR t.id = :id_search OR u.username LIKE :search OR u.email LIKE :search)';
    $params[':search'] = '%' . $searchQuery . '%';
    if (ctype_digit($searchQuery)) {
        $params[':id_search'] = (int)$searchQuery;
    } else {
        $params[':id_search'] = 0;
    }
}

$whereSql = !empty($where) ? ('WHERE ' . implode(' AND ', $where)) : '';

try {
    $sql = "SELECT t.*, u.username, u.email FROM support_tickets t LEFT JOIN users u ON u.id = t.user_id $whereSql ORDER BY t.updated_at DESC";
    $stmt = $pdo->prepare($sql);
    $stmt->execute($params);
    $tickets = $stmt->fetchAll() ?: [];
} catch (Throwable $th) {
    $tickets = [];
}

$pageTitle = 'Destek Talepleri';
include 'includes/admin-header.php';
?>

<div class="dashboard-container">
    <div class="card mb-4">
        <div class="card-body">
            <form class="row g-3">
                <div class="col-md-4">
                    <label class="form-label">Durum</label>
                    <select name="status" class="form-select">
                        <option value="">Tümü</option>
                        <?php foreach ($statusMap as $key => $label): ?>
                            <option value="<?= $key ?>" <?= $statusFilter === $key ? 'selected' : '' ?>><?= sanitize($label) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-4">
                    <label class="form-label">Ara</label>
                    <input type="text" name="q" class="form-control" value="<?= sanitize($searchQuery) ?>" placeholder="Konu, kullanıcı veya ID">
                </div>
                <div class="col-md-4 d-flex align-items-end gap-2">
                    <button type="submit" class="btn btn-primary"><i class="fas fa-search me-2"></i>Filtrele</button>
                    <a href="tickets.php" class="btn btn-outline-secondary"><i class="fas fa-rotate-right me-2"></i>Sıfırla</a>
                </div>
            </form>
        </div>
    </div>

    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0"><i class="fas fa-life-ring me-2"></i>Destek Talepleri</h5>
            <span class="badge bg-secondary">Toplam <?= count($tickets) ?> kayıt</span>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Konu</th>
                            <th>Kullanıcı</th>
                            <th>Durum</th>
                            <th>Son Güncelleme</th>
                            <th class="text-end">İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($tickets)): ?>
                        <tr>
                            <td colspan="6" class="text-center text-muted py-4">Herhangi bir destek talebi bulunmuyor.</td>
                        </tr>
                        <?php else: ?>
                            <?php foreach ($tickets as $ticket): ?>
                            <tr>
                                <td>#<?= (int)$ticket['id'] ?></td>
                                <td>
                                    <strong><?= sanitize($ticket['subject']) ?></strong>
                                    <div class="text-muted small">Oluşturulma: <?= date('d.m.Y H:i', strtotime($ticket['created_at'])) ?></div>
                                </td>
                                <td>
                                    <?php if (!empty($ticket['username'])): ?>
                                        <div><strong><?= sanitize($ticket['username']) ?></strong></div>
                                        <div class="text-muted small"><?= sanitize($ticket['email'] ?? '') ?></div>
                                    <?php else: ?>
                                        <span class="badge bg-secondary">Kullanıcı bulunamadı</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <span class="<?= $statusBadgeMap[$ticket['status']] ?? 'badge bg-secondary' ?>"><?= sanitize(getSupportTicketStatusLabel($ticket['status'])) ?></span>
                                </td>
                                <td>
                                    <div><?= date('d.m.Y H:i', strtotime($ticket['updated_at'])) ?></div>
                                    <div class="text-muted small">Son mesaj: <?= date('d.m.Y H:i', strtotime($ticket['last_message_at'])) ?></div>
                                </td>
                                <td class="text-end">
                                    <a class="btn btn-sm btn-outline-primary" href="ticket-detail.php?id=<?= (int)$ticket['id'] ?>">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php include 'includes/admin-footer.php'; ?>


