<?php
require_once '../config.php';
requireAdmin();

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['bulk_action'])) {
    $selectedIds = array_map('intval', $_POST['selected_ids'] ?? []);
    $selectedIds = array_values(array_filter($selectedIds));

    if (empty($selectedIds)) {
        flashMessage('warning', 'Toplu işlem için kullanıcı seçmediniz.');
        redirect('users.php');
    }

    $placeholders = implode(',', array_fill(0, count($selectedIds), '?'));

    try {
        if ($_POST['bulk_action'] === 'activate') {
            $stmt = $pdo->prepare("UPDATE users SET is_active = 1 WHERE is_admin = 0 AND id IN ($placeholders)");
            $stmt->execute($selectedIds);
            flashMessage('success', 'Seçili kullanıcılar aktifleştirildi.');
        } elseif ($_POST['bulk_action'] === 'delete') {
            $stmt = $pdo->prepare("DELETE FROM users WHERE is_admin = 0 AND id IN ($placeholders)");
            $stmt->execute($selectedIds);
            flashMessage('success', 'Seçili kullanıcılar silindi.');
        }
    } catch (Throwable $th) {
        flashMessage('danger', 'Toplu kullanıcı işlemi sırasında hata oluştu: ' . $th->getMessage());
    }

    redirect('users.php');
}

// Pagination
$totalUsersStmt = $pdo->query("SELECT COUNT(*) FROM users WHERE is_admin = 0");
$totalUsers = (int)$totalUsersStmt->fetchColumn();
$pagination = getPaginationData($totalUsers, 10);

// Kullanıcıları getir
$users = $pdo->query("
    SELECT u.*, 
           COUNT(DISTINCT o.id) as order_count,
           COALESCE(SUM(o.total_amount), 0) as total_spent
    FROM users u
    LEFT JOIN orders o ON u.id = o.user_id AND o.status = 'completed'
    WHERE u.is_admin = 0
    GROUP BY u.id
    ORDER BY u.created_at DESC
    LIMIT {$pagination['limit']} OFFSET {$pagination['offset']}
")->fetchAll();

$pageTitle = 'Kullanıcı Yönetimi';
include 'includes/admin-header.php';
?>

<div class="dashboard-container">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3>
            <i class="fas fa-users me-2"></i>Kullanıcı Yönetimi
        </h3>
    </div>
    
    <div class="card">
        <div class="card-header d-flex flex-wrap justify-content-between align-items-center gap-3">
            <h5 class="mb-0"><i class="fas fa-address-book me-2"></i>Kullanıcılar</h5>
            <form method="post" id="userBulkForm" class="bulk-action-toolbar" data-bulk-form="userBulkForm">
                <div class="d-flex align-items-center gap-2">
                    <span class="text-muted small">Seçili kullanıcılar için:</span>
                    <button type="submit" name="bulk_action" value="activate" class="btn btn-sm btn-success" disabled data-bulk-action>
                        <i class="fas fa-check me-1"></i>Toplu Onayla
                    </button>
                    <button type="submit" name="bulk_action" value="delete" class="btn btn-sm btn-outline-danger" disabled data-bulk-action data-confirm="Seçili kullanıcıları silmek istediğinize emin misiniz?">
                        <i class="fas fa-user-slash me-1"></i>Toplu Sil
                    </button>
                </div>
            </form>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover table-bulk mb-0">
                    <thead>
                        <tr>
                            <th class="text-center" style="width:48px;">
                                <input type="checkbox" class="form-check-input" data-bulk-master="userBulkForm">
                            </th>
                            <th>ID</th>
                            <th>Kullanıcı Adı</th>
                            <th>E-posta</th>
                            <th>Ad Soyad</th>
                            <th>Bakiye</th>
                            <th>Sipariş</th>
                            <th>Harcama</th>
                            <th>Durum</th>
                            <th>Kayıt Tarihi</th>
                            <th>İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($users as $user): ?>
                        <tr>
                            <td class="text-center">
                                <input type="checkbox" class="form-check-input" name="selected_ids[]" value="<?= $user['id'] ?>" form="userBulkForm" data-bulk-target="userBulkForm">
                            </td>
                            <td><strong>#<?= $user['id'] ?></strong></td>
                            <td>
                                <strong><?= sanitize($user['username']) ?></strong>
                            </td>
                            <td><?= sanitize($user['email']) ?></td>
                            <td><?= sanitize($user['full_name']) ?></td>
                            <td><strong><?= formatPrice($user['balance']) ?></strong></td>
                            <td>
                                <span class="badge bg-info"><?= $user['order_count'] ?></span>
                            </td>
                            <td><?= formatPrice($user['total_spent']) ?></td>
                            <td>
                                <?php if ($user['is_active']): ?>
                                <span class="badge bg-success">Aktif</span>
                                <?php else: ?>
                                <span class="badge bg-danger">Pasif</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <small><?= date('d.m.Y', strtotime($user['created_at'])) ?></small>
                            </td>
                            <td>
                                <a href="user-detail.php?id=<?= $user['id'] ?>" class="btn btn-sm btn-outline-primary">
                                    <i class="fas fa-eye"></i>
                                </a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            <?php if ($totalUsers > 10): ?>
            <div class="card-body border-top">
                <?= renderPagination($pagination) ?>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php include 'includes/admin-footer.php'; ?>
