<?php
require_once '../config.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    echo json_encode(['success' => false, 'message' => 'Oturum açmanız gerekiyor.']);
    exit;
}

// Admin kontrolü ekle
if (!isAdmin()) {
    echo json_encode(['success' => false, 'message' => 'Bu işlem için yetkiniz yok.']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Geçersiz istek.']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);
$userId = intval($data['user_id'] ?? 0);
$amount = floatval($data['amount'] ?? 0);

if ($userId <= 0) {
    echo json_encode(['success' => false, 'message' => 'Geçersiz kullanıcı.']);
    exit;
}

if ($amount < 10) {
    echo json_encode(['success' => false, 'message' => 'Minimum yükleme tutarı 10 TL\'dir.']);
    exit;
}

try {
    $pdo->beginTransaction();
    
    // Bakiye güncelle
    $stmt = $pdo->prepare("UPDATE users SET balance = balance + ? WHERE id = ?");
    $stmt->execute([$amount, $userId]);
    
    // Transaction kaydı oluştur
    $stmt = $pdo->prepare("
        INSERT INTO transactions (user_id, type, amount, description) 
        VALUES (?, 'deposit', ?, 'Admin tarafından bakiye eklendi')
    ");
    $stmt->execute([$userId, $amount]);
    
    $pdo->commit();
    
    // Güncel bakiyeyi al
    $user = getUserInfo($pdo, $userId);
    
    echo json_encode([
        'success' => true, 
        'message' => 'Bakiye başarıyla yüklendi.',
        'new_balance' => $user['balance']
    ]);
    
} catch (Exception $e) {
    $pdo->rollBack();
    echo json_encode(['success' => false, 'message' => 'İşlem sırasında bir hata oluştu: ' . $e->getMessage()]);
}
