<?php
require_once '../config.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    echo json_encode(['success' => false, 'balance' => 0]);
    exit;
}

$stmt = $pdo->prepare('SELECT balance FROM users WHERE id = ?');
$stmt->execute([$_SESSION['user_id']]);
$balance = (float)($stmt->fetchColumn() ?? 0);

echo json_encode([
    'success' => true,
    'balance' => $balance,
    'formatted' => formatPrice($balance)
]);

