<?php
require_once '../config.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'error' => 'Method not allowed']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);
$adId = (int)($data['ad_id'] ?? 0);

if ($adId <= 0) {
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => 'Invalid ad ID']);
    exit;
}

try {
    $stmt = $pdo->prepare('UPDATE advertisements SET clicks_count = clicks_count + 1 WHERE id = ?');
    $stmt->execute([$adId]);
    
    echo json_encode(['success' => true]);
} catch (Throwable $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'error' => 'Database error']);
}

