document.addEventListener('DOMContentLoaded', () => {
    const modalEl = document.getElementById('marketplaceOrderModal');
    if (!modalEl) {
        return;
    }
    if (typeof bootstrap === 'undefined' || !bootstrap.Modal) {
        return;
    }

    const modal = bootstrap.Modal.getOrCreateInstance(modalEl);
    const fieldMap = {
        id: modalEl.querySelector('[data-field="id"]'),
        date: modalEl.querySelector('[data-field="date"]'),
        game: modalEl.querySelector('[data-field="game"]'),
        category: modalEl.querySelector('[data-field="category"]'),
        server: modalEl.querySelector('[data-field="server"]'),
        character: modalEl.querySelector('[data-field="character"]'),
        type: modalEl.querySelector('[data-field="type"]'),
        status: modalEl.querySelector('[data-field="status"]'),
        quantity: modalEl.querySelector('[data-field="quantity"]'),
        price: modalEl.querySelector('[data-field="price"]'),
        total: modalEl.querySelector('[data-field="total"]'),
        codes: modalEl.querySelector('[data-field="codes"]')
    };

    const typeBadgeClass = {
        buy: 'badge bg-primary',
        sell: 'badge bg-warning text-dark'
    };

    const statusBadgeClass = {
        pending: 'badge bg-warning text-dark',
        awaiting_payment: 'badge bg-info text-dark',
        processing: 'badge bg-info text-dark',
        approved: 'badge bg-success',
        completed: 'badge bg-success',
        cancelled: 'badge bg-danger',
        rejected: 'badge bg-danger'
    };

    const escapeHtml = (value) => String(value)
        .replace(/&/g, '&amp;')
        .replace(/</g, '&lt;')
        .replace(/>/g, '&gt;')
        .replace(/"/g, '&quot;')
        .replace(/'/g, '&#39;');

    document.querySelectorAll('[data-order-detail]').forEach((button) => {
        button.addEventListener('click', () => {
            Object.keys(fieldMap).forEach((key) => {
                if (!fieldMap[key]) {
                    return;
                }
                let value = button.dataset[`order${key.charAt(0).toUpperCase()}${key.slice(1)}`];
                if (!value || value.trim() === '' || value === '-') {
                    value = '—';
                }
                if (key === 'codes' && value !== '—') {
                    const codes = value.split(/\s*,\s*/).map((code) => `<code class="marketplace-code">${escapeHtml(code)}</code>`).join('<br>');
                    fieldMap[key].innerHTML = codes;
                } else {
                    fieldMap[key].textContent = value;
                }
            });

            const orderType = (button.dataset.orderType || '').toLowerCase();
            if (fieldMap.type) {
                fieldMap.type.className = typeBadgeClass[orderType] || 'badge bg-secondary';
                fieldMap.type.textContent = orderType === 'sell' ? 'Bize Sat' : 'Satın Al';
            }

            if (fieldMap.status) {
                const statusText = button.dataset.orderStatus || '';
                const statusKey = statusText.toLowerCase();
                fieldMap.status.className = statusBadgeClass[statusKey] || 'badge bg-secondary';
                fieldMap.status.textContent = statusText !== '' ? statusText.toUpperCase() : '—';
            }

            modal.show();
        });
    });
});


