// Swiper
const progressCircle = document.querySelector(".autoplay-progress svg");
const progressContent = document.querySelector(".autoplay-progress span");
var swiperHome = new Swiper(".fp-swiper-home", {
    spaceBetween: 24,
    on: {
        autoplayTimeLeft(s, time, progress) {
            progressCircle.style.setProperty("--progress", 1 - progress);
            progressContent.textContent = `${Math.ceil(time / 1000)}s`;
        }
    }
});

var totalSlides = swiperHome.slides.length;

if (totalSlides == 1) {
    var swiperHome = new Swiper(".fp-swiper-home", {
        spaceBetween: 24,
        on: {
            autoplayTimeLeft(s, time, progress) {
                progressCircle.style.setProperty("--progress", 1 - progress);
                progressContent.textContent = `${Math.ceil(time / 1000)}s`;
            }
        }
    });
} else {
    var swiperHome = new Swiper(".fp-swiper-home", {
        spaceBetween: 24,
        autoplay: {
            delay: 5000,
            disableOnInteraction: false
        },
        on: {
            autoplayTimeLeft(s, time, progress) {
                progressCircle.style.setProperty("--progress", 1 - progress);
                progressContent.textContent = `${Math.ceil(time / 1000)}s`;
            }
        },
        loop: true
    });
}


var swiperCategories = new Swiper(".fp-swiper-categories", {
    spaceBetween: 20,
    slidesPerView: 8,
    pagination: {
        el: ".swiper-pagination",
        clickable: true
    },
    navigation: {
        nextEl: ".fp-swiper-categories-next",
        prevEl: ".fp-swiper-categories-prev"
    },
    breakpoints: {
        1200: {slidesPerView: 8},
        992: {slidesPerView: 7},
        768: {slidesPerView: 5},
        576: {slidesPerView: 4},
        0: {slidesPerView: 3}
    }
});


var swiperTrend = new Swiper(".fp-swiper-trend-categories", {
    spaceBetween: 16,
    slidesPerView: 6,
    pagination: {
        el: ".swiper-pagination",
        clickable: true
    },
    navigation: {
        nextEl: ".fp-swiper-trend-next",
        prevEl: ".fp-swiper-trend-prev"
    },
    breakpoints: {
        1200: {slidesPerView: 6},
        992: {slidesPerView: 5},
        768: {slidesPerView: 4},
        576: {slidesPerView: 3},
        0: {slidesPerView: 2}
    }
});


var swiperTwo = new Swiper(".fp-swiper-two", {
    spaceBetween: 15,
    slidesPerView: 2,
    navigation: {
        nextEl: ".fp-swiper-two-next",
        prevEl: ".fp-swiper-two-prev"
    },
    loop: true,
    breakpoints: {
        768: {slidesPerView: 2},
        0: {slidesPerView: 1},
    }
});


var swiperStreamers = new Swiper(".fp-swiper-streamers", {
    spaceBetween: 15,
    slidesPerView: 5,
    navigation: {
        nextEl: ".fp-swiper-streamers-next",
        prevEl: ".fp-swiper-streamers-prev"
    },
    loop: true,
    breakpoints: {
        1200: {slidesPerView: 5},
        992: {slidesPerView: 4},
        768: {slidesPerView: 3},
        0: {slidesPerView: 2},
    }
});


// Quantity
$(document).on('click', '.fp-quantity-btn.plus', function (e) {
    e.preventDefault();
    var inputElement = $(this).closest('.fp-quantity').find('.form-control');
    var currentValue = parseInt(inputElement.val(), 10);
    inputElement.val(currentValue + 1);
});

// Azaltma fonksiyonu
$(document).on('click', '.fp-quantity-btn.minus', function (e) {
    e.preventDefault();
    var inputElement = $(this).closest('.fp-quantity').find('.form-control');
    var currentValue = parseInt(inputElement.val(), 10);
    if (currentValue > 1) {
        inputElement.val(currentValue - 1);
    }
});


// Theme Color Selector
$(document).ready(function () {
    var savedTheme = getCookie('theme');
    var prefersDark = window.matchMedia('(prefers-color-scheme: dark)').matches;

    if (savedTheme) {
        setTheme(savedTheme);
    } else {
        setTheme(prefersDark ? 'dark' : 'light');
    }

    $('.link-light-theme').click(function (e) {
        e.preventDefault();
        setTheme('light');
    });

    $('.link-dark-theme').click(function (e) {
        e.preventDefault();
        setTheme('dark');
    });

    function setTheme(theme) {
        $('.link-light-theme, .link-dark-theme').removeClass('active');
        $('.link-' + theme + '-theme').addClass('active');

        $('html').attr('data-theme', theme);

        setCookie('theme', theme, 365);

        if (theme === 'dark') {
            $(".logo.dark").hide();
            $(".logo.white").show();
        } else {
            $(".logo.dark").show();
            $(".logo.white").hide();
        }
    }

    function setCookie(name, value, days) {
        var expires = '';
        if (days) {
            var date = new Date();
            date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
            expires = '; expires=' + date.toUTCString();
        }
        document.cookie = name + '=' + value + expires + '; path=/';
    }

    function getCookie(name) {
        var nameEQ = name + '=';
        var ca = document.cookie.split(';');
        for (var i = 0; i < ca.length; i++) {
            var c = ca[i];
            while (c.charAt(0) === ' ') c = c.substring(1, c.length);
            if (c.indexOf(nameEQ) === 0) return c.substring(nameEQ.length, c.length);
        }
        return null;
    }
});


// Mobile Menu
$(".btn-all-categories").click(function(e) {
    e.preventDefault();

    $(".fp-navbar").fadeToggle(150);
    $("body").toggleClass("overflow-hidden");
});


// Tabs
$(document).ready(function () {
    $(".fp-tabs-nav-system a").click(function () {
        $(".fp-tabs-nav-system a").removeClass("active");

        $(this).addClass("active");

        $(".fp-tabs-content").removeClass("active");

        var contentId = $(this).attr("id");
        $("#" + contentId + "-content").addClass("active");

        return false;
    });
});


// Dropdown
$(document).click(function(e) {
    if (!$(e.target).closest(".fp-navbar-dropdown-item .link, .fp-navbar-dropdown-menu").length) {
        $(".fp-navbar-dropdown-menu").fadeOut();
    }
});

$(".fp-navbar-dropdown-item .link").click(function(e) {
    e.preventDefault();
    $(".fp-navbar-ac-menu").fadeOut();
    $(".fp-navbar-dropdown-menu").fadeOut();
    $(this).next(".fp-navbar-dropdown-menu").stop().fadeToggle(200);
    e.stopPropagation();
});



// Client Menu
$(".toggle-client-menu").click(function (e) {
    e.preventDefault();

    $(".client-menu .mobile-none").toggleClass("mobile-show");

    if ($(this).find("i").hasClass("ri-menu-line")) {
        $(this).find("i").removeClass("ri-menu-line");
        $(this).find("i").addClass("ri-close-line");
    } else {
        $(this).find("i").addClass("ri-menu-line");
        $(this).find("i").removeClass("ri-close-line");
    }

});


// Order Item
$(".fp-order-item .head").click(function (e) {
    e.preventDefault();
    $(this).next().toggle();
});


// Auth Toggle
$(".show-register-form").click(function(e) {
    $(".show-login-form").removeClass("active");
    $(this).addClass("active");
    $(".auth-register-form").show();
    $(".auth-login-form").hide();
});

$(".show-login-form").click(function(e) {
    $(".show-register-form").removeClass("active");
    $(this).addClass("active");
    $(".auth-login-form").show();
    $(".auth-register-form").hide();
});


var currentPageUrl = window.location.href;

$('.client-menu a').each(function() {
    if ($(this).attr('href') === currentPageUrl) {
        $(this).addClass('active');
    }
});


// Notification
$(".notification").click(function(e) {
    e.preventDefault();
    $(this).next().toggle();
});

$(document).click(function(e) {
    if (!$(e.target).closest(".right-link.notification").length && !$(e.target).closest(".fp-nav-notification-menu").length) {
        $(".fp-nav-notification-menu").hide();
    }
});


var swiperTestimonials = new Swiper(".fp-swiper-testimonials", {
    spaceBetween: 12,
    slidesPerView: 4,
    pagination: {
        el: ".swiper-pagination",
        clickable: true
    },
    navigation: {
        nextEl: ".fp-swiper-testimonials-next",
        prevEl: ".fp-swiper-testimonials-prev"
    },
    breakpoints: {
        1200: {slidesPerView: 4},
        992: {slidesPerView: 3},
        768: {slidesPerView: 2},
        576: {slidesPerView: 2},
        0: {slidesPerView: 2}
    }
});


$(".fp-dma-toggle").click(function (e) {
    e.preventDefault();
    $(".fp-dropdown-menu-account").fadeToggle(300);
});

$(document).click(function(e) {
    if (!$(e.target).closest(".fp-dma-toggle").length && !$(e.target).closest(".fp-dropdown-menu-account").length) {
        $(".fp-dropdown-menu-account").fadeOut();
    }
});