<?php
require_once 'config.php';

$slug = trim($_GET['slug'] ?? '');
if ($slug === '') {
    http_response_code(404);
    $pageTitle = 'Yazı Bulunamadı';
    include 'includes/header.php';
    ?>
    <section class="section-padding text-center">
        <div class="container-narrow">
            <div class="empty-state">
                <i class="fa-solid fa-pen-nib"></i>
                <h2>Yazı bulunamadı</h2>
                <p>Aradığınız blog yazısına ulaşılamadı. Diğer yazılar için blog sayfamıza göz atın.</p>
                <a class="btn btn-primary mt-3" href="<?= routeUrl('blog') ?>"><i class="fa-solid fa-blog me-2"></i>Bloga dön</a>
            </div>
        </div>
    </section>
    <?php
    include 'includes/footer.php';
    exit;
}

$stmt = $pdo->prepare('SELECT b.*, u.username AS author_username FROM blog_posts b LEFT JOIN users u ON b.author_id = u.id WHERE b.slug = ? AND b.is_published = 1 LIMIT 1');
$stmt->execute([$slug]);
$post = $stmt->fetch();

if (!$post) {
    http_response_code(404);
    $pageTitle = 'Yazı Bulunamadı';
    include 'includes/header.php';
    ?>
    <section class="section-padding text-center">
        <div class="container-narrow">
            <div class="empty-state">
                <i class="fa-solid fa-pen-nib"></i>
                <h2>Yazı bulunamadı</h2>
                <p>Bu bağlantı geçersiz olabilir veya yazı yayından kaldırılmıştır.</p>
                <a class="btn btn-primary mt-3" href="<?= routeUrl('blog') ?>"><i class="fa-solid fa-blog me-2"></i>Bloga dön</a>
            </div>
        </div>
    </section>
    <?php
    include 'includes/footer.php';
    exit;
}

$pageTitle = $post['title'];
$pageMetaTitle = $post['meta_title'] ?: $post['title'];
$metaDescription = $post['meta_description'] ?: siteDescription();
$metaKeywords = $post['meta_keywords'] ?: siteKeywords();
$coverImage = $post['image_path'] ? assetUrl($post['image_path']) : null;
$publishedAt = $post['published_at'] ?? $post['created_at'];
$updatedAt = $post['updated_at'] ?? null;

$relatedStmt = $pdo->prepare('SELECT id, title, slug, published_at FROM blog_posts WHERE is_published = 1 AND id != ? ORDER BY published_at DESC LIMIT 3');
$relatedStmt->execute([$post['id']]);
$relatedPosts = $relatedStmt->fetchAll() ?: [];

include 'includes/header.php';
?>

<section class="category-hero<?= $coverImage ? ' category-hero--has-image' : '' ?>" <?= $coverImage ? 'style="--category-hero-image: url(' . htmlspecialchars($coverImage, ENT_QUOTES, 'UTF-8') . ')"' : '' ?>>
    <div class="category-hero__overlay"></div>
    <div class="container-wide category-hero__inner">
        <div class="category-hero__body">
            <span class="category-hero__eyebrow"><i class="fa-solid fa-blog"></i>Blog Yazısı</span>
            <h1><?= sanitize($post['title']) ?></h1>
            <?php if (!empty($post['excerpt'])): ?>
                <p><?= sanitize($post['excerpt']) ?></p>
            <?php endif; ?>
            <div class="category-hero__tags">
                <span class="category-hero__tag"><i class="fa-solid fa-calendar"></i><?= date('d.m.Y', strtotime($publishedAt)) ?></span>
                <?php if ($updatedAt && strtotime($updatedAt) > strtotime($publishedAt)): ?>
                    <span class="category-hero__tag"><i class="fa-solid fa-pen"></i>Güncelleme: <?= date('d.m.Y', strtotime($updatedAt)) ?></span>
                <?php endif; ?>
                <?php if (!empty($post['author_username'])): ?>
                    <span class="category-hero__tag"><i class="fa-solid fa-user"></i><?= sanitize($post['author_username']) ?></span>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>

<section class="section-padding section-bg-dark">
    <div class="container-wide blog-detail">
        <div class="blog-detail__content">
            <article class="rich-content">
                <?= $post['content'] ?>
            </article>
        </div>
        <?php if (!empty($relatedPosts)): ?>
        <aside class="blog-detail__sidebar">
            <div class="sidebar-card">
                <h5><i class="fa-solid fa-bookmark me-2"></i>Diğer Yazılar</h5>
                <ul>
                    <?php foreach ($relatedPosts as $related): ?>
                    <li>
                        <a href="<?= htmlspecialchars(routeUrl('blog_post', ['slug' => $related['slug']]), ENT_QUOTES, 'UTF-8') ?>">
                            <strong><?= sanitize($related['title']) ?></strong>
                            <span><?= date('d.m.Y', strtotime($related['published_at'] ?? 'now')) ?></span>
                        </a>
                    </li>
                    <?php endforeach; ?>
                </ul>
            </div>
        </aside>
        <?php endif; ?>
    </div>
</section>

<?php include 'includes/footer.php'; ?>


