<?php
require_once 'config.php';

if (!function_exists('shortenText')) {
    function shortenText(?string $text, int $limit = 140): string
    {
        $text = trim((string)$text);
        if ($text === '') {
            return '';
        }
        if (mb_strlen($text) <= $limit) {
            return $text;
        }
        return rtrim(mb_substr($text, 0, $limit - 3)) . '...';
    }
}

$stmt = $pdo->query('SELECT id, title, slug, excerpt, image_path, meta_description, published_at FROM blog_posts WHERE is_published = 1 ORDER BY published_at DESC');
$posts = $stmt->fetchAll() ?: [];

$pageTitle = 'Blog';
$pageMetaTitle = 'Blog Yazıları';
$metaDescription = 'Güncel duyurular, ipuçları ve kampanyalar için blog yazılarımızı keşfedin.';

include 'includes/header.php';
?>

<section class="category-hero">
    <div class="category-hero__overlay"></div>
    <div class="container-wide category-hero__inner">
        <div class="category-hero__body">
            <span class="category-hero__eyebrow"><i class="fa-solid fa-blog"></i>Blog</span>
            <h1>Güncel Haberler &amp; İpuçları</h1>
            <p>Dijital mağazamızdaki yeni içerikleri, kampanyaları ve oyun dünyasından öne çıkan gelişmeleri burada bulabilirsiniz.</p>
        </div>
    </div>
</section>

<section class="section-padding section-bg-dark">
    <div class="container-wide">
        <?php if (empty($posts)): ?>
            <div class="empty-state">
                <i class="fa-solid fa-pen-nib"></i>
                <h3>Henüz blog yazısı yayınlanmadı</h3>
                <p>Çok yakında güncel içeriklerle burada olacağız.</p>
            </div>
        <?php else: ?>
            <div class="blog-grid">
                <?php foreach ($posts as $post): ?>
                <?php
                    $cover = $post['image_path'] ? assetUrl($post['image_path']) : null;
                    $excerpt = $post['excerpt'] ?? $post['meta_description'] ?? '';
                    if ($excerpt === '' && !empty($post['meta_description'])) {
                        $excerpt = $post['meta_description'];
                    }
                    if ($excerpt === '') {
                        $excerpt = 'Detayları görmek için yazıya göz atın.';
                    }
                ?>
                <article class="blog-card">
                    <?php if ($cover): ?>
                    <div class="blog-card__media">
                        <img src="<?= htmlspecialchars($cover, ENT_QUOTES, 'UTF-8') ?>" alt="<?= sanitize($post['title']) ?>">
                    </div>
                    <?php endif; ?>
                    <div class="blog-card__body">
                        <span class="blog-card__date"><i class="fa-solid fa-calendar"></i><?= date('d.m.Y', strtotime($post['published_at'] ?? 'now')) ?></span>
                        <h3 class="blog-card__title"><?= sanitize($post['title']) ?></h3>
                        <p class="blog-card__excerpt"><?= sanitize(shortenText($excerpt, 140)) ?></p>
                        <a class="blog-card__cta" href="<?= htmlspecialchars(routeUrl('blog_post', ['slug' => $post['slug']]), ENT_QUOTES, 'UTF-8') ?>">
                            <span>Yazıyı oku</span>
                            <i class="fa-solid fa-arrow-right"></i>
                        </a>
                    </div>
                </article>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</section>

<?php include 'includes/footer.php'; ?>

