<?php
require_once 'config.php';

// Tüm kategorileri hiyerarşik olarak getir
$categories = getCategories($pdo);
$categoryTree = buildCategoryTree($categories);

// Kategori sayısını hesapla
$totalCategories = count($categories);
$parentCategories = count($categoryTree);
$childCategories = $totalCategories - $parentCategories;

// Ürün sayısını hesapla
$totalProducts = (int)$pdo->query('SELECT COUNT(*) FROM products WHERE is_active = 1')->fetchColumn();

$pageTitle = 'Tüm Kategoriler';
include 'includes/header.php';

// Kategori renkleri
$categoryColors = [
    ['#6366f1', '#818cf8', '99, 102, 241'],
    ['#ec4899', '#f472b6', '236, 72, 153'],
    ['#10b981', '#34d399', '16, 185, 129'],
    ['#f59e0b', '#fbbf24', '245, 158, 11'],
    ['#8b5cf6', '#a78bfa', '139, 92, 246'],
    ['#14b8a6', '#2dd4bf', '20, 184, 166'],
    ['#ef4444', '#f87171', '239, 68, 68'],
    ['#06b6d4', '#22d3ee', '6, 182, 212'],
];
?>

<section class="categories-hero">
    <div class="categories-hero__overlay"></div>
    <div class="container-wide categories-hero__inner">
        <div class="categories-hero__content">
            <span class="categories-hero__eyebrow">
                <i class="fa-solid fa-layer-group"></i>
                Kategoriler
            </span>
            <h1 class="categories-hero__title">Tüm Kategoriler</h1>
            <p class="categories-hero__subtitle">
                Dijital ürünlerimizi keşfedin. Oyun kodları, hediye kartları, streaming abonelikleri ve daha fazlası.
            </p>
            <div class="categories-hero__stats">
                <div class="categories-hero__stat">
                    <i class="fa-solid fa-layer-group"></i>
                    <div>
                        <strong><?= $totalCategories ?></strong>
                        <span>Kategori</span>
                    </div>
                </div>
                <div class="categories-hero__stat">
                    <i class="fa-solid fa-box"></i>
                    <div>
                        <strong><?= $totalProducts ?></strong>
                        <span>Ürün</span>
                    </div>
                </div>
                <div class="categories-hero__stat">
                    <i class="fa-solid fa-fire"></i>
                    <div>
                        <strong>7/24</strong>
                        <span>Destek</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="categories-section">
    <div class="container-wide">
        <?php 
        $colorIndex = 0;
        foreach ($categoryTree as $parentCategory): 
            $colors = $categoryColors[$colorIndex % count($categoryColors)];
            $colorIndex++;
            
            $parentImage = !empty($parentCategory['image']) ? assetUrl($parentCategory['image']) : null;
            $parentIcon = $parentCategory['icon'] ?? 'fa-tag';
            $parentDesc = !empty($parentCategory['description']) ? shortenText($parentCategory['description'], 120) : 'Popüler ürünler ve çeşitli seçenekler.';
            
            // Alt kategorileri al
            $childCategories = $parentCategory['children'] ?? [];
        ?>
        
        <div class="category-main-section">
            <a href="<?= htmlspecialchars(routeUrl('product_category', ['slug' => $parentCategory['slug']]), ENT_QUOTES, 'UTF-8') ?>" 
               class="category-main-card<?= $parentImage ? ' has-bg-image' : '' ?>"
               style="--cat-color-1: <?= $colors[0] ?>; --cat-color-2: <?= $colors[1] ?>; --cat-color-rgb: <?= $colors[2] ?>;"
               <?= $parentImage ? 'data-bg-image="' . htmlspecialchars($parentImage, ENT_QUOTES, 'UTF-8') . '"' : '' ?>>
                <div class="category-main-card__background">
                    <?php if ($parentImage): ?>
                        <img src="<?= htmlspecialchars($parentImage, ENT_QUOTES, 'UTF-8') ?>" alt="<?= sanitize($parentCategory['name']) ?>" class="category-main-card__bg-image">
                    <?php endif; ?>
                </div>
                <div class="category-main-card__pattern"></div>
                <div class="category-main-card__content">
                    <div class="category-main-card__icon">
                        <i class="fa-solid <?= sanitize($parentIcon) ?>"></i>
                    </div>
                    <div class="category-main-card__text">
                        <h2 class="category-main-card__title"><?= sanitize($parentCategory['name']) ?></h2>
                        <p class="category-main-card__desc"><?= sanitize($parentDesc) ?></p>
                        <?php if (!empty($childCategories)): ?>
                            <span class="category-main-card__badge">
                                <i class="fa-solid fa-folder"></i>
                                <?= count($childCategories) ?> Alt Kategori
                            </span>
                        <?php endif; ?>
                    </div>
                    <div class="category-main-card__arrow">
                        <i class="fa-solid fa-arrow-right"></i>
                    </div>
                </div>
            </a>
            
            <?php if (!empty($childCategories)): ?>
            <div class="category-children-grid">
                <?php foreach ($childCategories as $child): 
                    $childImage = !empty($child['image']) ? assetUrl($child['image']) : null;
                    $childIcon = $child['icon'] ?? 'fa-tag';
                ?>
                <a href="<?= htmlspecialchars(routeUrl('product_category', ['slug' => $child['slug']]), ENT_QUOTES, 'UTF-8') ?>" 
                   class="category-child-card<?= $childImage ? ' has-image' : '' ?>">
                    <div class="category-child-card__icon">
                        <?php if ($childImage): ?>
                            <img src="<?= htmlspecialchars($childImage, ENT_QUOTES, 'UTF-8') ?>" alt="<?= sanitize($child['name']) ?>" class="category-child-card__image">
                        <?php else: ?>
                            <i class="fa-solid <?= sanitize($childIcon) ?>"></i>
                        <?php endif; ?>
                    </div>
                    <div class="category-child-card__content">
                        <h3 class="category-child-card__title"><?= sanitize($child['name']) ?></h3>
                        <?php if (!empty($child['description'])): ?>
                            <p class="category-child-card__desc"><?= sanitize(shortenText($child['description'], 60)) ?></p>
                        <?php endif; ?>
                    </div>
                    <div class="category-child-card__arrow">
                        <i class="fa-solid fa-chevron-right"></i>
                    </div>
                </a>
                <?php endforeach; ?>
            </div>
            <?php endif; ?>
        </div>
        
        <?php endforeach; ?>
    </div>
</section>

<?php include 'includes/footer.php'; ?>

