<?php
header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cache Temizleme</title>
    <style>
        body { font-family: Arial, sans-serif; max-width: 600px; margin: 50px auto; padding: 20px; }
        .success { color: #155724; background-color: #d4edda; border: 1px solid #c3e6cb; padding: 15px; border-radius: 5px; margin: 10px 0; }
        .info { color: #004085; background-color: #cce5ff; border: 1px solid #b8daff; padding: 15px; border-radius: 5px; margin: 10px 0; }
        h1 { color: #333; }
        .check { color: green; font-weight: bold; }
        .cross { color: red; font-weight: bold; }
    </style>
</head>
<body>
    <h1>🔄 PHP Cache Temizleme</h1>
    
    <?php
    $results = [];
    
    // Clear PHP OPcache
    if (function_exists('opcache_reset')) {
        opcache_reset();
        $results[] = '<span class="check">✓</span> OPcache başarıyla temizlendi';
    } else {
        $results[] = '<span class="cross">✗</span> OPcache aktif değil';
    }
    
    // Clear realpath cache
    clearstatcache(true);
    $results[] = '<span class="check">✓</span> Stat cache temizlendi';
    
    // Clear APC cache if available
    if (function_exists('apc_clear_cache')) {
        apc_clear_cache();
        $results[] = '<span class="check">✓</span> APC cache temizlendi';
    }
    
    // Display results
    foreach ($results as $result) {
        echo '<div class="success">' . $result . '</div>';
    }
    ?>
    
    <div class="info">
        <strong>✅ Cache temizleme tamamlandı!</strong><br><br>
        <strong>Zaman:</strong> <?= date('d.m.Y H:i:s') ?><br>
        <strong>PHP Versiyonu:</strong> <?= PHP_VERSION ?><br><br>
        Lütfen sayfanızı yenileyerek değişikliklerin aktif olduğunu kontrol edin.
    </div>
    
    <div class="info">
        <strong>📝 Tarayıcı Cache'ini de Temizleyin:</strong><br>
        • Chrome/Edge: <kbd>Ctrl + Shift + Delete</kbd><br>
        • Firefox: <kbd>Ctrl + Shift + Delete</kbd><br>
        • Veya Hard Refresh: <kbd>Ctrl + F5</kbd>
    </div>
    
    <div style="text-align: center; margin-top: 30px;">
        <a href="<?= $_SERVER['HTTP_REFERER'] ?? '/' ?>" style="background: #007bff; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;">← Geri Dön</a>
        <a href="/" style="background: #28a745; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px; margin-left: 10px;">🏠 Ana Sayfa</a>
    </div>
</body>
</html>
