<?php
require_once 'config.php';

$errors = [];
$successMessage = '';
$email = trim($_POST['email'] ?? '');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!verifyCSRFToken($_POST['csrf_token'] ?? '')) {
        $errors[] = 'Güvenlik doğrulaması başarısız. Lütfen formu yeniden gönderin.';
    } else {
        $recaptchaEnabledForgot = recaptchaEnabled('forgot');
        $recaptchaSiteKey = getSetting('recaptcha_site_key', RECAPTCHA_SITE_KEY);
        if ($recaptchaEnabledForgot && $recaptchaSiteKey) {
            $recaptchaToken = trim($_POST['g-recaptcha-response'] ?? '');
            if (!verifyRecaptcha($recaptchaToken)) {
                $errors[] = 'Doğrulama başarısız. Lütfen reCAPTCHA kontrolünü tamamlayın.';
            }
        }
        if (empty($errors)) {
            if ($email === '' || !filter_var($email, FILTER_VALIDATE_EMAIL)) {
                $errors[] = 'Geçerli bir e-posta adresi giriniz.';
            } else {
                $stmt = $pdo->prepare('SELECT id, username FROM users WHERE email = ? LIMIT 1');
                $stmt->execute([$email]);
                $user = $stmt->fetch();

                if ($user) {
                    $token = createPasswordResetToken($pdo, (int)$user['id']);
                    if ($token) {
                        $baseUrl = trim((string)getSetting('email_base_url', EMAIL_BASE_URL));
                        if ($baseUrl === '') {
                            $baseUrl = SITE_URL;
                        }
                        $resetLink = rtrim($baseUrl, '/') . '/reset-password.php?token=' . urlencode($token);
                        $subject = siteName() . ' - Şifre Sıfırlama';

                        $usernameHtml = htmlspecialchars($user['username'], ENT_QUOTES, 'UTF-8');
                        $siteNameHtml = htmlspecialchars(siteName(), ENT_QUOTES, 'UTF-8');
                        $resetUrlHtml = htmlspecialchars($resetLink, ENT_QUOTES, 'UTF-8');
                        $defaultBody = '<p>Merhaba ' . $usernameHtml . ',</p>'
                            . '<p>Şifrenizi sıfırlamak için aşağıdaki bağlantıya tıklayın. Bağlantı 60 dakika geçerlidir.</p>'
                            . '<p><a href="' . $resetUrlHtml . '">' . $resetUrlHtml . '</a></p>'
                            . '<p>Eğer bu işlemi siz gerçekleştirmediyseniz bu e-postayı yok sayabilirsiniz.</p>'
                            . '<p>Sevgiler,<br>' . $siteNameHtml . ' Ekibi</p>';

                        $template = (string)getSetting('email_template_password_reset', '');
                        if (trim($template) !== '') {
                            $replacements = [
                                '{{username}}' => $usernameHtml,
                                '{{site_name}}' => $siteNameHtml,
                                '{{reset_url}}' => $resetUrlHtml,
                                '{{reset_link}}' => '<a href="' . $resetUrlHtml . '">' . $resetUrlHtml . '</a>'
                            ];
                            $body = str_replace(array_keys($replacements), array_values($replacements), $template);
                            $altReplacements = $replacements;
                            $altReplacements['{{reset_link}}'] = $resetUrlHtml;
                            $altBody = strip_tags(str_replace(array_keys($altReplacements), array_values($altReplacements), $template));
                        } else {
                            $body = $defaultBody;
                            $altBody = strip_tags($defaultBody);
                        }

                        @sendEmail($email, $subject, $body, $altBody);
                    }
                }

                $successMessage = 'Eğer girdiğiniz e-posta adresi kayıtlı ise, şifre sıfırlama bağlantısı gönderildi.';
                $logUserId = $user ? (int)$user['id'] : null;
                logUserActivity($pdo, 'auth_password_reset_request', ['email' => $email, 'user_id' => $logUserId]);
            }
        }
    }
}

$pageTitle = 'Şifremi Unuttum';
include 'includes/header.php';
?>

<section class="auth-section">
    <div class="container-wide">
        <div class="auth-layout">
            <div class="auth-highlight card-glass">
                <span class="badge text-bg-primary mb-3"><i class="fa-solid fa-key me-2"></i>Şifre Yardımı</span>
                <h2 class="mb-3">Şifre sıfırlama bağlantısı iste</h2>
                <p class="mb-4 auth-highlight-desc">
                    E-posta adresinizi girin, şifrenizi sıfırlamanız için bağlantı gönderelim.
                </p>
                <a href="<?= routeUrl('login') ?>" class="btn btn-outline-primary">
                    <i class="fa-solid fa-arrow-left me-2"></i>Giriş sayfasına dön
                </a>
            </div>
            <div class="auth-card card-glass">
                <h3>Şifre Sıfırlama</h3>
                <?php if (!empty($errors)): ?>
                    <div class="alert alert-danger">
                        <i class="fa-solid fa-circle-exclamation me-2"></i><?= implode('<br>', array_map('sanitize', $errors)) ?>
                    </div>
                <?php endif; ?>
                <?php if ($successMessage !== ''): ?>
                    <div class="alert alert-success">
                        <i class="fa-solid fa-circle-check me-2"></i><?= sanitize($successMessage) ?>
                    </div>
                <?php endif; ?>
                <?php $recaptchaEnabledForgot = recaptchaEnabled('forgot'); $recaptchaSiteKey = getSetting('recaptcha_site_key', RECAPTCHA_SITE_KEY); ?>
                <form method="post" class="auth-form"<?= $recaptchaEnabledForgot && $recaptchaSiteKey ? ' data-recaptcha-form' : '' ?> autocomplete="off">
                    <input type="hidden" name="csrf_token" value="<?= generateCSRFToken() ?>">
                    <div class="mb-3">
                        <label for="email" class="form-label">E-posta Adresi</label>
                        <input type="email" id="email" name="email" class="form-control" value="<?= sanitize($email) ?>" required>
                    </div>
                    <?php if ($recaptchaEnabledForgot && $recaptchaSiteKey): ?>
                        <div class="mb-3" data-recaptcha data-site-key="<?= sanitize($recaptchaSiteKey) ?>"></div>
                    <?php endif; ?>
                    <button type="submit" class="btn btn-primary w-100">
                        <i class="fa-solid fa-paper-plane me-2"></i>Bağlantı Gönder
                    </button>
                </form>
            </div>
        </div>
    </div>
</section>

<?php include 'includes/footer.php'; ?>

