    </main>

    <?php
    $footerBrandLogoMode = strtolower((string)getSetting('branding_logo_mode', 'text'));
    if (!in_array($footerBrandLogoMode, ['text', 'image'], true)) {
        $footerBrandLogoMode = 'text';
    }
    $footerBrandLogoImage = getSetting('branding_logo_image', '');
    $footerBrandLogoText = trim((string)getSetting('branding_logo_text', ''));
    if ($footerBrandLogoText === '') {
        $footerBrandLogoText = siteName();
    }
    $footerBrandLogoTagline = trim((string)getSetting('branding_logo_tagline', ''));
    $footerBrandTitle = trim((string)getSetting('footer_brand_title', $footerBrandLogoText));
    if ($footerBrandTitle === '') {
        $footerBrandTitle = $footerBrandLogoText;
    }
    $footerBrandTagline = trim((string)getSetting('footer_brand_tagline', $footerBrandLogoTagline));
    $footerBrandLogoUrl = $footerBrandLogoImage !== '' ? assetUrl($footerBrandLogoImage) : '';
    $footerHasLogoImage = $footerBrandLogoMode === 'image' && $footerBrandLogoUrl !== '';
    $footerLogoWidth = (int)getSetting('branding_logo_width', 0);
    $footerLogoHeight = (int)getSetting('branding_logo_height', 0);
    $footerLogoStyleParts = [];
    if ($footerLogoWidth > 0) {
        $footerLogoStyleParts[] = 'width:' . $footerLogoWidth . 'px';
    }
    if ($footerLogoHeight > 0) {
        $footerLogoStyleParts[] = 'height:' . $footerLogoHeight . 'px';
    }
    $footerLogoStyleAttr = !empty($footerLogoStyleParts) ? ' style="' . implode(';', $footerLogoStyleParts) . '"' : '';

    $footerBrandDescription = trim((string)getSetting('footer_brand_description', 'Dijital oyun kodları, marketplace ilanları ve oyun parasında güvenilir çözüm ortağınız.'));
    $footerBrandHighlight = trim((string)getSetting('footer_brand_highlight', 'Hızlı teslimat, güvenli ödeme ve deneyimli destek ekibimizle alışveriş deneyiminizi bir üst seviyeye taşıyoruz.'));

    $footerSocialLinks = [
        'instagram' => trim((string)getSetting('footer_social_instagram', '')),
        'twitter' => trim((string)getSetting('footer_social_twitter', '')),
        'whatsapp' => trim((string)getSetting('footer_social_whatsapp', '')),
        'youtube' => trim((string)getSetting('footer_social_youtube', '')),
    ];

    $footerContactPhone = trim((string)getSetting('footer_contact_phone', '+90 (555) 123 45 67'));
    $footerContactEmail = trim((string)getSetting('footer_contact_email', 'destek@enbmedya.com'));
    $footerContactAddress = trim((string)getSetting('footer_contact_address', 'İstanbul / Türkiye'));

    $footerMenuHeading = trim((string)getSetting('footer_menu_heading', 'Menü'));
    $footerCategoryHeading = trim((string)getSetting('footer_category_heading', 'Popüler kategoriler'));
    $footerContactHeading = trim((string)getSetting('footer_contact_heading', 'İletişim'));

    $footerMenuItems = getNavigationMenu($pdo, 'footer');
    $footerBottomLinks = getNavigationMenu($pdo, 'footer_bottom');

    $footerPaymentBadgesSetting = trim((string)getSetting('footer_payment_badges', 'PayTR|Shopier|3D Secure|SSL'));
    $footerPaymentBadgesList = preg_split('/[\|,\n]+/', $footerPaymentBadgesSetting);
    $footerPaymentBadges = array_values(array_filter(array_map('trim', is_array($footerPaymentBadgesList) ? $footerPaymentBadgesList : [])));

    $footerCategoryIdsRaw = trim((string)getSetting('footer_category_ids', ''));
    $footerCategoryIds = [];
    if ($footerCategoryIdsRaw !== '') {
        $decoded = json_decode($footerCategoryIdsRaw, true);
        if (is_array($decoded)) {
            foreach ($decoded as $id) {
                $id = (int)$id;
                if ($id > 0) {
                    $footerCategoryIds[] = $id;
                }
            }
        } else {
            foreach (preg_split('/[\s,;]+/', $footerCategoryIdsRaw) as $part) {
                $id = (int)$part;
                if ($id > 0) {
                    $footerCategoryIds[] = $id;
                }
            }
        }
        $footerCategoryIds = array_values(array_unique($footerCategoryIds));
    }

    try {
        $allFooterCategories = getCategories($pdo);
    } catch (Throwable $th) {
        $allFooterCategories = [];
    }

    $footerCategories = [];
    if (!empty($footerCategoryIds) && !empty($allFooterCategories)) {
        $categoryMap = [];
        foreach ($allFooterCategories as $category) {
            $categoryMap[$category['id']] = $category;
        }
        foreach ($footerCategoryIds as $catId) {
            if (isset($categoryMap[$catId])) {
                $footerCategories[] = $categoryMap[$catId];
            }
        }
    } else {
        $footerCategories = array_slice($allFooterCategories, 0, 6);
    }

    $footerBottomText = trim((string)getSetting('footer_bottom_text', ''));
    if ($footerBottomText === '') {
        $footerBottomText = '© {{year}} {{site_name}}. Tüm hakları saklıdır.';
    }
    $footerBottomText = str_replace(
        ['{{year}}', '{{site_name}}'],
        [date('Y'), $footerBrandLogoText !== '' ? $footerBrandLogoText : siteName()],
        $footerBottomText
    );

    $socialIconMap = [
        'instagram' => 'fa-instagram',
        'twitter' => 'fa-x-twitter',
        'whatsapp' => 'fa-whatsapp',
        'youtube' => 'fa-youtube',
    ];
    ?>

    <footer class="site-footer" id="destek">
        <div class="container-wide">
            <div class="site-footer__grid">
                <div>
                    <div class="footer-brand">
                        <span class="footer-brand__icon<?= $footerHasLogoImage ? ' footer-brand__icon--image' : '' ?>">
                            <?php if ($footerHasLogoImage): ?>
                                <img src="<?= htmlspecialchars($footerBrandLogoUrl, ENT_QUOTES, 'UTF-8') ?>" alt="<?= sanitize($footerBrandTitle) ?>" class="footer-brand__logo"<?= $footerLogoStyleAttr ?>>
                            <?php else: ?>
                                <i class="fa-solid fa-gamepad"></i>
                            <?php endif; ?>
                        </span>
                        <div>
                            <?php if ($footerBrandTitle !== ''): ?>
                                <h5><?= sanitize($footerBrandTitle) ?></h5>
                            <?php endif; ?>
                            <?php if ($footerBrandTagline !== ''): ?>
                                <p><?= sanitize($footerBrandTagline) ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php if ($footerBrandDescription !== ''): ?>
                        <p><?= sanitize($footerBrandDescription) ?></p>
                    <?php endif; ?>
                    <?php if ($footerBrandHighlight !== ''): ?>
                        <p><?= sanitize($footerBrandHighlight) ?></p>
                    <?php endif; ?>
                    <?php $hasSocialLinks = array_filter($footerSocialLinks); ?>
                    <?php if (!empty($hasSocialLinks)): ?>
                        <div class="footer-social">
                            <?php foreach ($footerSocialLinks as $platform => $url): ?>
                                <?php if ($url === '') { continue; } ?>
                                <?php $iconClass = $socialIconMap[$platform] ?? 'fa-link'; ?>
                                <a href="<?= htmlspecialchars($url, ENT_QUOTES, 'UTF-8') ?>" aria-label="<?= htmlspecialchars(ucfirst($platform), ENT_QUOTES, 'UTF-8') ?>" target="_blank" rel="noopener">
                                    <i class="fa-brands <?= htmlspecialchars($iconClass, ENT_QUOTES, 'UTF-8') ?>"></i>
                                </a>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                </div>
                <div>
                    <h6><?= sanitize($footerMenuHeading) ?></h6>
                    <ul>
                        <?php if (!empty($footerMenuItems)): ?>
                            <?php foreach ($footerMenuItems as $item): ?>
                                <?php
                                    $type = $item['menu_type'] ?? 'link';
                                    $title = $item['title'] ?? '';
                                    $openNewTab = !empty($item['open_new_tab']);
                                    if ($type === 'balance') {
                                        $href = isLoggedIn() ? routeUrl('balance') : routeUrl('login');
                                    } elseif (!empty($item['url'])) {
                                        $href = $item['url'];
                                    } else {
                                        $href = $type === 'marketplace' ? routeUrl('marketplace') : '#';
                                    }
                                ?>
                                <li><a href="<?= htmlspecialchars(seoFriendlyUrl($href), ENT_QUOTES, 'UTF-8') ?>"<?= $openNewTab ? ' target="_blank" rel="noopener noreferrer"' : '' ?>><?= sanitize($title) ?></a></li>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <li><span><?= sanitize('Menü öğesi bulunmuyor.') ?></span></li>
                        <?php endif; ?>
                    </ul>
                </div>
                <div>
                    <h6><?= sanitize($footerCategoryHeading) ?></h6>
                    <ul>
                        <?php if (!empty($footerCategories)): ?>
                            <?php foreach ($footerCategories as $cat): ?>
                                <li><a href="<?= htmlspecialchars(routeUrl('product_category', ['slug' => $cat['slug']]), ENT_QUOTES, 'UTF-8') ?>"><?= sanitize($cat['name']) ?></a></li>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <li><span><?= sanitize('Kategori bulunmuyor.') ?></span></li>
                        <?php endif; ?>
                    </ul>
                </div>
                <div>
                    <h6><?= sanitize($footerContactHeading) ?></h6>
                    <ul>
                        <?php if ($footerContactPhone !== ''): ?>
                            <li><i class="fa-solid fa-phone"></i> <?= sanitize($footerContactPhone) ?></li>
                        <?php endif; ?>
                        <?php if ($footerContactEmail !== ''): ?>
                            <li><i class="fa-solid fa-envelope"></i> <?= sanitize($footerContactEmail) ?></li>
                        <?php endif; ?>
                        <?php if ($footerContactAddress !== ''): ?>
                            <li><i class="fa-solid fa-location-dot"></i> <?= sanitize($footerContactAddress) ?></li>
                        <?php endif; ?>
                    </ul>
                    <?php if (!empty($footerPaymentBadges)): ?>
                        <div class="footer-payments">
                            <?php foreach ($footerPaymentBadges as $badge): ?>
                                <span><?= sanitize($badge) ?></span>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            <div class="footer-bottom">
                <span><?= sanitize($footerBottomText) ?></span>
                <?php if (!empty($footerBottomLinks)): ?>
                    <div class="footer-links">
                        <?php foreach ($footerBottomLinks as $item): ?>
                            <?php
                                $type = $item['menu_type'] ?? 'link';
                                $title = $item['title'] ?? '';
                                $openNewTab = !empty($item['open_new_tab']);
                                if ($type === 'balance') {
                                    $href = isLoggedIn() ? routeUrl('balance') : routeUrl('login');
                                } elseif (!empty($item['url'])) {
                                    $href = $item['url'];
                                } else {
                                    $href = $type === 'marketplace' ? routeUrl('marketplace') : '#';
                                }
                            ?>
                            <a href="<?= htmlspecialchars(seoFriendlyUrl($href), ENT_QUOTES, 'UTF-8') ?>"<?= $openNewTab ? ' target="_blank" rel="noopener noreferrer"' : '' ?>><?= sanitize($title) ?></a>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
    <script>
        window.APP_CONFIG = {
            baseUrl: <?= json_encode(rtrim(siteBaseUrl(), '/'), JSON_UNESCAPED_SLASHES) ?>,
            isLoggedIn: <?= json_encode(isLoggedIn()) ?>,
            apiEndpoints: {
                balance: <?= json_encode(publicUrl('api/balance.php')) ?>,
                marketplacePoll: <?= json_encode(publicUrl('marketplace/api/poll-user.php')) ?>
            }
        };
        
        if (typeof Swiper !== 'undefined') {
            window.SWIPER_LOADED = true;
        }
    </script>
    <script src="<?= publicUrl('assets/js/main.js') ?>?v=<?= time() ?>"></script>
</body>
</html>

