<?php
$recaptchaSiteKey = getSetting('recaptcha_site_key', RECAPTCHA_SITE_KEY);
$recaptchaEnabledLogin = recaptchaEnabled('login');
$recaptchaEnabledRegister = recaptchaEnabled('register');
$recaptchaEnabledForgot = recaptchaEnabled('forgot');

$siteName = siteName();
$metaDescription = isset($metaDescription) ? $metaDescription : siteDescription();
$metaKeywords = isset($metaKeywords) ? $metaKeywords : siteKeywords();
$pageMetaTitle = $pageMetaTitle ?? ($pageTitle ?? $siteName);
$brandingLogoMode = strtolower((string)getSetting('branding_logo_mode', 'text'));
if (!in_array($brandingLogoMode, ['text', 'image'], true)) {
    $brandingLogoMode = 'text';
}
$brandingLogoImage = getSetting('branding_logo_image', '');
$brandingLogoText = safe_trim(getSetting('branding_logo_text', ''));
$brandingLogoTagline = safe_trim(getSetting('branding_logo_tagline', ''));
if ($brandingLogoText === '') {
    $brandingLogoText = $siteName;
}
$brandingLogoUrl = $brandingLogoImage !== '' ? assetUrl($brandingLogoImage) : '';
$brandingHasVisual = $brandingLogoMode === 'image' && $brandingLogoUrl !== '';
$brandingHasText = ($brandingLogoMode !== 'image' && ($brandingLogoText !== '' || $brandingLogoTagline !== ''));
$brandingLogoWidth = (int)getSetting('branding_logo_width', 0);
$brandingLogoHeight = (int)getSetting('branding_logo_height', 0);
$brandingLogoStyle = [];
if ($brandingLogoWidth > 0) {
    $brandingLogoStyle[] = 'width:' . $brandingLogoWidth . 'px!important';
}
if ($brandingLogoHeight > 0) {
    $brandingLogoStyle[] = 'height:' . $brandingLogoHeight . 'px!important';
}
if (!empty($brandingLogoStyle)) {
    $brandingLogoStyle[] = 'max-height:none!important';
    $brandingLogoStyle[] = 'max-width:none!important';
}
$brandingLogoStyleAttr = !empty($brandingLogoStyle) ? ' style="' . implode(';', $brandingLogoStyle) . '"' : '';
$faviconSetting = getSetting('branding_favicon_image', '');
$faviconUrl = $faviconSetting !== '' ? assetUrl($faviconSetting) : '';
$headerTopPhone = safe_trim(getSetting('header_top_phone', '+90 (555) 123 45 67'));
$headerTopEmail = safe_trim(getSetting('header_top_email', 'destek@enbmedya.com'));
$currentPath = basename(parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH) ?: '');
if ($currentPath === '') {
    $currentPath = 'index.php';
}
$assetCssVersion = file_exists(__DIR__ . '/../assets/css/main.css') ? filemtime(__DIR__ . '/../assets/css/main.css') : time();
$assetJsVersion = file_exists(__DIR__ . '/../assets/js/main.js') ? filemtime(__DIR__ . '/../assets/js/main.js') : time();
$initialTheme = isset($_COOKIE['site_theme']) && $_COOKIE['site_theme'] === 'dark' ? 'dark' : 'light';
$categoriesForHeader = [];
try {
    $categoriesForHeader = getCategories($pdo);
} catch (Throwable $th) {
    $categoriesForHeader = [];
}
$headerSearchQuery = sanitize($_GET['q'] ?? '');
$navItems = getNavigationMenu($pdo, 'header');
if (!function_exists('isPrimaryNavActive')) {
    function isPrimaryNavActive(array $item, string $currentPath): bool
    {
        $type = $item['menu_type'] ?? 'link';
        if ($type === 'marketplace') {
            $uri = $_SERVER['REQUEST_URI'] ?? '';
            return strpos($uri, '/marketplace') !== false;
        }
        if ($type === 'balance') {
            return $currentPath === 'balance.php';
        }
        $href = $item['url'] ?? '';
        $target = parse_url($href, PHP_URL_PATH);
        $target = $target ? basename($target) : '';
        return $target !== '' && $target === $currentPath;
    }
}
$categoryMediaMap = [
    'oyun-pinleri' => 'assets/images/category-oyun.svg',
    'oyunlar' => 'assets/images/category-oyun.svg',
    'oyun' => 'assets/images/category-oyun.svg',
    'pazaryeri' => 'assets/images/category-market.svg',
    'oyun-parasi' => 'assets/images/category-market.svg',
    'bakiye' => 'assets/images/category-bakiye.svg',
    'destek' => 'assets/images/category-destek.svg',
];
$marketplaceStructure = getMarketplaceStructure($pdo, true);
$cartCount = (int)($_SESSION['cart_count'] ?? 0);
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?= generateCSRFToken() ?>">
    <title><?= sanitize($pageMetaTitle) ?> - <?= sanitize($siteName) ?></title>
    <meta name="description" content="<?= sanitize($metaDescription) ?>">
    <meta name="keywords" content="<?= sanitize($metaKeywords) ?>">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="<?= htmlspecialchars(publicUrl('assets/css/main.css'), ENT_QUOTES, 'UTF-8') ?>?v=<?= $assetCssVersion ?>">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css">
    <link rel="stylesheet" href="<?= htmlspecialchars(publicUrl('assets/css/slider-rtema.css'), ENT_QUOTES, 'UTF-8') ?>?v=<?= time() ?>">
    <link rel="stylesheet" href="<?= htmlspecialchars(publicUrl('assets/css/game-cards-rtema.css'), ENT_QUOTES, 'UTF-8') ?>?v=<?= time() ?>">
    <link rel="stylesheet" href="<?= htmlspecialchars(publicUrl('assets/css/home-games.css'), ENT_QUOTES, 'UTF-8') ?>?v=<?= time() ?>">
    <link rel="stylesheet" href="<?= htmlspecialchars(publicUrl('assets/css/product-grid-rtema.css'), ENT_QUOTES, 'UTF-8') ?>?v=<?= time() ?>">
    <link rel="stylesheet" href="<?= htmlspecialchars(publicUrl('assets/css/auth-modern.css'), ENT_QUOTES, 'UTF-8') ?>?v=<?= time() ?>">
    <link rel="stylesheet" href="<?= htmlspecialchars(publicUrl('assets/css/product-detail-modern.css'), ENT_QUOTES, 'UTF-8') ?>?v=<?= time() ?>">
    <?php if ($faviconUrl !== ''): ?>
    <link rel="icon" href="<?= htmlspecialchars($faviconUrl, ENT_QUOTES, 'UTF-8') ?>">
    <?php endif; ?>
    <script>
        // CRITICAL FIX: Theme toggle and mobile nav
        document.addEventListener('DOMContentLoaded', function() {
            // Theme Toggle
            var themeButtons = document.querySelectorAll('[data-theme-toggle]');
            
            themeButtons.forEach(function(btn) {
                btn.addEventListener('click', function(e) {
                    e.preventDefault();
                    e.stopPropagation();
                    
                    var current = document.body.getAttribute('data-theme') || 'light';
                    var next = current === 'dark' ? 'light' : 'dark';
                    
                    document.body.setAttribute('data-theme', next);
                    document.body.dataset.theme = next;
                    localStorage.setItem('site-theme', next);
                    document.cookie = 'site_theme=' + next + ';path=/;max-age=31536000';
                    
                    // Update all buttons
                    themeButtons.forEach(function(b) {
                        var icon = b.querySelector('i');
                        var text = b.querySelector('span');
                        if (icon) {
                            icon.className = 'fa-solid ' + (next === 'dark' ? 'fa-sun' : 'fa-moon');
                        }
                        if (text) {
                            text.textContent = next === 'dark' ? 'Light' : 'Dark';
                        }
                    });
                    
                    // Update reCAPTCHA theme
                    if (typeof grecaptcha !== 'undefined') {
                        document.querySelectorAll('[data-recaptcha][data-widget-id]').forEach(function(container) {
                            var siteKey = container.dataset.siteKey;
                            var oldWidgetId = container.dataset.widgetId;
                            if (siteKey && oldWidgetId) {
                                try {
                                    container.innerHTML = '';
                                    var newWidgetId = grecaptcha.render(container, {
                                        sitekey: siteKey,
                                        theme: next
                                    });
                                    container.dataset.widgetId = newWidgetId;
                                } catch (e) {
                                    console.error('reCAPTCHA theme update error:', e);
                                }
                            }
                        });
                    }
                });
            });
            
            // Header yüksekliğini hesapla ve CSS variable'a set et
            function updateHeaderHeight() {
                var header = document.querySelector('.app-header');
                if (header) {
                    var height = header.offsetHeight;
                    document.documentElement.style.setProperty('--header-height', height + 'px');
                }
            }
            
            // Sayfa yüklendiğinde ve resize olduğunda güncelle
            updateHeaderHeight();
            window.addEventListener('resize', updateHeaderHeight);
            window.addEventListener('load', updateHeaderHeight);
            
            // Mobile Nav
            var navToggle = document.querySelector('[data-nav-toggle]');
            var navPanel = document.querySelector('[data-mobile-nav]');
            var navOverlay = document.querySelector('[data-nav-overlay]');
            var navClose = document.querySelector('[data-nav-close]');
            
            if (navToggle && navPanel && navOverlay) {
                // Toggle function
                function toggleNav() {
                    var isOpen = navPanel.classList.contains('open');
                    if (isOpen) {
                        closeNav();
                    } else {
                        openNav();
                    }
                }
                
                function openNav() {
                    navPanel.classList.add('open');
                    navOverlay.classList.add('active');
                    document.body.classList.add('nav-open');
                    
                    // Hamburger ikonunu X'e çevir
                    var icon = navToggle.querySelector('i');
                    if (icon) {
                        icon.classList.remove('fa-bars');
                        icon.classList.add('fa-xmark');
                    }
                    navToggle.setAttribute('aria-label', 'Menüyü kapat');
                }
                
                function closeNav() {
                    navPanel.classList.remove('open');
                    navOverlay.classList.remove('active');
                    document.body.classList.remove('nav-open');
                    
                    // X ikonunu hamburger'e çevir
                    var icon = navToggle.querySelector('i');
                    if (icon) {
                        icon.classList.remove('fa-xmark');
                        icon.classList.add('fa-bars');
                    }
                    navToggle.setAttribute('aria-label', 'Menüyü aç');
                }
                
                // Toggle button - açar/kapatır
                navToggle.addEventListener('click', function(e) {
                    e.preventDefault();
                    e.stopPropagation();
                    toggleNav();
                });
                
                // Close button
                if (navClose) {
                    navClose.addEventListener('click', function(e) {
                        e.preventDefault();
                        e.stopPropagation();
                        closeNav();
                    });
                }
                
                // Overlay click
                if (navOverlay) {
                    navOverlay.addEventListener('click', closeNav);
                }
                
                // ESC key
                document.addEventListener('keydown', function(e) {
                    if (e.key === 'Escape' && navPanel.classList.contains('open')) {
                        closeNav();
                    }
                });
                
                // Scroll ile kapanma
                var scrollTimeout;
                var lastScrollY = window.scrollY;
                
                window.addEventListener('scroll', function() {
                    if (navPanel.classList.contains('open')) {
                        var currentScrollY = window.scrollY;
                        
                        // 50px'den fazla scroll yapılırsa kapat
                        if (Math.abs(currentScrollY - lastScrollY) > 50) {
                            closeNav();
                            lastScrollY = currentScrollY;
                        }
                    } else {
                        lastScrollY = window.scrollY;
                    }
                });
            }
        });
    </script>
</head>
<body class="site-body" data-theme="<?= $initialTheme ?>">
<header class="app-header">
    <div class="app-header__top">
        <div class="container-wide app-header__top-inner">
            <div class="app-header__top-links">
                <?php if ($headerTopPhone !== ''): ?>
                <a class="pill pill--link" href="tel:<?= preg_replace('/[^\d+]/', '', $headerTopPhone) ?>"><i class="fa-solid fa-phone"></i><?= sanitize($headerTopPhone) ?></a>
                <?php endif; ?>
                <?php if ($headerTopEmail !== ''): ?>
                <a class="pill pill--link" href="mailto:<?= htmlspecialchars($headerTopEmail, ENT_QUOTES, 'UTF-8') ?>"><i class="fa-solid fa-envelope"></i><?= sanitize($headerTopEmail) ?></a>
                <?php endif; ?>
            </div>
            <div class="app-header__top-actions">
                <button class="pill pill--ghost" type="button" data-theme-toggle>
                    <i class="fa-solid <?= $initialTheme === 'dark' ? 'fa-sun' : 'fa-moon' ?>"></i>
                    <span><?= $initialTheme === 'dark' ? 'Light' : 'Dark' ?></span>
                </button>
                <div class="app-header__social">
                    <?php
                    $socialLinks = [
                        'instagram' => ['url' => getSetting('social_instagram', ''), 'icon' => 'fa-brands fa-instagram', 'label' => 'Instagram'],
                        'twitter' => ['url' => getSetting('social_twitter', ''), 'icon' => 'fa-brands fa-twitter', 'label' => 'Twitter/X'],
                        'discord' => ['url' => getSetting('social_discord', ''), 'icon' => 'fa-brands fa-discord', 'label' => 'Discord'],
                        'facebook' => ['url' => getSetting('social_facebook', ''), 'icon' => 'fa-brands fa-facebook', 'label' => 'Facebook'],
                        'youtube' => ['url' => getSetting('social_youtube', ''), 'icon' => 'fa-brands fa-youtube', 'label' => 'YouTube'],
                        'tiktok' => ['url' => getSetting('social_tiktok', ''), 'icon' => 'fa-brands fa-tiktok', 'label' => 'TikTok']
                    ];
                    foreach ($socialLinks as $key => $social):
                        if (!empty($social['url'])):
                    ?>
                    <a href="<?= htmlspecialchars($social['url'], ENT_QUOTES, 'UTF-8') ?>" target="_blank" rel="noopener" aria-label="<?= $social['label'] ?>"><i class="<?= $social['icon'] ?>"></i></a>
                    <?php
                        endif;
                    endforeach;
                    ?>
                </div>
            </div>
        </div>
    </div>
    <div class="app-header__main">
        <div class="container-wide app-header__main-inner">
            <a class="brand" href="<?= routeUrl('home') ?>">
                <span class="brand__icon<?= $brandingHasVisual ? ' brand__icon--image' : '' ?>">
                    <?php if ($brandingHasVisual): ?>
                        <img src="<?= htmlspecialchars($brandingLogoUrl, ENT_QUOTES, 'UTF-8') ?>" alt="<?= sanitize($brandingLogoText) ?>" class="brand__logo-img"<?= $brandingLogoStyleAttr ?>>
                    <?php else: ?>
                        <i class="fa-solid fa-gamepad"></i>
                    <?php endif; ?>
                </span>
                <?php if ($brandingHasText): ?>
                <div class="brand__content">
                    <?php if ($brandingLogoText !== ''): ?>
                        <strong class="brand__title"><?= sanitize($brandingLogoText) ?></strong>
                    <?php endif; ?>
                    <?php if ($brandingLogoTagline !== ''): ?>
                        <span class="brand__tagline"><?= sanitize($brandingLogoTagline) ?></span>
                    <?php endif; ?>
                </div>
                <?php endif; ?>
            </a>
            <form class="header-search" action="<?= routeUrl('search') ?>" method="get">
                <i class="fa-solid fa-magnifying-glass"></i>
                <input type="search" name="q" placeholder="Aradığınız oyun, kod veya ürünü yazın..." value="<?= $headerSearchQuery ?>">
            </form>
            <div class="header-actions">
                <a class="header-actions__link" href="<?= routeUrl('cart') ?>" data-cart-link>
                    <i class="fa-solid fa-cart-shopping"></i>
                    <span>Sepetim</span>
                    <span class="badge-pill<?= $cartCount > 0 ? '' : ' d-none' ?>" data-cart-count><?= $cartCount ?></span>
                </a>
                <?php if (isLoggedIn()): ?>
                    <?php
                        $currentUserBalance = 0;
                        try {
                            $balanceStmt = $pdo->prepare('SELECT balance FROM users WHERE id = ?');
                            $balanceStmt->execute([$_SESSION['user_id']]);
                            $balanceRow = $balanceStmt->fetch();
                            $currentUserBalance = $balanceRow ? (float)$balanceRow['balance'] : 0;
                        } catch (Throwable $th) {
                            $currentUserBalance = 0;
                        }
                    ?>
                    <a class="header-balance" id="nav-balance-display" href="<?= routeUrl('profile') ?>" style="text-decoration: none;">
                        <i class="fa-solid fa-wallet"></i><?= formatPrice($currentUserBalance) ?>
                    </a>
                    <a class="header-actions__link" href="<?= routeUrl('profile') ?>">
                        <i class="fa-solid fa-user"></i>
                        <span><?= sanitize($_SESSION['username']) ?></span>
                    </a>
                    <?php if (isAdmin()): ?>
                    <a class="header-actions__link" href="<?= seoFriendlyUrl('admin/index.php') ?>">
                            <i class="fa-solid fa-crown"></i>
                            <span>Admin</span>
                        </a>
                    <?php endif; ?>
                    <a class="header-actions__link" href="<?= routeUrl('logout') ?>">
                        <i class="fa-solid fa-right-from-bracket"></i>
                        <span>Çıkış</span>
                    </a>
                <?php else: ?>
                    <a class="header-actions__btn header-actions__btn--ghost" href="<?= routeUrl('login') ?>">
                        <i class="fa-solid fa-right-to-bracket"></i>
                        <span>Giriş Yap</span>
                    </a>
                    <a class="header-actions__btn" href="<?= routeUrl('register') ?>">
                        <i class="fa-solid fa-user-plus"></i>
                        <span>Üye Ol</span>
                    </a>
                <?php endif; ?>
                <button class="mobile-nav-toggle" type="button" aria-label="Menüyü aç" data-nav-toggle>
                    <i class="fa-solid fa-bars"></i>
                </button>
            </div>
        </div>
    </div>
    <nav class="app-nav" <?= ($recaptchaEnabledLogin || $recaptchaEnabledRegister || $recaptchaEnabledForgot) && $recaptchaSiteKey ? 'data-recaptcha-site-key="' . htmlspecialchars($recaptchaSiteKey, ENT_QUOTES, 'UTF-8') . '"' : '' ?>>
        <div class="container-wide">
            <ul class="app-nav__list">
                <?php foreach ($navItems as $item): ?>
                    <?php
                        $type = $item['menu_type'] ?? 'link';
                        $title = $item['title'] ?? '';
                        $openNewTab = !empty($item['open_new_tab']);
                        if ($type === 'balance') {
                            $href = isLoggedIn() ? routeUrl('balance') : routeUrl('login');
                        } elseif (!empty($item['url'])) {
                            $href = $item['url'];
                        } else {
                            $href = $type === 'marketplace' ? routeUrl('marketplace') : '#';
                        }
                    ?>
                        <?php if ($type === 'marketplace' && !empty($marketplaceStructure)): ?>
                        <?php $isActive = isPrimaryNavActive($item, $currentPath); ?>
                        <li class="app-nav__item app-nav__item--has-menu<?= $isActive ? ' is-active' : '' ?>" data-dropdown>
                            <button class="app-nav__link" type="button">
                                <?= sanitize($title) ?>
                                <i class="fa-solid fa-chevron-down"></i>
                            </button>
                            <div class="app-nav__menu">
                                <?php foreach ($marketplaceStructure as $marketplace): ?>
                                    <div class="app-nav__menu-group">
                                        <a class="app-nav__menu-title" href="<?= htmlspecialchars(routeUrl('marketplace_game', ['game' => $marketplace['slug']]), ENT_QUOTES, 'UTF-8') ?>">
                                            <?= sanitize($marketplace['name']) ?>
                                        </a>
                                        <?php if (!empty($marketplace['categories'])): ?>
                                            <ul>
                                                <?php foreach ($marketplace['categories'] as $category): ?>
                                                    <li><a href="<?= htmlspecialchars(routeUrl('marketplace_category', ['game' => $marketplace['slug'], 'category' => $category['slug']]), ENT_QUOTES, 'UTF-8') ?>"><?= sanitize($category['name']) ?></a></li>
                                                <?php endforeach; ?>
                                            </ul>
                                        <?php endif; ?>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </li>
                    <?php else: ?>
                        <?php $isActive = isPrimaryNavActive($item, $currentPath); ?>
                        <li class="app-nav__item<?= $isActive ? ' is-active' : '' ?>">
                            <a class="app-nav__link" href="<?= htmlspecialchars(seoFriendlyUrl($href), ENT_QUOTES, 'UTF-8') ?>"<?= $openNewTab ? ' target="_blank" rel="noopener noreferrer"' : '' ?>><?= sanitize($title) ?></a>
                        </li>
                    <?php endif; ?>
                <?php endforeach; ?>
            </ul>
        </div>
    </nav>
</header>
<div class="mobile-nav-overlay" data-nav-overlay></div>
<aside class="mobile-nav-panel" data-mobile-nav>
    <button class="mobile-nav-close" type="button" aria-label="Menüyü kapat" data-nav-close>
        <i class="fa-solid fa-xmark"></i>
    </button>
    <div class="mobile-nav-content">
        <form class="search-field mobile-search" action="<?= routeUrl('search') ?>" method="get">
            <i class="fa-solid fa-magnifying-glass"></i>
            <input type="search" name="q" placeholder="Aradığınız oyun, kod veya ürünü yazın..." value="<?= $headerSearchQuery ?>">
        </form>
        <div class="account-actions mobile-actions">
                <a class="action-link" href="<?= routeUrl('cart') ?>">
                <i class="fa-solid fa-bag-shopping"></i>Sepetim (<span data-cart-count-mobile><?= $cartCount ?></span>)
            </a>
                    <?php if (isLoggedIn()): ?>
                <a class="balance-pill" href="<?= routeUrl('profile') ?>" style="text-decoration: none;">
                    <i class="fa-solid fa-wallet me-1"></i><?= formatPrice($currentUserBalance) ?>
                </a>
                <a class="action-link" href="<?= routeUrl('profile') ?>">
                    <i class="fa-solid fa-user-gear"></i><?= sanitize($_SESSION['username']) ?>
                </a>
                <?php if (isAdmin()): ?>
                    <a class="action-link" href="<?= seoFriendlyUrl('admin/index.php') ?>">
                        <i class="fa-solid fa-crown"></i>Admin
                    </a>
                                <?php endif; ?>
                <a class="action-link" href="<?= routeUrl('logout') ?>">
                    <i class="fa-solid fa-arrow-right-from-bracket"></i>Çıkış
                </a>
                    <?php else: ?>
                <a class="action-link" href="<?= routeUrl('login') ?>">
                    <i class="fa-solid fa-user"></i>Giriş Yap
                </a>
                <a class="btn btn-register" href="<?= routeUrl('register') ?>">
                    <i class="fa-solid fa-user-plus me-1"></i>Üye Ol
                </a>
                    <?php endif; ?>
            <button class="pill pill--ghost w-100" type="button" data-theme-toggle>
                <i class="fa-solid <?= $initialTheme === 'dark' ? 'fa-sun' : 'fa-moon' ?>"></i>
                <span><?= $initialTheme === 'dark' ? 'Light' : 'Dark' ?></span>
            </button>
        </div>
        <nav class="mobile-nav-links">
            <?php foreach ($navItems as $item): ?>
                <?php
                    $type = $item['menu_type'] ?? 'link';
                    $title = $item['title'] ?? '';
                    $openNewTab = !empty($item['open_new_tab']);
                    if ($type === 'balance') {
                        $href = isLoggedIn() ? 'balance.php' : 'login.php';
                    } elseif (!empty($item['url'])) {
                        $href = $item['url'];
                    } else {
                        $href = $type === 'marketplace' ? 'marketplace.php' : '#';
                    }
                ?>
                <?php if ($type === 'marketplace' && !empty($marketplaceStructure)): ?>
                    <div class="mobile-nav-group">
                        <a class="mobile-nav-link" data-mobile-dropdown href="#">
                            <?= sanitize($title) ?><i class="fa-solid fa-chevron-down"></i>
                        </a>
                        <div class="mobile-dropdown">
                            <?php foreach ($marketplaceStructure as $marketplace): ?>
                                <a class="mobile-nav-sublink" href="<?= htmlspecialchars(routeUrl('marketplace_game', ['game' => $marketplace['slug']]), ENT_QUOTES, 'UTF-8') ?>">
                                    <?= sanitize($marketplace['name']) ?>
                                </a>
                                <?php if (!empty($marketplace['categories'])): ?>
                                    <div class="mobile-dropdown-sub">
                                        <?php foreach ($marketplace['categories'] as $category): ?>
                                            <a href="<?= htmlspecialchars(routeUrl('marketplace_category', ['game' => $marketplace['slug'], 'category' => $category['slug']]), ENT_QUOTES, 'UTF-8') ?>" class="mobile-nav-subsublink">- <?= sanitize($category['name']) ?></a>
                                        <?php endforeach; ?>
                                    </div>
                                <?php endif; ?>
                            <?php endforeach; ?>
                        </div>
                    </div>
                <?php else: ?>
                    <?php $isActive = isPrimaryNavActive($item, $currentPath); ?>
                    <a class="mobile-nav-link<?= $isActive ? ' active' : '' ?>" href="<?= htmlspecialchars(seoFriendlyUrl($href), ENT_QUOTES, 'UTF-8') ?>"<?= $openNewTab ? ' target="_blank" rel="noopener noreferrer"' : '' ?>>
                        <?= sanitize($title) ?>
                    </a>
                <?php endif; ?>
            <?php endforeach; ?>
    </nav>
    </div>
</aside>
    <?php 
$flashMessage = getFlashMessage();
if (!$flashMessage && isset($_GET['gateway']) && strtolower((string)$_GET['gateway']) === 'paytr' && isset($_GET['payment'])) {
    $status = strtolower((string)$_GET['payment']);
    if ($status === 'success') {
        $flashMessage = [
            'type' => 'success',
            'message' => 'Ödemeniz başarıyla tamamlandı.'
        ];
    } elseif ($status === 'failed') {
        $flashMessage = [
            'type' => 'danger',
            'message' => 'Ödeme işlemi iptal edildi veya başarısız oldu.'
        ];
    }
}
    if ($flashMessage): 
    ?>
<div class="flash-wrapper">
    <div class="container-wide">
        <div class="alert alert-<?= sanitize($flashMessage['type']) ?> alert-dismissible fade show" role="alert">
            <i class="fa-solid fa-<?= $flashMessage['type'] === 'success' ? 'circle-check' : 'circle-exclamation' ?> me-2"></i>
            <?= sanitize($flashMessage['message']) ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Kapat"></button>
        </div>
        </div>
    </div>
    <?php endif; ?>
    <main>
