<?php
require_once 'config.php';

if (isLoggedIn()) {
    redirect('index.php');
}

$error = '';
$recaptchaEnabledLogin = recaptchaEnabled('login');
$recaptchaSiteKey = getSetting('recaptcha_site_key', RECAPTCHA_SITE_KEY);
$requireVerification = emailVerificationRequired();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!isset($_POST['csrf_token']) || !verifyCSRFToken($_POST['csrf_token'])) {
        $error = 'Güvenlik hatası. Lütfen tekrar deneyin.';
    } else {
        if ($recaptchaEnabledLogin && $recaptchaSiteKey) {
            $token = safe_trim($_POST['g-recaptcha-response'] ?? '');
            if (!verifyRecaptcha($token)) {
                $error = 'Doğrulama başarısız. Lütfen robot olmadığınızı kanıtlayın.';
            }
        }
        if ($error === '') {
            $username = safe_trim($_POST['username'] ?? '');
            $password = $_POST['password'] ?? '';

            if ($username === '' || $password === '') {
                $error = 'Kullanıcı adı ve şifre gereklidir.';
            } else {
                $stmt = $pdo->prepare("SELECT * FROM users WHERE username = ? OR email = ?");
                $stmt->execute([$username, $username]);
                $user = $stmt->fetch();

                if ($user && password_verify($password, $user['password'])) {
                    if ((int)$user['is_active'] === 0) {
                        $error = 'Hesabınız aktif değil. Lütfen yönetici ile iletişime geçin.';
                        logUserActivity($pdo, 'auth_login_blocked', ['username' => $username, 'user_id' => $user['id']]);
                    } elseif ($requireVerification && (int)$user['email_verified'] !== 1) {
                        $error = 'Hesabınız henüz e-posta doğrulaması tamamlanmadı.';
                        $resendInfo = '';
                        if (!empty($user['email'])) {
                            $verification = prepareEmailVerification($pdo, (int)$user['id']);
                            if ($verification && isset($verification['token'], $verification['user'])) {
                                $verificationUrl = getEmailVerificationUrl($verification['token']);
                                if (sendEmailVerificationEmail($verification['user'], $verificationUrl)) {
                                    $resendInfo = ' Yeni doğrulama bağlantısı e-posta adresinize gönderildi.';
                                    logUserActivity($pdo, 'auth_login_verification_resent', ['username' => $username, 'user_id' => $user['id']]);
                                }
                            }
                        }
                        $error .= $resendInfo;
                        logUserActivity($pdo, 'auth_login_blocked_verification', ['username' => $username, 'user_id' => $user['id']]);
                    } else {
                        $_SESSION['user_id'] = $user['id'];
                        $_SESSION['username'] = $user['username'];
                        $_SESSION['email'] = $user['email'];
                        $_SESSION['is_admin'] = $user['is_admin'];
                        $_SESSION['balance'] = $user['balance'];
                        refreshCartCount($pdo, $user['id']);

                        logUserActivity($pdo, 'auth_login_success', ['username' => $username, 'user_id' => $user['id']]);

                        flashMessage('success', 'Hoş geldiniz, ' . sanitize($user['username']) . '!');

                        if ((int)$user['is_admin'] === 1) {
                            redirect('admin/index.php');
                        }

                        redirect('index.php');
                    }
                } else {
                    $error = 'Kullanıcı adı veya şifre hatalı.';
                    logUserActivity($pdo, 'auth_login_failed', ['username' => $username]);
                }
            }
        }
    }
}

$pageTitle = 'Giriş Yap';
include 'includes/header.php';
?>

<section class="auth-section">
    <div class="container-wide">
        <div class="auth-layout">
            <div class="auth-highlight card-glass">
                <div class="auth-branding">
                    <i class="fa-solid fa-gamepad auth-icon"></i>
                    <h1 class="auth-brand-title"><?= sanitize(siteName()) ?></h1>
                </div>
                <h2 class="auth-highlight-title">Hoş Geldiniz!</h2>
                <p class="auth-highlight-desc">
                    Dijital oyun kodları, marketplace ve daha fazlasına erişim için hesabınıza giriş yapın.
                </p>
                <ul class="auth-benefits">
                    <li><i class="fa-solid fa-bolt"></i>Anında teslimat kodlarına erişim</li>
                    <li><i class="fa-solid fa-shopping-cart"></i>Pazaryeri sipariş takibi</li>
                    <li><i class="fa-solid fa-wallet"></i>Bakiye yönetimi ve kampanyalar</li>
                    <li><i class="fa-solid fa-headset"></i>7/24 canlı destek hizmeti</li>
                </ul>
                <div class="auth-cta">
                    <p class="auth-cta-text">Henüz hesabınız yok mu?</p>
                    <a href="<?= routeUrl('register') ?>" class="btn btn-outline-primary btn-lg">
                        <i class="fa-solid fa-user-plus me-2"></i>Hemen Kayıt Olun
                    </a>
                </div>
            </div>
            <div class="auth-card card-glass">
                <h3>Giriş Yap</h3>
                <?php if ($error !== ''): ?>
                <div class="alert alert-danger">
                    <i class="fa-solid fa-circle-exclamation me-2"></i><?= sanitize($error) ?>
                </div>
                <?php endif; ?>
                <form method="post" class="auth-form"<?= $recaptchaEnabledLogin && $recaptchaSiteKey ? ' data-recaptcha-form' : '' ?> autocomplete="off">
                    <input type="hidden" name="csrf_token" value="<?= generateCSRFToken() ?>">
                    <div class="mb-3">
                        <label for="username" class="form-label">Kullanıcı adı veya e-posta</label>
                        <input type="text" id="username" name="username" class="form-control" value="<?= sanitize($_POST['username'] ?? '') ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="password" class="form-label">Şifre</label>
                        <input type="password" id="password" name="password" class="form-control" required>
                    </div>
                    <div class="d-flex justify-content-end align-items-center mb-3">
                        <a href="<?= routeUrl('forgot_password') ?>">Şifremi unuttum</a>
                    </div>
                    <?php if ($recaptchaEnabledLogin && $recaptchaSiteKey): ?>
                        <div class="mb-3" data-recaptcha data-site-key="<?= sanitize($recaptchaSiteKey) ?>"></div>
                    <?php endif; ?>
                    <button type="submit" class="btn btn-primary w-100">
                        <i class="fa-solid fa-right-to-bracket me-2"></i>Giriş Yap
                    </button>
                </form>
                <p class="text-center mt-4 mb-0 auth-footer-text">Hesabınız yok mu? <a href="<?= routeUrl('register') ?>">Hemen kayıt olun</a></p>
            </div>
        </div>
    </div>
</section>

<?php include 'includes/footer.php'; ?>
