<?php
require_once 'config.php';

$structure = getMarketplaceStructure($pdo, true);

$pageTitle = 'Market - Oyunlar';
include 'includes/header.php';
?>

<section class="category-showcase section-padding">
    <div class="container-wide">
        <div class="section-heading">
            <h2><i class="fa-solid fa-gamepad"></i> Market - Tüm Oyunlar</h2>
            <p style="color: var(--text-secondary); font-size: 15px; margin: 0;">Marketplace'te işlem yapabileceğiniz tüm oyunları keşfedin</p>
        </div>

        <?php if (empty($structure)): ?>
            <div class="text-center text-white-50">
                <i class="fa-solid fa-gamepad" style="font-size: 64px; opacity: 0.3; margin-bottom: 20px;"></i>
                <h3>Henüz oyun eklenmemiş</h3>
                <p>Market henüz yapılandırılmadı.</p>
            </div>
        <?php else: ?>
            <div class="carousel-wrapper">
                <div class="popular-categories-carousel">
                    <?php foreach ($structure as $game): 
                        $gameImageRaw = $game['image'] ?? null;
                        // Ensure image is a string, not an array
                        if (is_array($gameImageRaw)) {
                            $gameImageRaw = null;
                        }
                        $gameImage = !empty($gameImageRaw) ? assetUrl($gameImageRaw) : null;
                        $gameIcon = $game['icon'] ?? 'fa-gamepad';
                    ?>
                        <a href="<?= htmlspecialchars(routeUrl('marketplace_game', ['game' => $game['slug']]), ENT_QUOTES, 'UTF-8') ?>" 
                           class="popular-category-card">
                            <div class="popular-category-card__image-wrapper">
                                <?php if ($gameImage): ?>
                                    <img src="<?= htmlspecialchars($gameImage, ENT_QUOTES, 'UTF-8') ?>" 
                                         alt="<?= sanitize($game['name']) ?>" 
                                         class="popular-category-card__image">
                                <?php else: ?>
                                    <div class="popular-category-card__icon">
                                        <i class="fa-solid <?= sanitize($gameIcon) ?>"></i>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="popular-category-card__name"><?= sanitize($game['name']) ?></div>
                        </a>
                    <?php endforeach; ?>
                </div>
            </div>
        <?php endif; ?>
    </div>
</section>

<?php include 'includes/footer.php'; ?>

