<?php
require_once '../../config.php';
requireAdmin();

header('Content-Type: application/json');

$sinceParam = $_GET['since'] ?? null;
$since = $sinceParam ? date('Y-m-d H:i:s', strtotime($sinceParam)) : date('Y-m-d H:i:s', strtotime('-30 seconds'));

$stmt = $pdo->prepare("SELECT COUNT(*) FROM game_marketplace_orders WHERE order_type = 'sell' AND status = 'pending' AND created_at > ?");
$stmt->execute([$since]);
$count = (int)$stmt->fetchColumn();

echo json_encode([
    'success' => true,
    'count' => $count,
    'timestamp' => date('c')
]);
