<?php
require_once '../../config.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    echo json_encode(['success' => false, 'count' => 0, 'timestamp' => date('c')]);
    exit;
}

$sinceParam = $_GET['since'] ?? null;
$since = $sinceParam ? date('Y-m-d H:i:s', strtotime($sinceParam)) : date('Y-m-d H:i:s', strtotime('-30 seconds'));

$stmt = $pdo->prepare("SELECT COUNT(*) FROM game_marketplace_orders WHERE user_id = ? AND status IN ('approved','completed') AND updated_at > ?");
$stmt->execute([$_SESSION['user_id'], $since]);
$count = (int)$stmt->fetchColumn();

echo json_encode([
    'success' => true,
    'count' => $count,
    'timestamp' => date('c')
]);
