<?php
require_once 'config.php';

$slug = trim($_GET['slug'] ?? '');
if ($slug === '') {
    http_response_code(404);
    $pageTitle = 'Sayfa Bulunamadı';
    include 'includes/header.php';
    ?>
    <section class="section-padding text-center">
        <div class="container-narrow">
            <div class="empty-state">
                <i class="fa-solid fa-triangle-exclamation"></i>
                <h2>Sayfa bulunamadı</h2>
                <p>Görmek istediğiniz sayfaya şu anda ulaşılamıyor. Ana sayfaya dönerek devam edebilirsiniz.</p>
                <a class="btn btn-primary mt-3" href="<?= routeUrl('home') ?>"><i class="fa-solid fa-home me-2"></i>Ana Sayfa</a>
            </div>
        </div>
    </section>
    <?php
    include 'includes/footer.php';
    exit;
}

$stmt = $pdo->prepare('SELECT p.*, u.username AS author_username FROM pages p LEFT JOIN users u ON p.created_by = u.id WHERE p.slug = ? AND p.is_published = 1 LIMIT 1');
$stmt->execute([$slug]);
$pageData = $stmt->fetch();

if (!$pageData) {
    http_response_code(404);
    $pageTitle = 'Sayfa Bulunamadı';
    include 'includes/header.php';
    ?>
    <section class="section-padding text-center">
        <div class="container-narrow">
            <div class="empty-state">
                <i class="fa-solid fa-triangle-exclamation"></i>
                <h2>Sayfa bulunamadı</h2>
                <p>Aradığınız sayfa yayında değil veya kaldırılmış olabilir.</p>
                <a class="btn btn-primary mt-3" href="<?= routeUrl('home') ?>"><i class="fa-solid fa-home me-2"></i>Ana Sayfa</a>
            </div>
        </div>
    </section>
    <?php
    include 'includes/footer.php';
    exit;
}

$pageTitle = $pageData['title'];
$pageMetaTitle = $pageData['meta_title'] ?: $pageData['title'];
$metaDescription = $pageData['meta_description'] ?: siteDescription();
$metaKeywords = $pageData['meta_keywords'] ?: siteKeywords();
$heroImage = $pageData['image_path'] ? assetUrl($pageData['image_path']) : null;
$publishedAt = $pageData['published_at'] ?? $pageData['created_at'];
$updatedAt = $pageData['updated_at'] ?? null;

include 'includes/header.php';
?>

<section class="category-hero<?= $heroImage ? ' category-hero--has-image' : '' ?>" <?= $heroImage ? 'style="--category-hero-image: url(' . htmlspecialchars($heroImage, ENT_QUOTES, 'UTF-8') . ')"' : '' ?>>
    <div class="category-hero__overlay"></div>
    <div class="container-wide category-hero__inner">
        <div class="category-hero__body">
            <span class="category-hero__eyebrow"><i class="fa-solid fa-info-circle"></i>Bilgilendirme</span>
            <h1><?= sanitize($pageData['title']) ?></h1>
            <?php if (!empty($pageData['summary'])): ?>
                <p><?= sanitize($pageData['summary']) ?></p>
            <?php endif; ?>
            <div class="category-hero__tags">
                <span class="category-hero__tag"><i class="fa-solid fa-calendar"></i><?= date('d.m.Y', strtotime($publishedAt)) ?></span>
                <?php if ($updatedAt && strtotime($updatedAt) > strtotime($publishedAt)): ?>
                    <span class="category-hero__tag"><i class="fa-solid fa-pen"></i>Güncelleme: <?= date('d.m.Y', strtotime($updatedAt)) ?></span>
                <?php endif; ?>
                <?php if (!empty($pageData['author_username'])): ?>
                    <span class="category-hero__tag"><i class="fa-solid fa-user"></i><?= sanitize($pageData['author_username']) ?></span>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>

<section class="section-padding section-bg-dark">
    <div class="container-narrow page-layout">
        <div class="page-layout__content">
            <article class="rich-content">
                <?= $pageData['content'] ?>
            </article>
        </div>
    </div>
</section>

<?php include 'includes/footer.php'; ?>

