<?php
require_once __DIR__ . '/shopier_helper.php';

class Shopier
{
    private array $settings;

    public function __construct()
    {
        $this->settings = getShopierSettings();
    }

    public function isConfigured(): bool
    {
        return !empty($this->settings['api_key']) && !empty($this->settings['api_secret']);
    }

    public function createPaymentForm(array $orderData): array
    {
        return createShopierPaymentForm($orderData);
    }

    public function verifySignature(array $postData): bool
    {
        $signature = $postData['signature'] ?? '';
        return verifyShopierSignature($postData, $signature);
    }

    public function processPayment(array $postData): array
    {
        return processShopierPayment($postData);
    }
}
