<?php
require_once '../config.php';
requireAdmin();

header('Content-Type: text/html; charset=UTF-8');
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>URL Kontrolü</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { padding: 20px; background: #f8f9fa; }
        .card { margin-bottom: 20px; }
        .url-box { background: #f4f4f4; padding: 10px; border-radius: 5px; font-family: monospace; }
        .status-ok { color: #28a745; }
        .status-error { color: #dc3545; }
    </style>
</head>
<body>
    <div class="container">
        <div class="card">
            <div class="card-header bg-primary text-white">
                <h4 class="mb-0">🔍 PayTR URL Kontrolü</h4>
            </div>
            <div class="card-body">
                <?php
                $siteBaseUrl = getSetting('site_base_url', SITE_URL);
                $paytrOkUrl = getSetting('paytr_ok_url', '');
                $paytrFailUrl = getSetting('paytr_fail_url', '');
                $paytrCallbackUrl = getSetting('paytr_callback_url', '');
                ?>
                
                <h5>📌 Site Ayarları</h5>
                <table class="table table-bordered">
                    <tr>
                        <td><strong>SITE_URL (config.php):</strong></td>
                        <td class="url-box"><?= htmlspecialchars(SITE_URL) ?></td>
                    </tr>
                    <tr>
                        <td><strong>Site Temel URL (Admin Panel):</strong></td>
                        <td class="url-box"><?= htmlspecialchars($siteBaseUrl) ?></td>
                        <td>
                            <?php if (strpos($siteBaseUrl, '/epin') !== false): ?>
                                <span class="status-ok">✓ "/epin" içeriyor</span>
                            <?php else: ?>
                                <span class="status-error">✗ "/epin" içermiyor!</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                </table>

                <h5 class="mt-4">📌 PayTR URL Ayarları (Veritabanı)</h5>
                <table class="table table-bordered">
                    <tr>
                        <td><strong>PayTR OK URL:</strong></td>
                        <td class="url-box">
                            <?php if (empty($paytrOkUrl)): ?>
                                <span class="status-error">⚠️ BOŞ (Fallback kullanılacak)</span>
                            <?php else: ?>
                                <?= htmlspecialchars($paytrOkUrl) ?>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <tr>
                        <td><strong>PayTR Fail URL:</strong></td>
                        <td class="url-box">
                            <?php if (empty($paytrFailUrl)): ?>
                                <span class="status-error">⚠️ BOŞ (Fallback kullanılacak)</span>
                            <?php else: ?>
                                <?= htmlspecialchars($paytrFailUrl) ?>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <tr>
                        <td><strong>PayTR Callback URL:</strong></td>
                        <td class="url-box">
                            <?php if (empty($paytrCallbackUrl)): ?>
                                <span class="status-error">⚠️ BOŞ (Fallback kullanılacak)</span>
                            <?php else: ?>
                                <?= htmlspecialchars($paytrCallbackUrl) ?>
                            <?php endif; ?>
                        </td>
                    </tr>
                </table>

                <h5 class="mt-4">🔧 Kullanılacak URL'ler (Fallback ile)</h5>
                <?php
                require_once 'PayTR.php';
                $paytr = new PayTR();
                
                // PayTR.php constructor'da kullanılan URL'leri simüle et
                $finalOkUrl = !empty($paytrOkUrl) ? $paytrOkUrl : $siteBaseUrl . '/balance.php?payment=success';
                $finalFailUrl = !empty($paytrFailUrl) ? $paytrFailUrl : $siteBaseUrl . '/balance.php?payment=failed';
                $finalCallbackUrl = !empty($paytrCallbackUrl) ? $paytrCallbackUrl : $siteBaseUrl . '/payment/paytr-callback.php';
                ?>
                <table class="table table-bordered">
                    <tr>
                        <td><strong>Final OK URL:</strong></td>
                        <td class="url-box"><?= htmlspecialchars($finalOkUrl) ?></td>
                    </tr>
                    <tr>
                        <td><strong>Final Fail URL:</strong></td>
                        <td class="url-box"><?= htmlspecialchars($finalFailUrl) ?></td>
                    </tr>
                    <tr>
                        <td><strong>Final Callback URL:</strong></td>
                        <td class="url-box"><?= htmlspecialchars($finalCallbackUrl) ?></td>
                    </tr>
                </table>

                <div class="alert alert-info mt-4">
                    <h5>💡 Çözüm:</h5>
                    <ol>
                        <li>Admin Panel > <strong>Site Ayarları</strong> > <strong>Site Temel URL</strong>'i şu şekilde güncelleyin:<br>
                            <code class="url-box mt-2 d-inline-block">https://enbmedya.com/epin</code>
                        </li>
                        <li>Admin Panel > <strong>Ödeme Ayarları</strong> > PayTR URL'lerini boş bırakın (otomatik oluşturulacak)<br>
                            VEYA manuel olarak şu şekilde girin:
                            <ul>
                                <li>Başarılı Dönüş URL: <code>https://enbmedya.com/epin/balance.php?payment=success</code></li>
                                <li>Başarısız Dönüş URL: <code>https://enbmedya.com/epin/balance.php?payment=failed</code></li>
                                <li>Callback URL: <code>https://enbmedya.com/epin/payment/paytr-callback.php</code></li>
                            </ul>
                        </li>
                        <li>Ayarları kaydettikten sonra yeni bir ödeme deneyin.</li>
                    </ol>
                </div>

                <div class="text-center mt-4">
                    <a href="../admin/settings-site.php" class="btn btn-primary">Site Ayarlarına Git</a>
                    <a href="../admin/settings-payments.php" class="btn btn-success">Ödeme Ayarlarına Git</a>
                </div>
            </div>
        </div>
    </div>
</body>
</html>

