<?php
require_once '../config.php';
requireLogin();

header('Content-Type: application/json; charset=UTF-8');

try {
    // Havale/EFT özelliği aktif mi kontrol et
    $bankTransferEnabled = getBoolSetting('bank_transfer_enabled', false);
    
    if (!$bankTransferEnabled) {
        throw new Exception('Havale/EFT ödeme yöntemi şu anda aktif değil.');
    }

    // Banka bilgilerini al
    $bankName = getSetting('bank_transfer_bank_name', '');
    $accountHolder = getSetting('bank_transfer_account_holder', '');
    $iban = getSetting('bank_transfer_iban', '');
    $commissionRate = (float)getCommissionRate('bank_transfer');

    // Validasyon
    if (empty($accountHolder) || empty($iban)) {
        throw new Exception('Banka hesap bilgileri eksik. Lütfen yönetici ile iletişime geçin.');
    }

    // Başarılı yanıt
    echo json_encode([
        'success' => true,
        'data' => [
            'bank_name' => $bankName,
            'account_holder' => $accountHolder,
            'iban' => $iban
        ],
        'commission_rate' => $commissionRate
    ]);

} catch (Throwable $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}

