<?php
require_once __DIR__ . '/../config.php';
require_once 'PayTR.php';

$logFile = __DIR__ . '/../logs/paytr_' . date('Y-m-d') . '.log';
@file_put_contents($logFile, date('Y-m-d H:i:s') . ' - CALLBACK: ' . json_encode($_POST) . "\n", FILE_APPEND);

$post = $_POST;

if (empty($post)) {
    http_response_code(400);
    echo 'EMPTY';
    exit;
}

$paytr = new PayTR();
$verification = $paytr->verifyCallback($post);

if (!$verification['success']) {
    http_response_code(401);
    echo 'INVALID';
    exit;
}

$orderNumber = $verification['merchant_oid'];

$stmt = $pdo->prepare('SELECT * FROM orders WHERE order_number = ? LIMIT 1');
$stmt->execute([$orderNumber]);
$order = $stmt->fetch();

if (!$order) {
    http_response_code(404);
    echo 'ORDER_NOT_FOUND';
    exit;
}

if ($order['status'] === 'completed') {
    http_response_code(200);
    echo 'OK';
    exit;
}

$status = $verification['status'] ?? '';

if ($status !== 'success') {
    try {
        $pdo->beginTransaction();

        $updOrder = $pdo->prepare('UPDATE orders SET status = ? WHERE id = ?');
        $updOrder->execute(['cancelled', $order['id']]);

        $delTxn = $pdo->prepare('DELETE FROM transactions WHERE order_id = ?');
        $delTxn->execute([$order['id']]);

        $pdo->commit();
    } catch (Throwable $th) {
        $pdo->rollBack();
    }

    http_response_code(200);
    echo 'OK';
    exit;
}

try {
    $pdo->beginTransaction();

    $updOrder = $pdo->prepare('UPDATE orders SET status = ?, payment_method = ? WHERE id = ?');
    $updOrder->execute(['completed', 'paytr', $order['id']]);

    $updBalance = $pdo->prepare('UPDATE users SET balance = balance + ? WHERE id = ?');
    $updBalance->execute([(float)$order['total_amount'], $order['user_id']]);

    $updTxn = $pdo->prepare("UPDATE transactions SET description = CONCAT(description, ' - PayTR Onaylandı') WHERE order_id = ?");
    $updTxn->execute([$order['id']]);

    $pdo->commit();

    http_response_code(200);
    echo 'OK';
} catch (Throwable $th) {
    $pdo->rollBack();
    http_response_code(500);
    echo 'ERROR';
}
