<?php
require_once '../config.php';
requireAdmin(); // Sadece admin erişebilir

require_once 'PayTR.php';

$pageTitle = 'PayTR Debug';
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $pageTitle ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { padding: 20px; background: #f8f9fa; }
        .debug-card { background: white; border-radius: 10px; padding: 20px; margin-bottom: 20px; box-shadow: 0 2px 4px rgba(0,0,0,0.1); }
        .status-ok { color: #28a745; font-weight: bold; }
        .status-error { color: #dc3545; font-weight: bold; }
        pre { background: #f4f4f4; padding: 15px; border-radius: 5px; overflow-x: auto; }
        .badge-custom { padding: 5px 10px; border-radius: 4px; font-size: 12px; }
        .badge-ok { background: #d4edda; color: #155724; }
        .badge-error { background: #f8d7da; color: #721c24; }
    </style>
</head>
<body>
    <div class="container">
        <div class="debug-card">
            <h2>PayTR Yapılandırma Kontrolü</h2>
            <p class="text-muted">Bu sayfa PayTR entegrasyonunuzun durumunu kontrol eder.</p>
        </div>

        <?php
        $paytr = new PayTR();
        $isConfigured = $paytr->isConfigured();
        
        $merchant_id = getSetting('paytr_merchant_id', PAYTR_MERCHANT_ID);
        $merchant_key = getSetting('paytr_merchant_key', PAYTR_MERCHANT_KEY);
        $merchant_salt = getSetting('paytr_merchant_salt', PAYTR_MERCHANT_SALT);
        $test_mode = getBoolSetting('paytr_test_mode', PAYTR_TEST_MODE);
        $ok_url = getSetting('paytr_ok_url', SITE_URL . '/balance.php?payment=success');
        $fail_url = getSetting('paytr_fail_url', SITE_URL . '/balance.php?payment=failed');
        $callback_url = getSetting('paytr_callback_url', SITE_URL . '/payment/paytr-callback.php');
        ?>

        <div class="debug-card">
            <h4>Genel Durum</h4>
            <table class="table">
                <tr>
                    <td><strong>Yapılandırma:</strong></td>
                    <td>
                        <?php if ($isConfigured): ?>
                            <span class="badge-custom badge-ok">✓ Yapılandırıldı</span>
                        <?php else: ?>
                            <span class="badge-custom badge-error">✗ Eksik</span>
                        <?php endif; ?>
                    </td>
                </tr>
                <tr>
                    <td><strong>Test Modu:</strong></td>
                    <td>
                        <span class="badge-custom <?= $test_mode ? 'badge-ok' : 'badge-error' ?>">
                            <?= $test_mode ? '✓ Aktif' : '✗ Kapalı (Production)' ?>
                        </span>
                    </td>
                </tr>
            </table>
        </div>

        <div class="debug-card">
            <h4>API Bilgileri</h4>
            <table class="table">
                <tr>
                    <td><strong>Merchant ID:</strong></td>
                    <td>
                        <?php if (!empty($merchant_id)): ?>
                            <span class="status-ok">✓</span> <?= sanitize(substr($merchant_id, 0, 15)) ?>...
                        <?php else: ?>
                            <span class="status-error">✗ Tanımlanmamış</span>
                        <?php endif; ?>
                    </td>
                </tr>
                <tr>
                    <td><strong>Merchant Key:</strong></td>
                    <td>
                        <?php if (!empty($merchant_key)): ?>
                            <span class="status-ok">✓</span> <?= str_repeat('*', min(20, strlen($merchant_key))) ?>
                        <?php else: ?>
                            <span class="status-error">✗ Tanımlanmamış</span>
                        <?php endif; ?>
                    </td>
                </tr>
                <tr>
                    <td><strong>Merchant Salt:</strong></td>
                    <td>
                        <?php if (!empty($merchant_salt)): ?>
                            <span class="status-ok">✓</span> <?= str_repeat('*', min(20, strlen($merchant_salt))) ?>
                        <?php else: ?>
                            <span class="status-error">✗ Tanımlanmamış</span>
                        <?php endif; ?>
                    </td>
                </tr>
            </table>
        </div>

        <div class="debug-card">
            <h4>URL Yapılandırması</h4>
            <table class="table">
                <tr>
                    <td><strong>Success URL:</strong></td>
                    <td><code><?= sanitize($ok_url) ?></code></td>
                </tr>
                <tr>
                    <td><strong>Fail URL:</strong></td>
                    <td><code><?= sanitize($fail_url) ?></code></td>
                </tr>
                <tr>
                    <td><strong>Callback URL:</strong></td>
                    <td><code><?= sanitize($callback_url) ?></code></td>
                </tr>
            </table>
        </div>

        <div class="debug-card">
            <h4>Son Log Kayıtları</h4>
            <?php
            $logFiles = [
                'Request Log' => __DIR__ . '/../logs/paytr_' . date('Y-m-d') . '_request.log',
                'Raw Response' => __DIR__ . '/../logs/paytr_' . date('Y-m-d') . '_raw.log',
                'API Log' => __DIR__ . '/../logs/paytr_' . date('Y-m-d') . '_api.log',
            ];
            
            foreach ($logFiles as $logName => $logPath):
                if (file_exists($logPath)):
                    $content = file_get_contents($logPath);
                    $lines = explode("\n", $content);
                    $lastLines = array_slice(array_filter($lines), -5);
            ?>
                <h5><?= $logName ?></h5>
                <pre><?= htmlspecialchars(implode("\n", $lastLines)) ?></pre>
            <?php
                else:
            ?>
                <p class="text-muted"><?= $logName ?>: Henüz log kaydı yok.</p>
            <?php
                endif;
            endforeach;
            ?>
        </div>

        <div class="debug-card">
            <h4>Öneriler</h4>
            <ul>
                <?php if (!$isConfigured): ?>
                <li class="text-danger">✗ API bilgilerinizi admin panelinden girin: <a href="../admin/settings-payments.php">Ödeme Ayarları</a></li>
                <?php endif; ?>
                
                <?php if ($test_mode): ?>
                <li class="text-warning">⚠ Test modu aktif. Gerçek ödemeler alınamaz. PayTR test hesabı kullanılmalıdır.</li>
                <?php else: ?>
                <li class="text-success">✓ Production modu aktif. Gerçek ödemeler alınabilir.</li>
                <?php endif; ?>
                
                <li>Callback URL'nizin dışarıdan erişilebilir olduğundan emin olun.</li>
                <li>PayTR panelinden IP kısıtlaması varsa sunucu IP'nizi ekleyin.</li>
            </ul>
        </div>

        <div class="debug-card text-center">
            <a href="../admin/settings-payments.php" class="btn btn-primary">Ödeme Ayarlarına Dön</a>
            <a href="../balance.php" class="btn btn-secondary">Test Ödeme Yap</a>
        </div>
    </div>
</body>
</html>

