<?php
require_once '../config.php';
require_once 'PayTR.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    echo json_encode(['success' => false, 'error' => 'Oturum açmanız gerekiyor.']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);

try {
    $paytr = new PayTR();
    $baseAmount = isset($data['amount']) ? (float)$data['amount'] : 0;
    $payAmount = isset($data['pay_amount']) ? (float)$data['pay_amount'] : $baseAmount;

    if ($payAmount <= 0) {
        throw new RuntimeException('Geçersiz ödeme tutarı.');
    }

    $basket = [
        ['Bakiye Yükleme', $payAmount, 1]
    ];

    $orderData = [
        'order_id' => $data['order_number'],
        'email' => $data['email'],
        'amount' => $payAmount,
        'name' => $data['name'],
        'phone' => $data['phone'] ?? '5555555555',
        'address' => $data['address'] ?? 'Online Satış',
        'city' => $data['city'] ?? 'İstanbul',
        'zipcode' => $data['zipcode'] ?? '34000',
        'basket' => $basket
    ];
    
    $result = $paytr->createPaymentForm($orderData);
    
    $logFile = __DIR__ . '/../logs/paytr_' . date('Y-m-d') . '_api.log';

    if ($result['success']) {
        @file_put_contents($logFile, date('Y-m-d H:i:s') . " - TOKEN_SUCCESS - " . json_encode($orderData) . "\n", FILE_APPEND);
        echo json_encode([
            'success' => true,
            'token' => $result['token']
        ]);
    } else {
        $errorDetail = $result['error'] ?? 'Bilinmeyen hata';
        $errorMessage = 'PayTR Hatası: ';
        
        if (is_array($errorDetail)) {
            // Eğer hata array ise, her bir hatayı listele
            $errorMessages = [];
            foreach ($errorDetail as $key => $value) {
                if (is_string($value)) {
                    $errorMessages[] = $value;
                } else {
                    $errorMessages[] = $key . ': ' . json_encode($value, JSON_UNESCAPED_UNICODE);
                }
            }
            $errorMessage .= implode(', ', $errorMessages);
            $errorDetail = json_encode($errorDetail, JSON_UNESCAPED_UNICODE);
        } else {
            $errorMessage .= $errorDetail;
        }
        
        @file_put_contents($logFile, date('Y-m-d H:i:s') . " - TOKEN_ERROR - " . $errorDetail . ' | ' . json_encode($orderData) . "\n", FILE_APPEND);
        echo json_encode([
            'success' => false,
            'error' => $errorMessage
        ]);
    }
    
} catch (Exception $e) {
    $logFile = __DIR__ . '/../logs/paytr_' . date('Y-m-d') . '_api.log';
    @file_put_contents($logFile, date('Y-m-d H:i:s') . ' - EXCEPTION - ' . $e->getMessage() . "\n", FILE_APPEND);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
