<?php
require_once __DIR__ . '/../config.php';

$type = ($_GET['type'] ?? 'ok') === 'fail' ? 'fail' : 'ok';

$redirectParam = $_GET['redirect'] ?? '';
$target = '';
if ($redirectParam !== '') {
    $decoded = base64_decode($redirectParam, true);
    if ($decoded !== false && $decoded !== '') {
        // Decode edilen URL'i kontrol et ve düzelt
        if (filter_var($decoded, FILTER_VALIDATE_URL)) {
            $target = $decoded;
        } else {
            // URL geçersizse, admin paneldeki site_base_url'i kullanarak yeniden oluştur
            $siteBaseUrl = rtrim(getSetting('site_base_url', SITE_URL), '/');
            $decodedParts = parse_url($decoded);
            
            // Eğer sadece path varsa, siteBaseUrl ile birleştir
            if (isset($decodedParts['path'])) {
                $target = $siteBaseUrl . $decodedParts['path'];
                if (isset($decodedParts['query'])) {
                    $target .= '?' . $decodedParts['query'];
                }
            }
        }
    }
}

if (!filter_var($target, FILTER_VALIDATE_URL)) {
    // Admin paneldeki site_base_url'i kullan
    $siteBaseUrl = rtrim(getSetting('site_base_url', SITE_URL), '/');
    
    $fallback = $type === 'ok'
        ? getSetting('paytr_ok_url', $siteBaseUrl . '/balance.php?payment=success')
        : getSetting('paytr_fail_url', $siteBaseUrl . '/balance.php?payment=failed');
    
    if (filter_var($fallback, FILTER_VALIDATE_URL)) {
        $target = $fallback;
    } else {
        $base = parse_url($siteBaseUrl);
        $scheme = $base['scheme'] ?? ((!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http');
        $host = $base['host'] ?? ($_SERVER['HTTP_HOST'] ?? 'localhost');
        $port = isset($base['port']) ? ':' . $base['port'] : '';
        $path = $type === 'ok' ? '/balance.php' : '/balance.php';
        $target = $scheme . '://' . $host . $port . $path;
    }
}

// Append payment status query parameter if absent
$targetParts = parse_url($target);
parse_str($targetParts['query'] ?? '', $queryParams);
$statusParam = $type === 'ok' ? 'success' : 'failed';
if (!isset($queryParams['payment'])) {
    $queryParams['payment'] = $statusParam;
}
if (!isset($queryParams['gateway']) || strtolower((string)$queryParams['gateway']) !== 'paytr') {
    $queryParams['gateway'] = 'paytr';
}
$queryString = http_build_query($queryParams);

$rebuiltTarget = ($targetParts['scheme'] ?? 'https') . '://' .
    ($targetParts['host'] ?? ($_SERVER['HTTP_HOST'] ?? 'localhost')) .
    (isset($targetParts['port']) ? ':' . $targetParts['port'] : '') .
    ($targetParts['path'] ?? '/') .
    ($queryString !== '' ? '?' . $queryString : '') .
    (isset($targetParts['fragment']) ? '#' . $targetParts['fragment'] : '');

$targetJson = json_encode($rebuiltTarget, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
$targetEscaped = htmlspecialchars($rebuiltTarget, ENT_QUOTES, 'UTF-8');

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

if ($type === 'ok') {
    flashMessage('success', 'Ödemeniz başarıyla tamamlandı.');
} else {
    flashMessage('danger', 'Ödeme işlemi iptal edildi veya başarısız oldu.');
}

?><!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Yönlendiriliyorsunuz...</title>
    <style>
        body {
            font-family: 'Inter', 'Segoe UI', sans-serif;
            background: linear-gradient(135deg, #6366f1 0%, #8b5cf6 100%);
            color: #f9fafb;
            display: flex;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
            margin: 0;
        }
        .card {
            background: rgba(15, 23, 42, 0.75);
            border-radius: 20px;
            padding: 2.5rem;
            text-align: center;
            box-shadow: 0 24px 60px rgba(15, 23, 42, 0.45);
            max-width: 420px;
            width: 90%;
        }
        .card h1 {
            font-size: 1.5rem;
            margin-bottom: 1rem;
        }
        .card p {
            margin-bottom: 1.5rem;
            color: rgba(226, 232, 240, 0.85);
        }
        .card a {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            background: #f472b6;
            color: #0f172a;
            border-radius: 999px;
            padding: 0.65rem 1.5rem;
            font-weight: 600;
            text-decoration: none;
            transition: transform 0.2s ease, box-shadow 0.2s ease;
        }
        .card a:hover {
            transform: translateY(-2px);
            box-shadow: 0 12px 25px rgba(244, 114, 182, 0.35);
        }
    </style>
</head>
<body>
    <div class="card">
        <h1>Ödeme Sonuçlandırılıyor</h1>
        <p>Kısa bir süre içinde otomatik olarak yönlendirileceksiniz. Yönlendirme gerçekleşmezse aşağıdaki butona tıklayın.</p>
        <a href="<?= $targetEscaped ?>">Devam Et</a>
    </div>
    <script>
        (function() {
            var target = <?= $targetJson ?>;
            try {
                if (window.top && window.top !== window.self) {
                    window.top.location.href = target;
                } else {
                    window.location.href = target;
                }
            } catch (err) {
                window.location.href = target;
            }
        })();
    </script>
</body>
</html>

