<?php
require_once '../config.php';
require_once 'shopier_helper.php';

$logFile = __DIR__ . '/../logs/shopier_' . date('Y-m-d') . '.log';
@file_put_contents($logFile, date('Y-m-d H:i:s') . ' - GET: ' . json_encode($_GET) . "\n", FILE_APPEND);
@file_put_contents($logFile, date('Y-m-d H:i:s') . ' - POST: ' . json_encode($_POST) . "\n", FILE_APPEND);

// GET istekleri için - genelde backend callback'tir, kullanıcı görmemeli
// Eğer kullanıcı buraya geldiyse, balance sayfasına yönlendir
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    if (!empty($_GET['platform_order_id']) || !empty($_GET['order_id'])) {
        @file_put_contents($logFile, date('Y-m-d H:i:s') . ' - GET request received, redirecting to balance' . "\n", FILE_APPEND);
        header('Location: ../balance.php');
        exit;
    }
}

$post = $_POST;

if (empty($post)) {
    http_response_code(400);
    echo 'EMPTY';
    exit;
}

$platformOrderId = $post['platform_order_id'] ?? '';
$status = $post['status'] ?? '';
$signature = $post['signature'] ?? '';

// Detaylı loglama
@file_put_contents($logFile, date('Y-m-d H:i:s') . ' - POST DATA: ' . print_r($post, true) . "\n", FILE_APPEND);
@file_put_contents($logFile, date('Y-m-d H:i:s') . ' - STATUS TYPE: ' . gettype($status) . ' VALUE: ' . var_export($status, true) . "\n", FILE_APPEND);

if ($platformOrderId === '' || $status === '' || $signature === '') {
    @file_put_contents($logFile, date('Y-m-d H:i:s') . ' - ERROR: MISSING_FIELDS' . "\n", FILE_APPEND);
    http_response_code(400);
    echo 'MISSING_FIELDS';
    exit;
}

// Test modunda signature kontrolünü atla
$testMode = getBoolSetting('shopier_test_mode', false) || !empty($post['is_test_mode']);

if (!$testMode && !verifyShopierSignature($post, $signature)) {
    @file_put_contents($logFile, date('Y-m-d H:i:s') . ' - ERROR: INVALID_SIGNATURE' . "\n", FILE_APPEND);
    http_response_code(401);
    echo 'INVALID_SIGNATURE';
    exit;
}

if ($testMode) {
    @file_put_contents($logFile, date('Y-m-d H:i:s') . ' - TEST MODE: Signature check skipped' . "\n", FILE_APPEND);
}

$result = processShopierPayment($post);

@file_put_contents($logFile, date('Y-m-d H:i:s') . ' - RESULT: ' . json_encode($result) . "\n", FILE_APPEND);

if ($result['success']) {
    @file_put_contents($logFile, date('Y-m-d H:i:s') . ' - Payment completed successfully, redirecting user' . "\n", FILE_APPEND);
    
    // Sipariş numarasını al ve kullanıcı oturumunu başlat
    try {
        $stmt = $pdo->prepare('SELECT user_id FROM orders WHERE order_number = ? LIMIT 1');
        $stmt->execute([$platformOrderId]);
        $order = $stmt->fetch();
        
        if ($order && !empty($order['user_id'])) {
            if (empty($_SESSION['user_id'])) {
                $_SESSION['user_id'] = $order['user_id'];
            }
        }
    } catch (Exception $e) {
        @file_put_contents($logFile, date('Y-m-d H:i:s') . ' - Session Error: ' . $e->getMessage() . "\n", FILE_APPEND);
    }
    
    // Başarı mesajı ekle
    flashMessage('success', 'Ödemeniz başarıyla tamamlandı. Bakiyeniz güncellendi!');
    
    // Kullanıcıyı yönlendir
    http_response_code(200);
    ?>
    <!DOCTYPE html>
    <html lang="tr">
    <head>
        <meta charset="UTF-8">
        <meta http-equiv="refresh" content="0;url=../balance.php?payment=success">
        <title>Yönlendiriliyor...</title>
        <style>
            body {
                font-family: Arial, sans-serif;
                display: flex;
                align-items: center;
                justify-content: center;
                min-height: 100vh;
                margin: 0;
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                color: white;
            }
            .container {
                text-align: center;
                background: rgba(255, 255, 255, 0.1);
                padding: 2rem;
                border-radius: 10px;
                backdrop-filter: blur(10px);
            }
            .spinner {
                border: 4px solid rgba(255, 255, 255, 0.3);
                border-top: 4px solid white;
                border-radius: 50%;
                width: 50px;
                height: 50px;
                animation: spin 1s linear infinite;
                margin: 0 auto 1rem;
            }
            @keyframes spin {
                0% { transform: rotate(0deg); }
                100% { transform: rotate(360deg); }
            }
            .success-icon {
                font-size: 4rem;
                margin-bottom: 1rem;
            }
        </style>
    </head>
    <body>
        <div class="container">
            <div class="success-icon">✓</div>
            <div class="spinner"></div>
            <h2>Ödeme Başarılı!</h2>
            <p>Profil sayfanıza yönlendiriliyorsunuz...</p>
        </div>
        <script>
            setTimeout(function() {
                window.location.href = '../balance.php?payment=success';
            }, 500);
        </script>
    </body>
    </html>
    <?php
    exit;
}

// Başarısız ödeme
http_response_code(500);
@file_put_contents($logFile, date('Y-m-d H:i:s') . ' - Payment failed: ' . $result['message'] . "\n", FILE_APPEND);

// Hata durumunda da yönlendir
flashMessage('danger', $result['message'] ?? 'Ödeme işlemi başarısız oldu.');
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="refresh" content="2;url=../balance.php?payment=failed">
    <title>Yönlendiriliyor...</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            display: flex;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
            margin: 0;
            background: linear-gradient(135deg, #f56565 0%, #c53030 100%);
            color: white;
        }
        .container {
            text-align: center;
            background: rgba(255, 255, 255, 0.1);
            padding: 2rem;
            border-radius: 10px;
            backdrop-filter: blur(10px);
        }
        .error-icon {
            font-size: 4rem;
            margin-bottom: 1rem;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="error-icon">✗</div>
        <h2>Ödeme Başarısız</h2>
        <p>Profil sayfanıza yönlendiriliyorsunuz...</p>
    </div>
    <script>
        setTimeout(function() {
            window.location.href = '../balance.php?payment=failed';
        }, 2000);
    </script>
</body>
</html>
<?php
exit;
