<?php
require_once '../config.php';
require_once 'shopier_helper.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    echo json_encode(['success' => false, 'error' => 'Oturum açmanız gerekiyor.']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);

try {
    $nameParts = explode(' ', (string)$data['name'], 2);
    $name = $nameParts[0] ?? '';
    $surname = $nameParts[1] ?? '';

    $baseAmount = isset($data['amount']) ? (float)$data['amount'] : 0;
    $payAmount = isset($data['pay_amount']) ? (float)$data['pay_amount'] : $baseAmount;

    $form = createShopierPaymentForm([
        'order_id' => $data['order_number'],
        'product_name' => 'Bakiye Yükleme - ' . formatPrice($baseAmount),
        'product_type' => '1',
        'amount' => $payAmount,
        'currency' => 'TL',
        'buyer_name' => $name,
        'buyer_surname' => $surname,
        'buyer_email' => $data['email'],
        'buyer_phone' => $data['phone'],
        'buyer_address' => $data['address'] ?? 'Online Satış',
        'buyer_city' => $data['city'] ?? 'İstanbul',
        'buyer_country' => 'Türkiye',
        'buyer_postcode' => $data['zipcode'] ?? '34000',
        'shipping_address' => $data['address'] ?? 'Online Satış',
        'shipping_city' => $data['city'] ?? 'İstanbul',
        'shipping_country' => 'Türkiye',
        'shipping_postcode' => $data['zipcode'] ?? '34000'
    ]);

    echo json_encode([
        'success' => true,
        'url' => $form['url'],
        'fields' => $form['fields']
    ]);
} catch (Throwable $th) {
    echo json_encode([
        'success' => false,
        'error' => $th->getMessage()
    ]);
}
