<?php
require_once 'config.php';

$token = trim($_GET['token'] ?? '');
$errors = [];
$success = false;
$tokenData = $token !== '' ? findPasswordResetToken($pdo, $token) : null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!verifyCSRFToken($_POST['csrf_token'] ?? '')) {
        $errors[] = 'Güvenlik doğrulaması başarısız. Lütfen formu yeniden gönderin.';
    } else {
        $password = $_POST['password'] ?? '';
        $passwordConfirm = $_POST['password_confirm'] ?? '';
        $token = trim($_POST['token'] ?? '');
        $tokenData = $token !== '' ? findPasswordResetToken($pdo, $token) : null;

        if (!$tokenData) {
            $errors[] = 'Şifre sıfırlama bağlantısı geçersiz veya süresi dolmuş.';
        } else {
            if ($password === '' || strlen($password) < 6) {
                $errors[] = 'Şifre en az 6 karakter olmalıdır.';
            }
            if ($password !== $passwordConfirm) {
                $errors[] = 'Şifreler eşleşmiyor.';
            }

            if (empty($errors)) {
                $hashed = password_hash($password, PASSWORD_DEFAULT);
                $stmt = $pdo->prepare('UPDATE users SET password = ?, updated_at = NOW() WHERE id = ?');
                $stmt->execute([$hashed, $tokenData['user_id']]);
                markPasswordResetUsed($pdo, (int)$tokenData['id']);
                logUserActivity($pdo, 'auth_password_reset_complete', ['user_id' => $tokenData['user_id']]);
                flashMessage('success', 'Şifreniz başarıyla güncellendi. Şimdi giriş yapabilirsiniz.');
                redirect('login.php');
            }
        }
    }
}

$pageTitle = 'Şifre Sıfırla';
include 'includes/header.php';
?>

<section class="auth-section">
    <div class="container-wide">
        <div class="auth-layout">
            <div class="auth-highlight card-glass">
                <span class="badge text-bg-warning mb-3"><i class="fa-solid fa-lock me-2"></i>Şifre Güvenliği</span>
                <h2 class="text-white mb-3">Yeni şifrenizi belirleyin</h2>
                <p class="text-white-50 mb-4">
                    Hesabınızı güvende tutmak için güçlü bir şifre oluşturmanızı öneririz.
                </p>
                <a href="<?= routeUrl('login') ?>" class="btn btn-outline-light">
                    <i class="fa-solid fa-right-to-bracket me-2"></i>Giriş sayfasına dön
                </a>
            </div>
            <div class="auth-card card-glass">
                <h3 class="text-white mb-4">Yeni Şifre Belirle</h3>
                <?php if ($tokenData === null && empty($errors)): ?>
                    <div class="alert alert-danger">
                        <i class="fa-solid fa-circle-exclamation me-2"></i>Şifre sıfırlama bağlantısı geçersiz veya süresi dolmuş.
                    </div>
                    <a href="<?= routeUrl('forgot_password') ?>" class="btn btn-primary w-100"><i class="fa-solid fa-paper-plane me-2"></i>Yeni bağlantı iste</a>
                <?php else: ?>
                    <?php if (!empty($errors)): ?>
                        <div class="alert alert-danger">
                            <i class="fa-solid fa-circle-exclamation me-2"></i><?= implode('<br>', array_map('sanitize', $errors)) ?>
                        </div>
                    <?php endif; ?>
                    <form method="post" class="auth-form" autocomplete="off">
                        <input type="hidden" name="csrf_token" value="<?= generateCSRFToken() ?>">
                        <input type="hidden" name="token" value="<?= sanitize($token) ?>">
                        <div class="mb-3">
                            <label for="password" class="form-label">Yeni Şifre</label>
                            <input type="password" id="password" name="password" class="form-control" required>
                            <small class="text-muted">En az 6 karakter olmalı.</small>
                        </div>
                        <div class="mb-3">
                            <label for="password_confirm" class="form-label">Yeni Şifre (Tekrar)</label>
                            <input type="password" id="password_confirm" name="password_confirm" class="form-control" required>
                        </div>
                        <button type="submit" class="btn btn-primary w-100">
                            <i class="fa-solid fa-circle-check me-2"></i>Şifremi Güncelle
                        </button>
                    </form>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>

<?php include 'includes/footer.php'; ?>


