<?php

$requestUri = $_SERVER['REQUEST_URI'] ?? '/';
$path = parse_url($requestUri, PHP_URL_PATH) ?? '/';

$path = rtrim($path, '/');
if ($path === '') {
    $path = '/';
}

require_once __DIR__ . '/config.php';

$basePath = siteBasePath();
if ($basePath !== '' && strpos($path, $basePath) === 0) {
    $path = substr($path, strlen($basePath));
    if ($path === '' || $path === false) {
        $path = '/';
    } elseif ($path[0] !== '/') {
        $path = '/' . $path;
    }
}

if (strpos($path, '/admin') === 0) {
    require __DIR__ . $path;
    return;
}

$routes = getSeoRoutes();
$queryString = $_SERVER['QUERY_STRING'] ?? '';
$queryData = [];
if ($queryString !== '') {
    parse_str($queryString, $queryData);
}

$matched = null;
$matchedParams = [];

foreach ($routes as $name => $route) {
    $pattern = $route['pattern'] ?? '';
    if ($pattern === '') {
        continue;
    }
    $regex = preg_quote($pattern, '#');
    $regex = str_replace('\{', '{', $regex);
    $regex = str_replace('\}', '}', $regex);
    preg_match_all('/\{([a-zA-Z0-9_]+)\}/', $pattern, $paramMatches);
    $params = $paramMatches[1] ?? [];
    foreach ($params as $param) {
        $regex = str_replace('{' . $param . '}', '(?P<' . $param . '>[^/]+)', $regex);
    }
    $regex = '#^' . rtrim($regex, '/') . '$#u';

    if (preg_match($regex, $path, $matches)) {
        $matched = $route;
        $matched['name'] = $name;
        foreach ($params as $param) {
            if (isset($matches[$param])) {
                $matchedParams[$param] = urldecode($matches[$param]);
            }
        }
        break;
    }
}

if ($matched === null && substr($path, -4) === '.php') {
    $legacyTarget = ltrim($path, '/');
    $friendly = seoFriendlyUrl($legacyTarget);
    $friendlyFull = $friendly;
    if (!empty($queryData)) {
        $friendlyFull .= (strpos($friendly, '?') === false ? '?' : '&') . http_build_query($queryData);
    }
    if ($friendlyFull !== '/' . $legacyTarget) {
        header('Location: ' . $friendlyFull, true, 301);
        exit;
    }
    $legacyScript = __DIR__ . '/' . $legacyTarget;
    if (is_file($legacyScript)) {
        require $legacyScript;
        exit;
    }
}

if ($matched === null) {
    http_response_code(404);
    $fallback = __DIR__ . '/404.php';
    if (is_file($fallback)) {
        require $fallback;
    } else {
        echo '<h1>404</h1><p>Aradığınız sayfa bulunamadı.</p>';
    }
    exit;
}

$script = $matched['script'] ?? '';
if ($script === '' || !is_file(__DIR__ . '/' . $script)) {
    http_response_code(404);
    echo '<h1>404</h1><p>Aradığınız sayfa bulunamadı.</p>';
    exit;
}

foreach ($queryData as $key => $value) {
    $_GET[$key] = $value;
}

$queryMap = $matched['query_map'] ?? [];
foreach ($queryMap as $paramName => $queryKey) {
    if (is_int($paramName)) {
        $paramName = $queryKey;
    }
    if (isset($matchedParams[$paramName])) {
        $_GET[$queryKey] = $matchedParams[$paramName];
    }
}

$_REQUEST = array_merge($_REQUEST, $_GET);

$_SERVER['SCRIPT_NAME'] = '/' . ltrim($script, '/');
$_SERVER['PHP_SELF'] = $_SERVER['SCRIPT_NAME'];
$_SERVER['SCRIPT_FILENAME'] = __DIR__ . '/' . $script;

require __DIR__ . '/' . $script;


