<?php

return [
    'home' => [
        'pattern' => '/',
        'script' => 'index.php',
        'legacy' => ['path' => 'index.php']
    ],
    'login' => [
        'pattern' => '/giris',
        'script' => 'login.php',
        'legacy' => ['path' => 'login.php']
    ],
    'register' => [
        'pattern' => '/kayit',
        'script' => 'register.php',
        'legacy' => ['path' => 'register.php']
    ],
    'logout' => [
        'pattern' => '/cikis',
        'script' => 'logout.php',
        'legacy' => ['path' => 'logout.php']
    ],
    'profile' => [
        'pattern' => '/profil',
        'script' => 'profile.php',
        'legacy' => ['path' => 'profile.php']
    ],
    'support' => [
        'pattern' => '/destek',
        'script' => 'support.php',
        'legacy' => ['path' => 'support.php']
    ],
    'support_ticket' => [
        'pattern' => '/destek/talep/{id}',
        'script' => 'support.php',
        'params' => ['id'],
        'query_map' => ['id' => 'id'],
        'legacy' => ['path' => 'support.php', 'query' => ['id' => 'id']]
    ],
    'cart' => [
        'pattern' => '/sepet',
        'script' => 'cart.php',
        'legacy' => ['path' => 'cart.php']
    ],
    'balance' => [
        'pattern' => '/bakiye',
        'script' => 'balance.php',
        'legacy' => ['path' => 'balance.php']
    ],
    'products' => [
        'pattern' => '/urunler',
        'script' => 'products.php',
        'legacy' => ['path' => 'products.php']
    ],
    'search' => [
        'pattern' => '/arama',
        'script' => 'search.php',
        'legacy' => ['path' => 'search.php']
    ],
    'categories' => [
        'pattern' => '/kategoriler',
        'script' => 'categories.php',
        'legacy' => ['path' => 'categories.php']
    ],
    'products_tab' => [
        'pattern' => '/urunler/tip/{tab}',
        'script' => 'products.php',
        'params' => ['tab'],
        'query_map' => ['tab' => 'tab'],
        'legacy' => ['path' => 'products.php', 'query' => ['tab' => 'tab']]
    ],
    'product_category' => [
        'pattern' => '/kategori/{slug}',
        'script' => 'products.php',
        'params' => ['slug'],
        'query_map' => ['slug' => 'category'],
        'legacy' => ['path' => 'products.php', 'query' => ['category' => 'slug']]
    ],
    'product' => [
        'pattern' => '/urun/{slug}',
        'script' => 'product.php',
        'params' => ['slug'],
        'query_map' => ['slug' => 'slug'],
        'legacy' => ['path' => 'product.php', 'query' => ['slug' => 'slug']]
    ],
    'blog' => [
        'pattern' => '/blog',
        'script' => 'blog.php',
        'legacy' => ['path' => 'blog.php']
    ],
    'blog_post' => [
        'pattern' => '/blog/{slug}',
        'script' => 'blog-post.php',
        'params' => ['slug'],
        'query_map' => ['slug' => 'slug'],
        'legacy' => ['path' => 'blog-post.php', 'query' => ['slug' => 'slug']]
    ],
    'page' => [
        'pattern' => '/sayfa/{slug}',
        'script' => 'page.php',
        'params' => ['slug'],
        'query_map' => ['slug' => 'slug'],
        'legacy' => ['path' => 'page.php', 'query' => ['slug' => 'slug']]
    ],
    'market' => [
        'pattern' => '/market',
        'script' => 'market.php',
        'legacy' => ['path' => 'market.php']
    ],
    'marketplace' => [
        'pattern' => '/marketplace',
        'script' => 'marketplace.php',
        'legacy' => ['path' => 'marketplace.php']
    ],
    'marketplace_game' => [
        'pattern' => '/marketplace/{game}',
        'script' => 'marketplace.php',
        'params' => ['game'],
        'query_map' => ['game' => 'game'],
        'legacy' => ['path' => 'marketplace.php', 'query' => ['game' => 'game']]
    ],
    'marketplace_category' => [
        'pattern' => '/marketplace/{game}/{category}',
        'script' => 'marketplace.php',
        'params' => ['game', 'category'],
        'query_map' => ['game' => 'game', 'category' => 'category'],
        'legacy' => ['path' => 'marketplace.php', 'query' => ['game' => 'game', 'category' => 'category']]
    ],
    'verify_email' => [
        'pattern' => '/eposta-dogrulama',
        'script' => 'verify-email.php',
        'legacy' => ['path' => 'verify-email.php']
    ],
    'orders' => [
        'pattern' => '/siparisler',
        'script' => 'orders.php',
        'legacy' => ['path' => 'orders.php']
    ],
    'deposits' => [
        'pattern' => '/bakiye-yuklemeler',
        'script' => 'deposits.php',
        'legacy' => ['path' => 'deposits.php']
    ],
    'marketplace_orders' => [
        'pattern' => '/marketplace-islemlerim',
        'script' => 'marketplace-orders.php',
        'legacy' => ['path' => 'marketplace-orders.php']
    ],
    'withdrawals' => [
        'pattern' => '/bakiye-cekimler',
        'script' => 'withdrawals.php',
        'legacy' => ['path' => 'withdrawals.php']
    ],
    'forgot_password' => [
        'pattern' => '/sifremi-unuttum',
        'script' => 'forgot-password.php',
        'legacy' => ['path' => 'forgot-password.php']
    ],
    'reset_password' => [
        'pattern' => '/sifre-sifirla',
        'script' => 'reset-password.php',
        'legacy' => ['path' => 'reset-password.php']
    ],
    'marketplace_api_user' => [
        'pattern' => '/marketplace/api/kullanici',
        'script' => 'marketplace/api/poll-user.php',
        'legacy' => ['path' => 'marketplace/api/poll-user.php']
    ],
    'marketplace_api_admin' => [
        'pattern' => '/marketplace/api/admin',
        'script' => 'marketplace/api/poll-admin.php',
        'legacy' => ['path' => 'marketplace/api/poll-admin.php']
    ],
];


