<?php
require_once 'config.php';

$token = trim($_GET['token'] ?? '');
$success = false;
$alreadyVerified = false;
$message = '';

if ($token === '') {
    $message = 'Geçersiz veya eksik doğrulama anahtarı.';
} else {
    $user = findUserByVerificationToken($pdo, $token);
    if (!$user) {
        $message = 'Doğrulama bağlantısı geçersiz, süresi dolmuş veya daha önce kullanılmış.';
    } else {
        if ((int)$user['email_verified'] === 1) {
            $alreadyVerified = true;
            $message = 'E-posta adresiniz zaten doğrulandı. Giriş yaparak devam edebilirsiniz.';
        } else {
            markEmailAsVerified($pdo, (int)$user['id']);
            logUserActivity($pdo, 'auth_email_verified', ['user_id' => $user['id'], 'email' => $user['email']]);
            $success = true;
            $message = 'Tebrikler! E-posta adresiniz başarıyla doğrulandı.';
        }
    }
}

$pageTitle = 'E-posta Doğrulama';
include 'includes/header.php';
?>

<section class="section-padding">
    <div class="container-wide">
        <div class="row justify-content-center">
            <div class="col-lg-6">
                <div class="card card-glass">
                    <div class="card-body text-center py-5">
                        <?php if ($success): ?>
                            <div class="mb-3 text-success" style="font-size:3rem;"><i class="fa-solid fa-circle-check"></i></div>
                            <h2 class="text-white mb-3">Doğrulama Başarılı</h2>
                            <p class="text-white-50 mb-4"><?= sanitize($message) ?></p>
                            <a href="<?= routeUrl('login') ?>" class="btn btn-primary"><i class="fa-solid fa-right-to-bracket me-2"></i>Giriş Yap</a>
                        <?php elseif ($alreadyVerified): ?>
                            <div class="mb-3 text-info" style="font-size:3rem;"><i class="fa-solid fa-circle-info"></i></div>
                            <h2 class="text-white mb-3">Zaten Doğrulandı</h2>
                            <p class="text-white-50 mb-4"><?= sanitize($message) ?></p>
                            <a href="<?= routeUrl('login') ?>" class="btn btn-outline-light"><i class="fa-solid fa-right-to-bracket me-2"></i>Giriş Yap</a>
                        <?php else: ?>
                            <div class="mb-3 text-warning" style="font-size:3rem;"><i class="fa-solid fa-triangle-exclamation"></i></div>
                            <h2 class="text-white mb-3">Doğrulama Başarısız</h2>
                            <p class="text-white-50 mb-4"><?= sanitize($message) ?></p>
                            <a href="<?= routeUrl('support') ?>" class="btn btn-outline-light"><i class="fa-solid fa-life-ring me-2"></i>Destek Talebi Oluştur</a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php include 'includes/footer.php'; ?>

