# Domain Takip Sistemi

PHP + PDO ile geliştirilmiş, modern ve kullanıcı dostu domain takip sistemi.

## Özellikler

- **Admin Girişi**: Güvenli admin paneli erişimi
- **Domain Yönetimi**: Domain ekleme, düzenleme, silme
- **Otomatik WHOIS Sorguları**: Domain bilgilerini otomatik çekme
- **Nameserver Takibi**: DNS bilgilerini otomatik güncelleme
- **Süre Takibi**: Domain bitiş tarihlerini takip etme
- **Bildirim Sistemi**: E-posta ile otomatik uyarılar
- **Durum Bildirimleri**: Kritik, uyarı ve normal durumlar
- **Responsive Tasarım**: Mobil ve masaüstü uyumlu
- **Toplu İşlemler**: Birden fazla domain'i aynı anda güncelleme

## Kurulum

### Gereksinimler

- PHP 7.4 veya üzeri
- MySQL 5.7 veya MariaDB 10.2 veya üzeri
- Apache/Nginx web sunucusu
- PHP PDO MySQL extension
- PHP cURL extension
- PHP mail() fonksiyonu (bildirimler için)

### Kurulum Adımları

1. **Dosyaları Yükleyin**
   ```bash
   # Proje dosyalarını web sunucunuzun root dizinine kopyalayın
   cp -r domain-tracker/* /var/www/html/
   ```

2. **Veritabanını Oluşturun**
   ```bash
   # MySQL/MariaDB'ye bağlanın ve database.sql dosyasını çalıştırın
   mysql -u root -p < database.sql
   ```

3. **Konfigürasyonu Düzenleyin**
   ```php
   // config/config.php dosyasındaki veritabanı ayarlarını düzenleyin
   define('DB_HOST', 'localhost');
   define('DB_NAME', 'domain_tracker');
   define('DB_USER', 'your_username');
   define('DB_PASS', 'your_password');
   ```

4. **Dosya İzinlerini Ayarlayın**
   ```bash
   # Web sunucusunun yazma izni vermek için
   chown -R www-data:www-data /var/www/html/domain-tracker
   chmod -R 755 /var/www/html/domain-tracker
   
   # Log dizini için yazma izni
   mkdir -p /var/www/html/domain-tracker/logs
   chmod 755 /var/www/html/domain-tracker/logs
   ```

5. **Cron Job Kurulumu (Otomatik Bildirimler ve Güncelleme İçin)**
   ```bash
   # Otomatik kurulum scripti ile
   cd /var/www/html/domain-tracker/cron
   ./setup_cron.sh
   
   # Bu cron job her gün saat 09:00'da çalışarak süresi yaklaşan domainleri kontrol eder
   # ve tüm domainlerin WHOIS bilgilerini otomatik olarak günceller.
   
   # Veya manuel olarak crontab'a ekleyin:
   # 0 9 * * * /usr/bin/php /var/www/html/domain-tracker/cron/check_expiring_domains.php --update-all
   ```

## Kullanım

### İlk Giriş

- **URL**: `http://your-domain.com/domain-tracker/`
- **Kullanıcı Adı**: `admin`
- **Şifre**: `admin123`

> **Güvenlik**: İlk girişten sonra mutlaka şifrenizi değiştirin!

### Domain Ekleme

1. Dashboard'dan "Yeni Domain" butonuna tıklayın
2. Domain adını girin (örn: example.com)
3. İsteğe bağlı notlar ekleyin
4. "Domain Ekle" butonuna tıklayın
5. Sistem otomatik olarak WHOIS bilgilerini çekecektir

### Domain Yönetimi

- **Bilgileri Yenile**: Domain bilgilerini manuel olarak güncelleme
- **Düzenle**: Notlar ve otomatik yenileme ayarlarını değiştirme
- **Sil**: Domain'i sistemden kaldırma
- **Toplu Güncelleme**: Birden fazla domain'i aynı anda güncelleme

### Bildirim Sistemi

#### Bildirim Ayarları
1. Admin panelinden "Bildirim Ayarları" sayfasına gidin
2. E-posta adresinizi ve bildirim tercihlerinizi ayarlayın
3. Test bildirimi göndererek ayarları doğrulayın

#### Bildirim Türleri
- **Uyarı Bildirimi**: Domain süresi belirlenen gün sayısı içinde dolacaksa
- **Kritik Bildirimi**: Domain süresi 7 gün veya daha az kaldıysa
- **Süre Doldu Bildirimi**: Domain süresi dolmuşsa

#### Bildirim Sıklığı
- **Kritik durumda (≤7 gün)**: Günde bir bildirim
- **Uyarı durumunda (8-30 gün)**: Haftada bir bildirim

### Durum Kodları

- **🟢 Normal (>30 gün)**: Domain süresi 30 günden fazla
- **🟡 Uyarı (8-30 gün)**: Domain süresi 30 gün içinde dolacak
- **🔴 Kritik (≤7 gün)**: Domain süresi 7 gün içinde dolacak
- **⚫ Süresi Geçmiş**: Domain süresi dolmuş
- **⚪ Bilinmiyor**: Domain bilgileri alınamadı

## Teknik Detaylar

### Dosya Yapısı

```
domain-tracker/
├── config/
│   └── config.php          # Konfigürasyon dosyası
├── includes/
│   ├── header.php          # Sayfa başlığı
│   ├── sidebar.php         # Kenar menü
│   ├── domain_functions.php # Domain işlevleri
│   └── notification_functions.php # Bildirim işlevleri
├── assets/
│   ├── css/
│   │   └── admin.css       # Stil dosyası
│   └── js/
│       └── admin.js        # JavaScript dosyası
├── api/
│   └── refresh_domain.php  # AJAX API endpoint
├── cron/
│   ├── check_expiring_domains.php # Cron job scripti
│   └── setup_cron.sh       # Cron kurulum scripti
├── logs/                   # Log dosyaları
├── pages/                  # Ek sayfalar
├── index.php              # Ana sayfa
├── login.php              # Giriş sayfası
├── logout.php             # Çıkış sayfası
├── dashboard.php          # Dashboard
├── domains.php            # Domain yönetimi
├── settings.php           # Bildirim ayarları
├── database.sql           # Veritabanı şeması
└── README.md              # Bu dosya
```

### Veritabanı Tabloları

#### `admin_users`
- Admin kullanıcı bilgileri
- Şifreler bcrypt ile hashlenir

#### `domains`
- Domain bilgileri
- WHOIS verileri
- Nameserver bilgileri
- Otomatik hesaplanan süre bilgileri

#### `notification_settings`
- Bildirim ayarları
- E-posta adresleri
- Uyarı ve kritik gün sayıları

#### `notification_logs`
- Gönderilen bildirim logları
- Bildirim türleri ve durumları
- Tekrar gönderim kontrolü için

### WHOIS Sorguları

Sistem aşağıdaki TLD'ler için WHOIS sorgularını destekler:
- .com, .net, .org
- .tr, .uk, .de, .fr
- .info, .biz, .me, .co
- Ve daha fazlası...

### Güvenlik Özellikleri

- **Session Yönetimi**: Güvenli oturum kontrolü
- **SQL Injection Koruması**: PDO prepared statements
- **XSS Koruması**: HTML sanitization
- **CSRF Koruması**: Form token kontrolü
- **Şifre Hashleme**: bcrypt algoritması

### Bildirim Sistemi Detayları

#### E-posta Şablonları
- HTML formatında profesyonel e-posta şablonları
- Responsive tasarım
- Domain bilgileri ve aciliyet seviyesi gösterimi

#### Cron Job Özellikleri
- Günlük otomatik kontrol
- Rate limiting (WHOIS sorguları arası bekleme)
- Hata loglaması
- Eski log temizleme

#### Bildirim Loglaması
- Gönderilen tüm bildirimlerin kaydı
- Tekrar gönderim kontrolü
- Bildirim başarı/başarısızlık durumu

## Sorun Giderme

### Yaygın Sorunlar

1. **WHOIS Bilgileri Çekilmiyor**
   - Sunucunuzun 43 portuna erişimi olduğundan emin olun
   - Firewall ayarlarını kontrol edin

2. **Veritabanı Bağlantı Hatası**
   - config/config.php dosyasındaki bilgileri kontrol edin
   - MySQL/MariaDB servisinin çalıştığından emin olun

3. **E-posta Bildirimleri Gönderilmiyor**
   - PHP mail() fonksiyonunun çalıştığından emin olun
   - SMTP ayarlarını kontrol edin
   - Spam klasörünü kontrol edin

4. **Cron Job Çalışmıyor**
   - Cron servisinin çalıştığından emin olun
   - PHP CLI yolunun doğru olduğunu kontrol edin
   - Log dosyalarını inceleyin

5. **Dosya İzin Hataları**
   - Web sunucusunun dosyalara okuma izni olduğundan emin olun
   - Log dizinine yazma izni verin
   - SELinux ayarlarını kontrol edin

### Log Dosyaları

#### PHP Hata Logları
```bash
tail -f /var/log/apache2/error.log
# veya
tail -f /var/log/nginx/error.log
```

#### Cron Job Logları
```bash
tail -f /var/www/html/domain-tracker/logs/cron.log
```

#### Sistem Cron Logları
```bash
tail -f /var/log/cron
# veya
tail -f /var/log/syslog | grep CRON
```

### Test Komutları

#### Manuel Domain Kontrolü
```bash
php /var/www/html/domain-tracker/cron/check_expiring_domains.php
```

#### Tüm Domainleri Güncelle
```bash
php /var/www/html/domain-tracker/cron/check_expiring_domains.php --update-all
```

#### Test E-postası Gönder
Admin panelinden "Bildirim Ayarları" sayfasında test bildirimi gönderebilirsiniz.

## Katkıda Bulunma

Bu proje açık kaynak kodludur. Katkılarınızı bekliyoruz!

## Lisans

Bu proje MIT lisansı altında lisanslanmıştır.

## Destek

Herhangi bir sorun yaşarsanız:
1. README dosyasını kontrol edin
2. Log dosyalarını inceleyin
3. GitHub Issues bölümünde sorun bildirin

---

**Geliştirici**: Manus AI Assistant
**Versiyon**: 2.1.0
**Son Güncelleme**: 2025-09-11

## Değişiklik Geçmişi

### v2.1.0 (2025-09-11)
- ✅ Cron job her gün tüm domainleri otomatik güncelleyecek şekilde ayarlandı.

### v2.0.0 (2025-09-11)
- ✅ E-posta bildirim sistemi eklendi
- ✅ Cron job desteği eklendi
- ✅ Bildirim ayarları sayfası eklendi
- ✅ Bildirim loglaması eklendi
- ✅ Otomatik kurulum scripti eklendi

### v1.0.0 (2025-09-11)
- ✅ Temel domain takip sistemi
- ✅ WHOIS sorguları
- ✅ Admin paneli
- ✅ Domain CRUD işlemleri

