<?php
require_once '../config/config.php';
require_once '../includes/domain_functions.php';

// Giriş kontrolü
if (!isLoggedIn()) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Yetkisiz erişim']);
    exit;
}

// Content-Type kontrolü
if ($_SERVER['CONTENT_TYPE'] !== 'application/json') {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Geçersiz content type']);
    exit;
}

// POST verilerini al
$input = json_decode(file_get_contents('php://input'), true);
$domainId = $input['domain_id'] ?? null;

if (!$domainId || !is_numeric($domainId)) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Geçersiz domain ID']);
    exit;
}

try {
    // Domain bilgilerini güncelle
    $result = DomainInfo::updateDomainInfo($pdo, $domainId);
    
    if ($result) {
        echo json_encode(['success' => true, 'message' => 'Domain bilgileri güncellendi']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Domain bilgileri güncellenemedi']);
    }
} catch (Exception $e) {
    error_log("API refresh domain error: " . $e->getMessage());
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Sunucu hatası']);
}
?>

