// Domain Takip Sistemi - Admin Panel JavaScript

document.addEventListener('DOMContentLoaded', function() {
    // Sidebar toggle for mobile
    const sidebarToggle = document.querySelector('.navbar-toggler');
    const sidebar = document.querySelector('#sidebarMenu');
    
    if (sidebarToggle && sidebar) {
        sidebarToggle.addEventListener('click', function() {
            sidebar.classList.toggle('show');
        });
    }
    
    // Auto-hide alerts after 5 seconds
    const alerts = document.querySelectorAll('.alert:not(.alert-permanent)');
    alerts.forEach(function(alert) {
        setTimeout(function() {
            const bsAlert = new bootstrap.Alert(alert);
            bsAlert.close();
        }, 5000);
    });
    
    // Confirm delete actions
    const deleteButtons = document.querySelectorAll('[data-action="delete"]');
    deleteButtons.forEach(function(button) {
        button.addEventListener('click', function(e) {
            e.preventDefault();
            const domainName = this.getAttribute('data-domain');
            const url = this.getAttribute('href');
            
            if (confirm(`"${domainName}" domain'ini silmek istediğinizden emin misiniz?`)) {
                window.location.href = url;
            }
        });
    });
    
    // Toplu silme: sadece bir kez tanımlı, sade ve hatasız
    const bulkDeleteBtn = document.getElementById('bulkDeleteBtn');
    const domainCheckboxes = document.querySelectorAll('input[name="selected_domains[]"]');
    const selectAll = document.getElementById('selectAll');

    function updateBulkDeleteBtn() {
        const checkedCount = document.querySelectorAll('input[name="selected_domains[]"]:checked').length;
        if (bulkDeleteBtn) {
            bulkDeleteBtn.disabled = checkedCount === 0;
        }
    }

    domainCheckboxes.forEach(function(checkbox) {
        checkbox.addEventListener('change', updateBulkDeleteBtn);
    });
    if (selectAll) {
        selectAll.addEventListener('change', function() {
            const checked = this.checked;
            domainCheckboxes.forEach(function(cb) {
                cb.checked = checked;
            });
            updateBulkDeleteBtn();
        });
    }
    updateBulkDeleteBtn();

    if (bulkDeleteBtn) {
        bulkDeleteBtn.addEventListener('click', function(e) {
            const checkedCount = document.querySelectorAll('input[name="selected_domains[]"]:checked').length;
            if (checkedCount === 0) {
                e.preventDefault();
                alert('Lütfen silinecek domainleri seçin.');
                return false;
            }
            if (!confirm(`${checkedCount} domain silinecek. Devam etmek istiyor musunuz?`)) {
                e.preventDefault();
                return false;
            }
            // Form submit otomatik olacak
        });
    }
    
    // Select all checkbox
    const selectAllCheckbox = document.querySelector('#selectAll');
    if (selectAllCheckbox) {
        selectAllCheckbox.addEventListener('change', function() {
            const checkboxes = document.querySelectorAll('input[name="selected_domains[]"]');
            checkboxes.forEach(function(checkbox) {
                checkbox.checked = selectAllCheckbox.checked;
            });
            updateBulkActions();
        });
    }
    
    // Update bulk actions visibility
    function updateBulkActions() {
        const selectedDomains = document.querySelectorAll('input[name="selected_domains[]"]:checked');
        const bulkActions = document.querySelector('#bulkActions');
        
        if (bulkActions) {
            if (selectedDomains.length > 0) {
                bulkActions.style.display = 'block';
                document.querySelector('#selectedCount').textContent = selectedDomains.length;
            } else {
                bulkActions.style.display = 'none';
            }
        }
    }
    
    // Domain checkboxes change event
    const domainCheckboxes = document.querySelectorAll('input[name="selected_domains[]"]');
    domainCheckboxes.forEach(function(checkbox) {
        checkbox.addEventListener('change', updateBulkActions);
    });
    
    // Domain form validation
    const domainForm = document.querySelector('#domainForm');
    if (domainForm) {
        domainForm.addEventListener('submit', function(e) {
            const domainInput = document.querySelector('#domain_name');
            const domainValue = domainInput.value.trim();
            
            // Basic domain validation
            const domainRegex = /^[a-zA-Z0-9][a-zA-Z0-9-]{0,61}[a-zA-Z0-9]?\.[a-zA-Z]{2,}$/;
            
            if (!domainRegex.test(domainValue)) {
                e.preventDefault();
                alert('Lütfen geçerli bir domain adı girin (örn: example.com)');
                domainInput.focus();
                return false;
            }
        });
    }
    
    // Auto-refresh domain info
    const refreshButtons = document.querySelectorAll('[data-action="refresh"]');
    refreshButtons.forEach(function(button) {
        button.addEventListener('click', function(e) {
            e.preventDefault();
            const domainId = this.getAttribute('data-domain-id');
            const originalText = this.innerHTML;
            
            this.innerHTML = '<span class="loading"></span>';
            this.disabled = true;
            
            // AJAX request to refresh domain info
            fetch('api/refresh_domain.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({ domain_id: domainId })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    location.reload();
                } else {
                    alert('Domain bilgileri güncellenirken hata oluştu: ' + (data.message || 'Bilinmeyen hata'));
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('Bir hata oluştu. Lütfen tekrar deneyin.');
            })
            .finally(() => {
                this.innerHTML = originalText;
                this.disabled = false;
            });
        });
    });
    
    // Search functionality
    const searchInput = document.querySelector('#domainSearch');
    if (searchInput) {
        searchInput.addEventListener('input', function() {
            const searchTerm = this.value.toLowerCase();
            const tableRows = document.querySelectorAll('#domainsTable tbody tr');
            
            tableRows.forEach(function(row) {
                const domainName = row.querySelector('td:first-child').textContent.toLowerCase();
                if (domainName.includes(searchTerm)) {
                    row.style.display = '';
                } else {
                    row.style.display = 'none';
                }
            });
        });
    }
    
    // Status filter
    const statusFilter = document.querySelector('#statusFilter');
    if (statusFilter) {
        statusFilter.addEventListener('change', function() {
            const selectedStatus = this.value;
            const tableRows = document.querySelectorAll('#domainsTable tbody tr');
            
            tableRows.forEach(function(row) {
                if (selectedStatus === '' || row.getAttribute('data-status') === selectedStatus) {
                    row.style.display = '';
                } else {
                    row.style.display = 'none';
                }
            });
        });
    }
    
    // Tooltip initialization
    const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    tooltipTriggerList.map(function(tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl);
    });
    
    // Copy to clipboard functionality
    const copyButtons = document.querySelectorAll('[data-action="copy"]');
    copyButtons.forEach(function(button) {
        button.addEventListener('click', function() {
            const textToCopy = this.getAttribute('data-copy-text');
            
            if (navigator.clipboard) {
                navigator.clipboard.writeText(textToCopy).then(function() {
                    showToast('Panoya kopyalandı!', 'success');
                });
            } else {
                // Fallback for older browsers
                const textArea = document.createElement('textarea');
                textArea.value = textToCopy;
                document.body.appendChild(textArea);
                textArea.select();
                document.execCommand('copy');
                document.body.removeChild(textArea);
                showToast('Panoya kopyalandı!', 'success');
            }
        });
    });
    
    // Toplu silme butonunu aktif et
    // Değişkenler yukarıda tanımlandı, tekrar tanımlamaya gerek yok

    function updateBulkDeleteBtn() {
        const checkedCount = document.querySelectorAll('input[name="selected_domains[]"]:checked').length;
        if (bulkDeleteBtn) {
            bulkDeleteBtn.disabled = checkedCount === 0;
        }
    }

    domainCheckboxes.forEach(function(checkbox) {
        checkbox.addEventListener('change', updateBulkDeleteBtn);
    });
    if (selectAll) {
        selectAll.addEventListener('change', function() {
            const checked = this.checked;
            domainCheckboxes.forEach(function(cb) {
                cb.checked = checked;
            });
            updateBulkDeleteBtn();
        });
    }
    updateBulkDeleteBtn();
});

// Toast notification function
function showToast(message, type = 'info') {
    const toastContainer = document.querySelector('#toastContainer') || createToastContainer();
    
    const toast = document.createElement('div');
    toast.className = `toast align-items-center text-white bg-${type} border-0`;
    toast.setAttribute('role', 'alert');
    toast.innerHTML = `
        <div class="d-flex">
            <div class="toast-body">${message}</div>
            <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"></button>
        </div>
    `;
    
    toastContainer.appendChild(toast);
    
    const bsToast = new bootstrap.Toast(toast);
    bsToast.show();
    
    // Remove toast element after it's hidden
    toast.addEventListener('hidden.bs.toast', function() {
        toast.remove();
    });
}

// Create toast container if it doesn't exist
function createToastContainer() {
    const container = document.createElement('div');
    container.id = 'toastContainer';
    container.className = 'toast-container position-fixed bottom-0 end-0 p-3';
    document.body.appendChild(container);
    return container;
}

// Format date function
function formatDate(dateString) {
    if (!dateString) return '-';
    const date = new Date(dateString);
    return date.toLocaleDateString('tr-TR');
}

// Calculate days until expiry
function getDaysUntilExpiry(expirationDate) {
    if (!expirationDate) return null;
    const now = new Date();
    const expiry = new Date(expirationDate);
    const diffTime = expiry - now;
    const diffDays = Math.ceil(diffTime / (1000 * 60 * 60 * 24));
    return diffDays;
}

