<?php
/**
 * Domain Takip Sistemi - Konfigürasyon Dosyası
 */

// Hata raporlama
error_reporting(E_ALL);
ini_set("display_errors", 1);

// Oturum ayarları
if (session_status() == PHP_SESSION_NONE) {
    session_set_cookie_params([
        'lifetime' => 3600, // 1 saat
        'path' => '/',
    'secure' => true, // HTTPS kullanıyorsanız true olmalı
        'httponly' => true,
        'samesite' => 'Strict'
    ]);
    session_start();
}

// Veritabanı ayarları
define('DB_HOST', 'localhost');
define('DB_NAME', 'enbmedya_domain');
define('DB_USER', 'enbmedya_domain');
define('DB_PASS', 'Qwerty41*41');
define('DB_CHARSET', 'utf8mb4');

// Sistem ayarları
define('SITE_NAME', 'Domain Takip Sistemi');
define('ADMIN_SESSION_NAME', 'domain_admin_logged_in');
define('TIMEZONE', 'Europe/Istanbul');

// Zaman dilimi ayarla
date_default_timezone_set(TIMEZONE);

// Veritabanı bağlantısı
try {
    $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=" . DB_CHARSET;
    $pdo = new PDO($dsn, DB_USER, DB_PASS, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES => false,
    ]);
} catch (PDOException $e) {
    die("Veritabanı bağlantı hatası: " . $e->getMessage());
}

// Yardımcı fonksiyonlar
function isLoggedIn() {
    return isset($_SESSION[ADMIN_SESSION_NAME]) && $_SESSION[ADMIN_SESSION_NAME] === true;
}

function requireLogin() {
    if (!isLoggedIn()) {
        header('Location: login.php');
        exit;
    }
}

function redirect($url) {
    header("Location: $url");
    exit;
}

function sanitize($data) {
    if (!is_string($data)) {
        $data = '';
    }
    return htmlspecialchars(trim($data), ENT_QUOTES, 'UTF-8');
}

function formatDate($date) {
    if (!$date) return '-';
    return date('d.m.Y', strtotime($date));
}

function getDaysUntilExpiry($expirationDate) {
    if (!$expirationDate) return null;
    $now = new DateTime();
    $expiry = new DateTime($expirationDate);
    $diff = $now->diff($expiry);
    return $diff->invert ? -$diff->days : $diff->days;
}

function getExpiryStatus($days) {
    if ($days === null) return 'unknown';
    if ($days < 0) return 'expired';
    if ($days <= 7) return 'critical';
    if ($days <= 30) return 'warning';
    return 'ok';
}
?>

