<?php
/**
 * Domain Takip Sistemi - SQLite Test Konfigürasyonu
 */

// Hata raporlama
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Oturum ayarları
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Sistem ayarları
define('SITE_NAME', 'Domain Takip Sistemi');
define('ADMIN_SESSION_NAME', 'domain_admin_logged_in');
define('TIMEZONE', 'Europe/Istanbul');

// Zaman dilimi ayarla
date_default_timezone_set(TIMEZONE);

// SQLite veritabanı bağlantısı
try {
    $dbPath = __DIR__ . '/../data/domain_tracker.sqlite';
    $dbDir = dirname($dbPath);
    
    // Data klasörünü oluştur
    if (!is_dir($dbDir)) {
        mkdir($dbDir, 0755, true);
    }
    
    $pdo = new PDO("sqlite:$dbPath", null, null, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    ]);
    
    // Tabloları oluştur
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS admin_users (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            username VARCHAR(50) NOT NULL UNIQUE,
            password VARCHAR(255) NOT NULL,
            email VARCHAR(100),
            created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
            last_login DATETIME,
            is_active INTEGER DEFAULT 1
        )
    ");
    
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS domains (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            domain_name VARCHAR(255) NOT NULL UNIQUE,
            registrar VARCHAR(255),
            registration_date DATE,
            expiration_date DATE,
            nameservers TEXT,
            status VARCHAR(50),
            auto_renew INTEGER DEFAULT 0,
            notes TEXT,
            created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
            updated_at DATETIME DEFAULT CURRENT_TIMESTAMP,
            last_checked DATETIME
        )
    ");
    
    // Varsayılan admin kullanıcısını ekle (şifre: admin123)
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM admin_users WHERE username = 'admin'");
    $stmt->execute();
    if ($stmt->fetchColumn() == 0) {
        $stmt = $pdo->prepare("INSERT INTO admin_users (username, password, email) VALUES (?, ?, ?)");
        $stmt->execute(['admin', password_hash('admin123', PASSWORD_DEFAULT), 'admin@example.com']);
    }
    
} catch (PDOException $e) {
    die("Veritabanı bağlantı hatası: " . $e->getMessage());
}

// Yardımcı fonksiyonlar
function isLoggedIn() {
    return isset($_SESSION[ADMIN_SESSION_NAME]) && $_SESSION[ADMIN_SESSION_NAME] === true;
}

function requireLogin() {
    if (!isLoggedIn()) {
        header('Location: login.php');
        exit;
    }
}

function redirect($url) {
    header("Location: $url");
    exit;
}

function sanitize($data) {
    return htmlspecialchars(trim($data), ENT_QUOTES, 'UTF-8');
}

function formatDate($date) {
    if (!$date) return '-';
    return date('d.m.Y', strtotime($date));
}

function getDaysUntilExpiry($expirationDate) {
    if (!$expirationDate) return null;
    $now = new DateTime();
    $expiry = new DateTime($expirationDate);
    $diff = $now->diff($expiry);
    return $diff->invert ? -$diff->days : $diff->days;
}

function getExpiryStatus($days) {
    if ($days === null) return 'unknown';
    if ($days < 0) return 'expired';
    if ($days <= 7) return 'critical';
    if ($days <= 30) return 'warning';
    return 'ok';
}
?>

