<?php
/**
 * Domain Takip Sistemi - Cron Job Yolu Bulucu
 * 
 * Bu script gerçek cron job yolunu gösterir.
 * SSH'da çalıştırın: php cron/get_cron_path.php
 */

// Script'in CLI'dan çalıştırıldığından emin ol
if (php_sapi_name() !== 'cli') {
    die("Bu script sadece komut satırından çalıştırılabilir.\n");
}

echo "\n";
echo "========================================\n";
echo "Domain Takip Sistemi - Cron Job Yolu\n";
echo "========================================\n\n";

// PHP yolunu bul
$phpPath = '/usr/bin/php'; // Varsayılan
$detectedPhp = exec('which php 2>/dev/null');
if ($detectedPhp) {
    $phpPath = trim($detectedPhp);
}

echo "PHP Yolu: $phpPath\n";

// Proje kök dizinini bul
$projectRoot = dirname(__DIR__);
$cronScript = $projectRoot . '/cron/check_expiring_domains.php';

echo "Proje Dizini: $projectRoot\n";
echo "Cron Script: $cronScript\n\n";

// Dosya var mı kontrol et
if (file_exists($cronScript)) {
    echo "✓ Cron script dosyası bulundu.\n";
} else {
    echo "✗ HATA: Cron script dosyası bulunamadı!\n";
    exit(1);
}

// Dosya çalıştırılabilir mi kontrol et
if (is_executable($cronScript)) {
    echo "✓ Cron script çalıştırılabilir.\n";
} else {
    echo "⚠ UYARI: Cron script çalıştırılabilir değil. Şu komutu çalıştırın:\n";
    echo "   chmod +x $cronScript\n";
}

echo "\n";
echo "========================================\n";
echo "Cron Job Komutu:\n";
echo "========================================\n";
echo "0 9 * * * $phpPath $cronScript\n\n";

echo "Veya tüm domainleri güncellemek için:\n";
echo "0 9 * * * $phpPath $cronScript --update-all\n\n";

echo "Crontab'a eklemek için:\n";
echo "crontab -e\n\n";

echo "Mevcut crontab'ı görmek için:\n";
echo "crontab -l\n\n";

echo "========================================\n";
echo "Test Çalıştırma:\n";
echo "========================================\n";
echo "Test için manuel çalıştırın:\n";
echo "$phpPath $cronScript\n\n";

