#!/bin/bash

# Domain Takip Sistemi - Cron Job Kurulum Scripti
# Bu script otomatik domain kontrol cron job'unu kurar

# Renk kodları
RED='\033[0;31m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
NC='\033[0m' # No Color

echo -e "${GREEN}Domain Takip Sistemi - Cron Job Kurulumu${NC}"
echo "=================================================="

# Proje dizinini belirle
SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
PROJECT_DIR="$(dirname "$SCRIPT_DIR")"

echo -e "${YELLOW}Proje dizini:${NC} $PROJECT_DIR"

# PHP yolunu bul
PHP_PATH=$(which php)
if [ -z "$PHP_PATH" ]; then
    echo -e "${RED}HATA: PHP bulunamadı. Lütfen PHP'nin kurulu olduğundan emin olun.${NC}"
    exit 1
fi

echo -e "${YELLOW}PHP yolu:${NC} $PHP_PATH"

# Cron script dosyasının varlığını kontrol et
CRON_SCRIPT="$PROJECT_DIR/cron/check_expiring_domains.php"
if [ ! -f "$CRON_SCRIPT" ]; then
    echo -e "${RED}HATA: Cron script dosyası bulunamadı: $CRON_SCRIPT${NC}"
    exit 1
fi

# Script'i çalıştırılabilir yap
chmod +x "$CRON_SCRIPT"

# Log dizinini oluştur
LOG_DIR="$PROJECT_DIR/logs"
mkdir -p "$LOG_DIR"
chmod 755 "$LOG_DIR"

echo -e "${GREEN}Log dizini oluşturuldu:${NC} $LOG_DIR"

# Cron job satırını oluştur
CRON_JOB="0 9 * * * $PHP_PATH $CRON_SCRIPT --update-all >> $LOG_DIR/cron.log 2>&1"

echo -e "${YELLOW}Cron job satırı:${NC}"
echo "$CRON_JOB"

# Mevcut crontab'ı kontrol et
echo ""
echo -e "${YELLOW}Mevcut crontab kontrol ediliyor...${NC}"

# Geçici dosya oluştur
TEMP_CRON=$(mktemp)

# Mevcut crontab'ı al (hata varsa boş dosya oluştur)
crontab -l > "$TEMP_CRON" 2>/dev/null || touch "$TEMP_CRON"

# Bu job zaten var mı kontrol et
if grep -q "check_expiring_domains.php" "$TEMP_CRON"; then
    echo -e "${YELLOW}Domain kontrol cron job'u zaten mevcut.${NC}"
    echo -e "${YELLOW}Mevcut job'u güncellemek istiyor musunuz? (y/n):${NC}"
    read -r response
    
    if [[ "$response" =~ ^[Yy]$ ]]; then
        # Eski job'u kaldır
        grep -v "check_expiring_domains.php" "$TEMP_CRON" > "${TEMP_CRON}.new"
        mv "${TEMP_CRON}.new" "$TEMP_CRON"
        echo -e "${GREEN}Eski cron job kaldırıldı.${NC}"
    else
        echo -e "${YELLOW}Kurulum iptal edildi.${NC}"
        rm "$TEMP_CRON"
        exit 0
    fi
fi

# Yeni job'u ekle
echo "$CRON_JOB" >> "$TEMP_CRON"

# Crontab'ı güncelle
if crontab "$TEMP_CRON"; then
    echo -e "${GREEN}✓ Cron job başarıyla kuruldu!${NC}"
    echo ""
    echo -e "${GREEN}Kurulum Detayları:${NC}"
    echo "- Çalışma zamanı: Her gün saat 09:00"
    echo "- Script yolu: $CRON_SCRIPT"
    echo "- Log dosyası: $LOG_DIR/cron.log"
    echo ""
    echo -e "${YELLOW}Test için manuel çalıştırma:${NC}"
    echo "$PHP_PATH $CRON_SCRIPT"
    echo ""
    echo -e "${YELLOW}Cron job'u kaldırmak için:${NC}"
    echo "crontab -e"
    echo ""
    echo -e "${GREEN}Kurulum tamamlandı!${NC}"
else
    echo -e "${RED}HATA: Cron job kurulamadı.${NC}"
    rm "$TEMP_CRON"
    exit 1
fi

# Geçici dosyayı temizle
rm "$TEMP_CRON"

# Test çalıştırması öner
echo ""
echo -e "${YELLOW}Test çalıştırması yapmak istiyor musunuz? (y/n):${NC}"
read -r test_response

if [[ "$test_response" =~ ^[Yy]$ ]]; then
    echo -e "${YELLOW}Test çalıştırması başlatılıyor...${NC}"
    echo ""
    $PHP_PATH "$CRON_SCRIPT"
    echo ""
    echo -e "${GREEN}Test tamamlandı. Log dosyasını kontrol edin:${NC}"
    echo "tail -f $LOG_DIR/cron.log"
fi

echo ""
echo -e "${GREEN}Kurulum başarıyla tamamlandı!${NC}"

