<?php
require_once 'config/config.php';
require_once 'includes/domain_functions.php';

// Giriş kontrolü
requireLogin();

// İstatistikleri çek
try {
    // Toplam domain sayısı
    $stmt = $pdo->query("SELECT COUNT(*) as total FROM domains");
    $totalDomains = $stmt->fetch()['total'];
    
    // Süresi yaklaşan domainler (30 gün içinde)
    $stmt = $pdo->query("
        SELECT COUNT(*) as expiring 
        FROM domains 
        WHERE TIMESTAMPDIFF(DAY, CURDATE(), expiration_date) BETWEEN 0 AND 30 
        AND expiration_date IS NOT NULL
    ");
    $expiringDomains = $stmt->fetch()['expiring'];
    
    // Süresi geçmiş domainler
    $stmt = $pdo->query("
        SELECT COUNT(*) as expired 
        FROM domains 
        WHERE TIMESTAMPDIFF(DAY, CURDATE(), expiration_date) < 0
    ");
    $expiredDomains = $stmt->fetch()['expired'];
    
    // Son eklenen domainler
    $stmt = $pdo->query("SELECT domain_name, created_at FROM domains ORDER BY created_at DESC LIMIT 5");
    $recentDomains = $stmt->fetchAll();
    
    // Kritik domainler (7 gün içinde süresi dolacak)
    $stmt = $pdo->query("
        SELECT domain_name, expiration_date,
               TIMESTAMPDIFF(DAY, CURDATE(), expiration_date) as days_until_expiry
        FROM domains 
        WHERE TIMESTAMPDIFF(DAY, CURDATE(), expiration_date) BETWEEN 0 AND 7 
        AND expiration_date IS NOT NULL
        ORDER BY days_until_expiry ASC 
        LIMIT 10
    ");
    $criticalDomains = $stmt->fetchAll();
    
} catch (PDOException $e) {
    error_log("Dashboard stats error: " . $e->getMessage());
    $totalDomains = $expiringDomains = $expiredDomains = 0;
    $recentDomains = $criticalDomains = [];
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= SITE_NAME ?> - Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link href="assets/css/admin.css" rel="stylesheet">
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="container-fluid">
        <div class="row">
            <?php include 'includes/sidebar.php'; ?>
            
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2"><i class="fas fa-tachometer-alt me-2"></i>Dashboard</h1>
                    <div class="btn-toolbar mb-2 mb-md-0">
                        <div class="btn-group me-2">
                            <a href="domains.php?action=add" class="btn btn-primary">
                                <i class="fas fa-plus me-1"></i>Yeni Domain
                            </a>
                        </div>
                    </div>
                </div>
                
                <!-- İstatistik Kartları -->
                <div class="row mb-4">
                    <div class="col-xl-3 col-md-6 mb-4">
                        <div class="card border-left-primary shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                            Toplam Domain
                                        </div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800"><?= $totalDomains ?></div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="fas fa-globe fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-xl-3 col-md-6 mb-4">
                        <div class="card border-left-warning shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                            Süresi Yaklaşan
                                        </div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800"><?= $expiringDomains ?></div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="fas fa-exclamation-triangle fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-xl-3 col-md-6 mb-4">
                        <div class="card border-left-danger shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                                            Süresi Geçmiş
                                        </div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800"><?= $expiredDomains ?></div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="fas fa-times-circle fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-xl-3 col-md-6 mb-4">
                        <div class="card border-left-info shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                            Son Kontrol
                                        </div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800"><?= date('d.m.Y H:i') ?></div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="fas fa-clock fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <!-- Kritik Domainler -->
                    <div class="col-lg-6 mb-4">
                        <div class="card shadow">
                            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                                <h6 class="m-0 font-weight-bold text-danger">
                                    <i class="fas fa-exclamation-triangle me-2"></i>Kritik Domainler
                                </h6>
                            </div>
                            <div class="card-body">
                                <?php if (empty($criticalDomains)): ?>
                                    <div class="text-center text-muted py-4">
                                        <i class="fas fa-check-circle fa-3x mb-3"></i>
                                        <p>Kritik durumda domain bulunmuyor.</p>
                                    </div>
                                <?php else: ?>
                                    <div class="table-responsive">
                                        <table class="table table-sm">
                                            <thead>
                                                <tr>
                                                    <th>Domain</th>
                                                    <th>Bitiş Tarihi</th>
                                                    <th>Kalan Gün</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach ($criticalDomains as $domain): ?>
                                                    <tr>
                                                        <td><?= sanitize($domain['domain_name']) ?></td>
                                                        <td><?= formatDate($domain['expiration_date']) ?></td>
                                                        <td>
                                                            <span class="badge bg-danger">
                                                                <?= $domain['days_until_expiry'] ?> gün
                                                            </span>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Son Eklenen Domainler -->
                    <div class="col-lg-6 mb-4">
                        <div class="card shadow">
                            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                                <h6 class="m-0 font-weight-bold text-primary">
                                    <i class="fas fa-plus-circle me-2"></i>Son Eklenen Domainler
                                </h6>
                            </div>
                            <div class="card-body">
                                <?php if (empty($recentDomains)): ?>
                                    <div class="text-center text-muted py-4">
                                        <i class="fas fa-globe fa-3x mb-3"></i>
                                        <p>Henüz domain eklenmemiş.</p>
                                        <a href="domains.php?action=add" class="btn btn-primary btn-sm">
                                            <i class="fas fa-plus me-1"></i>İlk Domain'i Ekle
                                        </a>
                                    </div>
                                <?php else: ?>
                                    <div class="list-group list-group-flush">
                                        <?php foreach ($recentDomains as $domain): ?>
                                            <div class="list-group-item d-flex justify-content-between align-items-center">
                                                <div>
                                                    <h6 class="mb-1"><?= sanitize($domain['domain_name']) ?></h6>
                                                    <small class="text-muted">
                                                        <i class="fas fa-calendar me-1"></i>
                                                        <?= formatDate($domain['created_at']) ?>
                                                    </small>
                                                </div>
                                                <span class="badge bg-primary rounded-pill">Yeni</span>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </main>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="assets/js/admin.js"></script>
</body>
</html>

